/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.fluids;

import com.teamresourceful.resourcefullib.common.fluid.data.FluidData;
import com.telepathicgrunt.the_bumblezone.fluids.base.BzFluid;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public abstract class SugarWaterFluid
extends BzFluid {
    protected SugarWaterFluid(FluidData properties, boolean source) {
        super(properties, source);
    }

    @Override
    public Fluid getFlowing() {
        return (Fluid)BzFluids.SUGAR_WATER_FLUID_FLOWING.get();
    }

    @Override
    public Fluid getSource() {
        return (Fluid)BzFluids.SUGAR_WATER_FLUID.get();
    }

    @Override
    public Item getBucket() {
        return (Item)BzItems.SUGAR_WATER_BUCKET.get();
    }

    public void randomTick(Level level, BlockPos position, FluidState state, RandomSource random) {
        int startIndex;
        if (random.nextBoolean() || !level.hasChunksAt(position, position)) {
            return;
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int currentIndex = startIndex = random.nextInt(4); currentIndex < startIndex + 4; ++currentIndex) {
            Optional<Integer> agePropertyMaxAge;
            Direction direction = Direction.from2DDataValue((int)currentIndex);
            mutablePos.set((Vec3i)position).move(direction).move(Direction.UP);
            BlockState sideCropState = level.getBlockState((BlockPos)mutablePos);
            if (!sideCropState.is(BzTags.SUGAR_WATER_GROWS_PLANT_FASTER)) continue;
            if (sideCropState.getBlock() instanceof SugarCaneBlock) {
                BlockState newTopSugarCaneLikeBlock;
                Optional<Integer> agePropertyMaxAge2;
                int height;
                if (level.getBlockState(mutablePos.below()).getBlock() instanceof SugarCaneBlock) continue;
                for (height = 1; sideCropState.getBlock() == Blocks.SUGAR_CANE && height <= 5; ++height) {
                    sideCropState = level.getBlockState((BlockPos)mutablePos.move(Direction.UP));
                }
                if (height >= 6) continue;
                mutablePos.move(Direction.DOWN);
                BlockState topSugarCaneLikeBlock = level.getBlockState((BlockPos)mutablePos);
                Optional<Property<Integer>> blockCurrentAge = GeneralUtils.getBlockCurrentAge(topSugarCaneLikeBlock);
                if (!blockCurrentAge.isPresent() || !(agePropertyMaxAge2 = GeneralUtils.getAgePropertyMaxAge(blockCurrentAge.get())).isPresent()) continue;
                if (agePropertyMaxAge2.get().equals(topSugarCaneLikeBlock.getValue(blockCurrentAge.get()))) {
                    mutablePos.move(Direction.UP);
                    newTopSugarCaneLikeBlock = (BlockState)topSugarCaneLikeBlock.setValue(blockCurrentAge.get(), (Comparable)Integer.valueOf(0));
                    newTopSugarCaneLikeBlock = GeneralUtils.copyNonAgeProperties(topSugarCaneLikeBlock, newTopSugarCaneLikeBlock);
                    level.setBlock((BlockPos)mutablePos, newTopSugarCaneLikeBlock, 3);
                    continue;
                }
                newTopSugarCaneLikeBlock = (BlockState)topSugarCaneLikeBlock.setValue(blockCurrentAge.get(), (Comparable)Integer.valueOf((Integer)topSugarCaneLikeBlock.getValue(blockCurrentAge.get()) + 1));
                newTopSugarCaneLikeBlock = GeneralUtils.copyNonAgeProperties(topSugarCaneLikeBlock, newTopSugarCaneLikeBlock);
                level.setBlock((BlockPos)mutablePos, newTopSugarCaneLikeBlock, 3);
                continue;
            }
            Optional<Property<Integer>> blockCurrentAge = GeneralUtils.getBlockCurrentAge(sideCropState);
            if (!blockCurrentAge.isPresent() || !(agePropertyMaxAge = GeneralUtils.getAgePropertyMaxAge(blockCurrentAge.get())).isPresent() || agePropertyMaxAge.get().equals(sideCropState.getValue(blockCurrentAge.get()))) continue;
            BlockState newSideCropState = (BlockState)sideCropState.setValue(blockCurrentAge.get(), (Comparable)Integer.valueOf((Integer)sideCropState.getValue(blockCurrentAge.get()) + 1));
            newSideCropState = GeneralUtils.copyNonAgeProperties(sideCropState, newSideCropState);
            level.setBlock((BlockPos)mutablePos, newSideCropState, 3);
        }
    }

    public void animateTick(Level worldIn, BlockPos pos, FluidState state, RandomSource random) {
        if (!state.isSource() && !((Boolean)state.getValue((Property)FALLING)).booleanValue()) {
            if (random.nextInt(64) == 0) {
                worldIn.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.WATER_AMBIENT, SoundSource.BLOCKS, random.nextFloat() * 0.25f + 0.75f, random.nextFloat() + 0.5f, false);
            }
        } else if (random.nextInt(10) == 0) {
            worldIn.addParticle((ParticleOptions)ParticleTypes.UNDERWATER, (double)pos.getX() + (double)random.nextFloat(), (double)pos.getY() + (double)random.nextFloat(), (double)pos.getZ() + (double)random.nextFloat(), 0.0, 0.0, 0.0);
        }
    }

    public ParticleOptions getDripParticle() {
        return ParticleTypes.DRIPPING_WATER;
    }

    protected boolean isRandomlyTicking() {
        return true;
    }

    @Override
    public int getTickDelay(LevelReader world) {
        return 5;
    }

    @Override
    protected float getExplosionResistance() {
        return 100.0f;
    }

    @Override
    protected void beforeDestroyingBlock(LevelAccessor world, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = state.hasBlockEntity() ? world.getBlockEntity(pos) : null;
        Block.dropResources((BlockState)state, (LevelAccessor)world, (BlockPos)pos, (BlockEntity)blockEntity);
    }

    @Override
    public int getSlopeFindDistance(LevelReader world) {
        return 4;
    }

    @Override
    public int getDropOff(LevelReader world) {
        return 1;
    }

    @Override
    public boolean isSame(Fluid fluid) {
        return fluid.is(BzTags.VISUAL_WATER_FLUID);
    }

    @Override
    public boolean canBeReplacedWith(FluidState state, BlockGetter world, BlockPos pos, Fluid fluid, Direction direction) {
        return direction == Direction.DOWN && !fluid.is(FluidTags.WATER);
    }

    @Override
    public BlockState createLegacyBlock(FluidState state) {
        return (BlockState)((LiquidBlock)BzFluids.SUGAR_WATER_BLOCK.get()).defaultBlockState().setValue((Property)BlockStateProperties.LEVEL, (Comparable)Integer.valueOf(SugarWaterFluid.getLegacyLevel((FluidState)state)));
    }

    public final boolean canHoldFluid(BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        Block block = blockState.getBlock();
        if (block instanceof LiquidBlockContainer) {
            LiquidBlockContainer liquidBlockContainer = (LiquidBlockContainer)block;
            return liquidBlockContainer.canPlaceLiquid(null, blockGetter, blockPos, blockState, fluid) || ((LiquidBlockContainer)block).canPlaceLiquid(null, blockGetter, blockPos, blockState, (Fluid)(fluid == BzFluids.SUGAR_WATER_FLUID.get() ? Fluids.WATER : Fluids.FLOWING_WATER));
        }
        if (block instanceof DoorBlock || blockState.is(BlockTags.SIGNS) || blockState.is(Blocks.LADDER) || blockState.is(Blocks.SUGAR_CANE) || blockState.is(Blocks.BUBBLE_COLUMN)) {
            return false;
        }
        if (blockState.is(BlockTags.PORTALS) || blockState.is(Blocks.STRUCTURE_VOID) || blockState.is(BlockTags.UNDERWATER_BONEMEALS) || blockState.is(Blocks.KELP) || blockState.is(Blocks.KELP_PLANT)) {
            return false;
        }
        return !blockState.blocksMotion();
    }

    protected void spreadTo(LevelAccessor levelAccessor, BlockPos blockPos, BlockState blockState, Direction direction, FluidState fluidState) {
        Block block = blockState.getBlock();
        if (block instanceof LiquidBlockContainer) {
            LiquidBlockContainer liquidBlockContainer;
            boolean canPlaceLiquid = (liquidBlockContainer = (LiquidBlockContainer)block).canPlaceLiquid(null, (BlockGetter)levelAccessor, blockPos, blockState, fluidState.getType());
            liquidBlockContainer.placeLiquid(levelAccessor, blockPos, blockState, canPlaceLiquid ? fluidState : Fluids.WATER.defaultFluidState());
        } else {
            if (!blockState.isAir()) {
                this.beforeDestroyingBlock(levelAccessor, blockPos, blockState);
            }
            levelAccessor.setBlock(blockPos, fluidState.createLegacyBlock(), 3);
        }
    }

    public static boolean isBlockAllowedForSugarWaterWaterlogging(BlockState blockState) {
        return blockState.is(BzTags.WATERLOGGABLE_BLOCKS_WHEN_PLACED_IN_FLUID) && !blockState.is(BzTags.FORCED_DISALLOW_WATERLOGGING_BLOCKS_WHEN_PLACED_IN_FLUID);
    }

    public static class Source
    extends SugarWaterFluid {
        public Source(FluidData properties) {
            super(properties, true);
        }

        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }

        @Override
        protected boolean canConvertToSource(Level level) {
            return level.getGameRules().getBoolean(GameRules.RULE_WATER_SOURCE_CONVERSION);
        }
    }

    public static class Flowing
    extends SugarWaterFluid {
        public Flowing(FluidData properties) {
            super(properties, false);
            this.registerDefaultState((FluidState)((FluidState)this.getStateDefinition().any()).setValue((Property)LEVEL, (Comparable)Integer.valueOf(7)));
        }

        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{BlockStateProperties.LEVEL_FLOWING});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)BlockStateProperties.LEVEL_FLOWING);
        }

        public boolean isSource(FluidState state) {
            return false;
        }

        @Override
        protected boolean canConvertToSource(Level level) {
            return level.getGameRules().getBoolean(GameRules.RULE_WATER_SOURCE_CONVERSION);
        }
    }
}

