/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.teleportation;

import com.telepathicgrunt.the_bumblezone.entities.teleportation.EntityTeleportationHookup;
import com.telepathicgrunt.the_bumblezone.events.entity.BzProjectileHitEvent;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class ProjectileImpact {
    public static boolean onProjectileImpact(BzProjectileHitEvent event) {
        Projectile projectile = event.projectile();
        if (projectile.getOwner() == null) {
            return false;
        }
        if (!ModChecker.PROJECTILE_IMPACT_HANDLED_COMPATS.isEmpty()) {
            for (ModCompat compat : ModChecker.PROJECTILE_IMPACT_HANDLED_COMPATS) {
                InteractionResult result = compat.isProjectileTeleportHandled(event.hitResult(), projectile.getOwner(), projectile);
                if (result == InteractionResult.PASS) continue;
                return result == InteractionResult.SUCCESS;
            }
        }
        if (projectile.getType().is(BzTags.TELEPORT_PROJECTILES) && projectile.getOwner() != null) {
            HitResult hitResult;
            if (event.hitResult() != null && (hitResult = event.hitResult()) instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                return EntityTeleportationHookup.runTeleportProjectileImpact((HitResult)blockHitResult, projectile.getOwner(), (Entity)projectile);
            }
            if (event.hitResult() != null && (hitResult = event.hitResult()) instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)hitResult;
                return EntityTeleportationHookup.runEntityHitCheck((HitResult)entityHitResult, projectile.getOwner(), projectile);
            }
        }
        return false;
    }
}

