/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.goals;

import com.telepathicgrunt.the_bumblezone.entities.mobs.RootminEntity;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class RootminNearestAttackableTargetGoal
extends TargetGoal {
    private static final int DEFAULT_RANDOM_INTERVAL = 10;
    protected final TargetingConditions targetConditions;
    protected final int randomInterval;
    @Nullable
    protected LivingEntity target;

    public RootminNearestAttackableTargetGoal(Mob mob, boolean mustSee) {
        this(mob, 10, mustSee, null);
    }

    public RootminNearestAttackableTargetGoal(Mob mob, boolean mustSee, Predicate<LivingEntity> targetPredicate) {
        this(mob, 10, mustSee, targetPredicate);
    }

    public RootminNearestAttackableTargetGoal(Mob mob, int randomInterval, boolean mustSee, @Nullable Predicate<LivingEntity> targetPredicate) {
        super(mob, mustSee, false);
        this.randomInterval = RootminNearestAttackableTargetGoal.reducedTickDelay((int)randomInterval);
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
        this.targetConditions = TargetingConditions.forCombat().range(this.getFollowDistance()).selector(targetPredicate);
    }

    public boolean canUse() {
        block3: {
            block2: {
                if (this.randomInterval > 0 && this.mob.getRandom().nextInt(this.randomInterval) != 0) break block2;
                Mob mob = this.mob;
                if (!(mob instanceof RootminEntity)) break block3;
                RootminEntity rootminEntity = (RootminEntity)mob;
                if (!rootminEntity.disableAttackGoals) break block3;
            }
            return false;
        }
        this.findTarget();
        return this.target != null;
    }

    protected AABB getTargetSearchArea(double d) {
        return this.mob.getBoundingBox().inflate(d, 4.0, d);
    }

    protected void findTarget() {
        this.target = this.mob.level().getNearestEntity(this.mob.level().getEntitiesOfClass(LivingEntity.class, this.getTargetSearchArea(this.getFollowDistance()), livingEntity -> {
            Mob patt0$temp = this.mob;
            if (patt0$temp instanceof RootminEntity) {
                RootminEntity rootminEntity = (RootminEntity)patt0$temp;
                return rootminEntity.canTarget((LivingEntity)livingEntity);
            }
            return false;
        }), this.targetConditions, (LivingEntity)this.mob, this.mob.getX(), this.mob.getEyeY(), this.mob.getZ());
    }

    public void start() {
        this.mob.setTarget(this.target);
        super.start();
    }
}

