/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.variantbee;

import com.telepathicgrunt.the_bumblezone.entities.mobs.VariantBeeEntity;
import net.minecraft.client.renderer.entity.BeeRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.Bee;

public class VariantBeeRenderer
extends BeeRenderer {
    private static final ResourceLocation VANILLA_BEE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/bee/bee.png");

    public VariantBeeRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public ResourceLocation getTextureLocation(Bee entity) {
        String variant = ((VariantBeeEntity)entity).getVariant();
        if (variant != null && !variant.isEmpty()) {
            String type = "";
            boolean angry = entity.isAngry();
            boolean nectar = entity.hasNectar();
            if (angry) {
                type = nectar ? "_angry_nectar" : "_angry";
            } else if (nectar) {
                type = "_nectar";
            }
            String path = String.format("textures/entity/bee_variants/%s/bee%s.png", variant, type);
            return ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)path);
        }
        return VANILLA_BEE_TEXTURE;
    }
}

