/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.blocks.EssenceBlock;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.EssenceBlockEntity;
import com.telepathicgrunt.the_bumblezone.bossbars.ServerEssenceEvent;
import com.telepathicgrunt.the_bumblezone.entities.nonliving.PurpleSpikeEntity;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzStats;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.packets.MusicPacketFromServer;
import java.util.List;
import java.util.UUID;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;

public class EssenceBlockPurple
extends EssenceBlock {
    public static final MapCodec<EssenceBlockPurple> CODEC = Block.simpleCodec(EssenceBlockPurple::new);
    public static final int INTERVALS = 36;

    public EssenceBlockPurple() {
        this(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).strength(-1.0f, 3600000.8f).lightLevel(blockState -> 15).noLootTable().forceSolidOn().isValidSpawn((blockState, blockGetter, blockPos, entityType) -> false).isViewBlocking((blockState, blockGetter, blockPos) -> false).pushReaction(PushReaction.BLOCK));
    }

    public EssenceBlockPurple(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public MapCodec<? extends EssenceBlockPurple> codec() {
        return CODEC;
    }

    @Override
    public ResourceLocation getArenaNbt() {
        return ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"essence/purple_arena");
    }

    @Override
    public int getEventTimeFrame() {
        return 5020;
    }

    @Override
    public ServerEssenceEvent getServerEssenceEvent() {
        return (ServerEssenceEvent)new ServerEssenceEvent("essence.the_bumblezone.purple_essence_event", BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS).setDarkenScreen(true);
    }

    @Override
    public ResourceLocation getEssenceItemReward() {
        return ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"gameplay/rewards/purple_arena_victory");
    }

    @Override
    public int getEssenceXpReward() {
        return 3000;
    }

    @Override
    public boolean hasMiningFatigue() {
        return true;
    }

    @Override
    public void awardPlayerWinStat(ServerPlayer serverPlayer) {
        serverPlayer.awardStat((ResourceLocation)BzStats.KNOWING_EVENT_DEFEATED_RL.get());
    }

    @Override
    public void performUniqueArenaTick(ServerLevel serverLevel, BlockPos blockPos, BlockState blockState, EssenceBlockEntity essenceBlockEntity) {
        List<EssenceBlockEntity.EventEntities> eventEntitiesInArena;
        if (essenceBlockEntity.getPlayerInArena().isEmpty()) {
            return;
        }
        int timeRemaining = essenceBlockEntity.getEventTimer();
        if (timeRemaining % 5 == 0) {
            for (UUID playerUUID : essenceBlockEntity.getPlayerInArena()) {
                ServerPlayer player = serverLevel.getServer().getPlayerList().getPlayer(playerUUID);
                if (player == null) continue;
                EssenceBlockPurple.breakClimbablesAndPlatforms(serverLevel, (Player)player);
            }
        }
        if ((eventEntitiesInArena = essenceBlockEntity.getEventEntitiesInArena()).isEmpty()) {
            EssenceBlockPurple.spawnEntities(serverLevel, blockPos, essenceBlockEntity, eventEntitiesInArena, false);
        } else {
            for (int i = eventEntitiesInArena.size() - 1; i >= 0; --i) {
                UUID entityToCheck = eventEntitiesInArena.get(i).uuid();
                Entity entity = serverLevel.getEntity(entityToCheck);
                if (entity == null) {
                    List nearbyRings = serverLevel.getEntitiesOfClass(PurpleSpikeEntity.class, new AABB((double)((float)blockPos.getX() - (float)essenceBlockEntity.getArenaSize().getX() * 0.5f), (double)((float)blockPos.getY() - (float)essenceBlockEntity.getArenaSize().getY() * 0.5f), (double)((float)blockPos.getZ() - (float)essenceBlockEntity.getArenaSize().getZ() * 0.5f), (double)((float)blockPos.getX() + (float)essenceBlockEntity.getArenaSize().getX() * 0.5f), (double)((float)blockPos.getY() + (float)essenceBlockEntity.getArenaSize().getY() * 0.5f), (double)((float)blockPos.getZ() + (float)essenceBlockEntity.getArenaSize().getZ() * 0.5f)));
                    for (PurpleSpikeEntity nearbySpike : nearbyRings) {
                        if (!nearbySpike.getUUID().equals(entityToCheck) || !nearbySpike.getEssenceController().equals(essenceBlockEntity.getUUID())) continue;
                        entity = nearbySpike;
                        break;
                    }
                }
                if (entity != null) continue;
                for (int k = eventEntitiesInArena.size() - 1; k >= 0; --k) {
                    UUID entityUUIDToRemove = eventEntitiesInArena.remove(k).uuid();
                    Entity entityEntityToRemove = serverLevel.getEntity(entityUUIDToRemove);
                    if (entityEntityToRemove == null) continue;
                    entityEntityToRemove.remove(Entity.RemovalReason.DISCARDED);
                }
                EssenceBlockPurple.spawnEntities(serverLevel, blockPos, essenceBlockEntity, eventEntitiesInArena, true);
                break;
            }
            EssenceBlockPurple.ravingTime(serverLevel, timeRemaining, this.getEventTimeFrame(), essenceBlockEntity, eventEntitiesInArena);
        }
        if (timeRemaining == 0) {
            EssenceBlockEntity.EndEvent(serverLevel, blockPos, blockState, essenceBlockEntity, true);
        }
        essenceBlockEntity.getEventBar().setProgress((float)essenceBlockEntity.getEventTimer() / (float)this.getEventTimeFrame());
    }

    private static void breakClimbablesAndPlatforms(ServerLevel serverLevel, Player player) {
        BlockState state;
        int maxX = (int)Math.ceil(player.getBoundingBox().maxX);
        int maxY = (int)Math.ceil(player.getBoundingBox().maxY);
        int maxZ = (int)Math.ceil(player.getBoundingBox().maxZ);
        int minX = (int)Math.floor(player.getBoundingBox().minX);
        int minY = (int)Math.floor(player.getBoundingBox().minY);
        int minZ = (int)Math.floor(player.getBoundingBox().minZ);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    mutableBlockPos.set(x, y, z);
                    state = serverLevel.getBlockState((BlockPos)mutableBlockPos);
                    if (state.is(BlockTags.CLIMBABLE)) {
                        serverLevel.destroyBlock((BlockPos)mutableBlockPos, true);
                        continue;
                    }
                    if (state.getFluidState().isEmpty()) continue;
                    serverLevel.setBlock((BlockPos)mutableBlockPos, ((Block)BzBlocks.HEAVY_AIR.get()).defaultBlockState(), 3);
                }
            }
        }
        if (player.mainSupportingBlockPos.isPresent()) {
            int belowY = ((BlockPos)player.mainSupportingBlockPos.get()).getY();
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    mutableBlockPos.set(x, belowY, z);
                    state = serverLevel.getBlockState((BlockPos)mutableBlockPos);
                    if (state.is(BzTags.ESSENCE_BLOCKS) || state.is((Block)BzBlocks.INFINITY_BARRIER.get())) continue;
                    serverLevel.destroyBlock((BlockPos)mutableBlockPos, true);
                }
            }
        }
    }

    private static void spawnEntities(ServerLevel serverLevel, BlockPos blockPos, EssenceBlockEntity essenceBlockEntity, List<EssenceBlockEntity.EventEntities> eventEntitiesInArena, boolean punish) {
        BlockPos arenaSize = essenceBlockEntity.getArenaSize();
        int rowLength = arenaSize.getX() - 2;
        int columnLength = arenaSize.getZ() - 2;
        for (int x = 0; x < rowLength; ++x) {
            for (int z = 0; z < columnLength; ++z) {
                PurpleSpikeEntity spikeEntity = (PurpleSpikeEntity)((EntityType)BzEntities.PURPLE_SPIKE_ENTITY.get()).create((Level)serverLevel);
                if (spikeEntity == null) continue;
                spikeEntity.addTag("the_bumblezone.purple_essence_arena");
                spikeEntity.setEssenceController(essenceBlockEntity.getUUID());
                spikeEntity.setEssenceControllerBlockPos(essenceBlockEntity.getBlockPos());
                spikeEntity.setEssenceControllerDimension((ResourceKey<Level>)serverLevel.dimension());
                spikeEntity.setPos((double)blockPos.getX() - Math.floor((double)arenaSize.getX() / 2.0) + 1.0 + (double)x + 0.5, (double)blockPos.getY() - Math.floor((double)arenaSize.getY() / 2.0) + 1.0, (double)blockPos.getZ() - Math.floor((double)arenaSize.getZ() / 2.0) + 1.0 + (double)z + 0.5);
                eventEntitiesInArena.add(new EssenceBlockEntity.EventEntities(spikeEntity.getUUID()));
                if (punish) {
                    spikeEntity.setSpikeTimer(50);
                }
                serverLevel.addFreshEntityWithPassengers((Entity)spikeEntity);
            }
        }
    }

    private static void ravingTime(ServerLevel serverLevel, int timeRemaining, int eventTimeFrame, EssenceBlockEntity essenceBlockEntity, List<EssenceBlockEntity.EventEntities> eventEntitiesInArena) {
        int currentTime = eventTimeFrame - timeRemaining + 5;
        if (currentTime % 36 == 0) {
            int arenaRadiusSq;
            int intervalOffset;
            BlockPos arenaSize = essenceBlockEntity.getArenaSize();
            int rowLength = arenaSize.getX() - 2;
            int columnLength = arenaSize.getZ() - 2;
            int xRadius = rowLength / 2;
            int zRadius = columnLength / 2;
            int interval = currentTime / 36;
            if (interval < 8 && interval >= 0) {
                intervalOffset = interval - 2;
                arenaRadiusSq = xRadius * xRadius + zRadius * zRadius;
                EssenceBlockPurple.ring(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, arenaRadiusSq, intervalOffset, 0, false);
                EssenceBlockPurple.ring(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, arenaRadiusSq, intervalOffset, -3, false);
            }
            if (interval < 19 && interval >= 8) {
                EssenceBlockPurple.bars(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, arenaSize.getX() / 2, interval - 8, 2, 6, 0);
                EssenceBlockPurple.bars(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, arenaSize.getX() / 2, interval - 8, 2, 6, -3);
                EssenceBlockPurple.bars(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, arenaSize.getX() / 2, interval - 8, 2, 6, -6);
                EssenceBlockPurple.bars(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, arenaSize.getX() / 2, interval - 8, 2, 6, -9);
                EssenceBlockPurple.bars(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, arenaSize.getX() / 2, interval - 8, 2, 6, -12);
                EssenceBlockPurple.bars(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, arenaSize.getX() / 2, interval - 8, 2, 6, -15);
            }
            if (interval < 28 && interval >= 20 && interval % 2 == 0) {
                EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, false, (x, z) -> {
                    int miniX = x / 2;
                    int miniZ = z / 2;
                    if (interval % 4 == 0) {
                        return miniX % 2 == 0;
                    }
                    return miniZ % 2 == 0;
                });
            }
            if (interval < 32 && interval >= 28 && interval % 2 == 0) {
                EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, false, (x, z) -> {
                    if (interval % 4 == 0) {
                        return Math.abs((x + z) % 6) < 2;
                    }
                    return Math.abs((x + z) % 6) >= 2;
                });
            }
            if (interval < 36 && interval >= 32 && interval % 2 == 0) {
                EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, false, (x, z) -> {
                    if (interval % 4 == 0) {
                        return Math.abs((x - z) % 6) < 2;
                    }
                    return Math.abs((x - z) % 6) >= 2;
                });
            }
            if (interval < 41 && interval >= 36 && interval % 2 == 0) {
                EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, false, (x, z) -> {
                    boolean crossLinked;
                    boolean bl = crossLinked = Math.abs((x - z) % 6) < 2 || Math.abs((x + z) % 6) < 2;
                    if (interval % 4 == 0) {
                        return crossLinked;
                    }
                    return !crossLinked;
                });
            }
            if (interval < 63 && interval >= 42) {
                intervalOffset = interval - 42;
                arenaRadiusSq = xRadius * xRadius + zRadius * zRadius;
                EssenceBlockPurple.ring(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, arenaRadiusSq, intervalOffset, 0, true);
                EssenceBlockPurple.ring(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, arenaRadiusSq, intervalOffset, -3, true);
                EssenceBlockPurple.ring(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, arenaRadiusSq, intervalOffset, -6, true);
                EssenceBlockPurple.ring(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, arenaRadiusSq, intervalOffset, -9, true);
                EssenceBlockPurple.ring(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, arenaRadiusSq, intervalOffset, -12, true);
                EssenceBlockPurple.ring(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, arenaRadiusSq, intervalOffset, -15, true);
                EssenceBlockPurple.ring(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, arenaRadiusSq, intervalOffset, -18, true);
                EssenceBlockPurple.ring(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, arenaRadiusSq, intervalOffset, -21, true);
                EssenceBlockPurple.ring(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, arenaRadiusSq, intervalOffset, -24, true);
                EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, true, (x, z) -> {
                    int outerRadius = arenaRadiusSq / 20;
                    int currentRadiusSq = x * x + z * z;
                    return currentRadiusSq < outerRadius + intervalOffset * 4;
                });
            }
            if (interval < 81 && interval >= 64) {
                intervalOffset = interval - 64;
                EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, true, (x, z) -> {
                    float newX = (float)x.intValue() * Mth.cos((float)(intervalOffset * 5)) - (float)z.intValue() * Mth.sin((float)(intervalOffset * 5));
                    float newZ = (float)x.intValue() * Mth.sin((float)(intervalOffset * 5)) + (float)z.intValue() * Mth.cos((float)(intervalOffset * 5));
                    float sinResult = Mth.sin((float)(newX * newZ * ((float)Math.PI / 180)));
                    return (sinResult = Math.abs(sinResult) * Math.abs(sinResult) * Math.abs(sinResult) * Math.abs(sinResult) * Math.abs(sinResult)) < 0.1f;
                });
                if (interval > 71 && interval % 5 == 0) {
                    EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, true, (x, z) -> {
                        int miniX = x / 2;
                        int miniZ = z / 2;
                        if (interval % 4 == 0) {
                            return miniX % 2 == 0;
                        }
                        return miniZ % 2 == 0;
                    });
                }
            }
            if (interval < 90 && interval >= 82 && interval % 2 == 0) {
                EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, false, (x, z) -> {
                    int miniX = x / 6;
                    int miniZ = z / 6;
                    if (interval % 4 == 0) {
                        return Math.abs((miniX + miniZ) % 2) == 0;
                    }
                    return Math.abs((miniX + miniZ) % 2) == 1;
                });
            }
            if (interval < 94 && interval >= 90 && interval % 2 == 0) {
                EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, false, (x, z) -> {
                    int miniX = x / 8;
                    int miniZ = z / 8;
                    if (interval % 4 == 0) {
                        return Math.abs((miniX + miniZ) % 2) == 0;
                    }
                    return Math.abs((miniX + miniZ) % 2) == 1;
                });
            }
            if (interval == 95) {
                EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, 72, 36, true, (x, z) -> {
                    float newX = (float)x.intValue() * Mth.cos((float)0.0f) - (float)z.intValue() * Mth.sin((float)0.0f);
                    float newZ = (float)x.intValue() * Mth.sin((float)0.0f) + (float)z.intValue() * Mth.cos((float)0.0f);
                    float sinResult = Mth.sin((float)(-(newX * newZ) * ((float)Math.PI / 180)));
                    return (sinResult = Math.abs(sinResult) * Math.abs(sinResult) * Math.abs(sinResult) * Math.abs(sinResult) * Math.abs(sinResult)) < 0.5f;
                });
            }
            if (interval < 105 && interval >= 97) {
                intervalOffset = interval - 95;
                EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, true, (x, z) -> {
                    float newX = (float)x.intValue() * Mth.cos((float)(intervalOffset * 5)) - (float)z.intValue() * Mth.sin((float)(intervalOffset * 5));
                    float newZ = (float)x.intValue() * Mth.sin((float)(intervalOffset * 5)) + (float)z.intValue() * Mth.cos((float)(intervalOffset * 5));
                    float sinResult = Mth.sin((float)(-(newX * newZ) * ((float)Math.PI / 180)));
                    return (sinResult = Math.abs(sinResult) * Math.abs(sinResult) * Math.abs(sinResult) * Math.abs(sinResult) * Math.abs(sinResult)) < 0.5f;
                });
            }
            if (interval < 110 && interval >= 106 && interval % 2 == 0) {
                EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, false, (x, z) -> {
                    int miniX = x / 2;
                    int miniZ = z / 2;
                    if (interval % 4 == 0) {
                        return miniX % 2 == 0;
                    }
                    return miniZ % 2 == 0;
                });
            }
            if (interval < 114 && interval >= 110 && interval % 2 == 0) {
                EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, false, (x, z) -> {
                    if (interval % 4 == 0) {
                        return Math.abs((x + z) % 6) < 4;
                    }
                    return Math.abs((x + z) % 6) >= 4;
                });
            }
            if (interval < 118 && interval >= 114 && interval % 2 == 0) {
                EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, false, (x, z) -> {
                    if (interval % 4 == 0) {
                        return Math.abs((x - z) % 6) < 4;
                    }
                    return Math.abs((x - z) % 6) >= 4;
                });
            }
            if (interval < 122 && interval >= 118 && interval % 2 == 0) {
                EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, false, (x, z) -> {
                    int miniX = x / 3;
                    int miniZ = z / 3;
                    if (interval % 4 == 0) {
                        return Math.abs((miniX + miniZ) % 2) == 0;
                    }
                    return Math.abs((miniX + miniZ) % 2) == 1;
                });
            }
            if (interval < 128 && interval >= 122 && interval % 2 == 0) {
                EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, false, (x, z) -> {
                    int miniX = x / 2;
                    int miniZ = z / 2;
                    if (interval % 4 == 0) {
                        return Math.abs((miniX + miniZ) % 2) == 0;
                    }
                    return Math.abs((miniX + miniZ) % 2) == 1;
                });
            }
            if (interval < 132 && interval >= 128 && interval % 2 == 0) {
                EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, false, (x, z) -> {
                    if (interval % 4 == 0) {
                        return x % 2 == 0;
                    }
                    return z % 2 == 0;
                });
            }
            if (interval >= 132 && interval % 2 == 0) {
                EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, false, (x, z) -> {
                    if (interval % 4 == 0) {
                        return Math.abs((x + z) % 2) == 0;
                    }
                    return Math.abs((x + z) % 2) == 1;
                });
            }
        }
    }

    private static void bars(ServerLevel serverLevel, EssenceBlockEntity essenceBlockEntity, List<EssenceBlockEntity.EventEntities> eventEntitiesInArena, int xRadius, int zRadius, int arenaRadius, int interval, int height, int width, int offset) {
        EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, false, (x, z) -> {
            int barTop = arenaRadius - (interval + offset) * height;
            int barBottom = arenaRadius - height - (interval + offset) * height;
            if (Math.abs(x) <= barTop && Math.abs(x) > barBottom) {
                if (interval % 2 == 0) {
                    if (z < 0) {
                        return z % (width * 2) >= -width;
                    }
                    return z % (width * 2) >= width;
                }
                if (z < 0) {
                    return z % (width * 2) < -width;
                }
                return z % (width * 2) < width;
            }
            return false;
        });
    }

    private static void ring(ServerLevel serverLevel, EssenceBlockEntity essenceBlockEntity, List<EssenceBlockEntity.EventEntities> eventEntitiesInArena, int xRadius, int zRadius, int arenaRadiusSq, int intervalOffset, int delay, boolean addToExistingSpike) {
        EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, addToExistingSpike, (x, z) -> {
            int innerRadius = arenaRadiusSq / 20 * (intervalOffset + delay) * (intervalOffset + delay);
            int outerRadius = arenaRadiusSq / 20 * (intervalOffset + delay + 1) * (intervalOffset + delay + 1);
            if (intervalOffset % 2 == 0 ? (double)Math.abs(x) <= Math.sqrt(outerRadius) / 3.0 : (double)Math.abs(z) <= Math.sqrt(outerRadius) / 3.0) {
                return false;
            }
            int currentRadiusSq = x * x + z * z;
            return currentRadiusSq >= innerRadius && currentRadiusSq < outerRadius;
        });
    }

    private static void patternFunction(ServerLevel serverLevel, EssenceBlockEntity essenceBlockEntity, List<EssenceBlockEntity.EventEntities> eventEntitiesInArena, int xRadius, int zRadius, boolean addToExistingSpike, BiPredicate<Integer, Integer> patternCondition) {
        for (int x = -xRadius; x <= xRadius; ++x) {
            for (int z = -zRadius; z <= zRadius; ++z) {
                if (!patternCondition.test(x, z)) continue;
                EssenceBlockPurple.activateSpike(serverLevel, x, z, 36, 36, essenceBlockEntity, eventEntitiesInArena, addToExistingSpike);
            }
        }
    }

    private static void patternFunction(ServerLevel serverLevel, EssenceBlockEntity essenceBlockEntity, List<EssenceBlockEntity.EventEntities> eventEntitiesInArena, int xRadius, int zRadius, int chargeTime, int spikeTime, boolean addToExistingSpike, BiPredicate<Integer, Integer> patternCondition) {
        for (int x = -xRadius; x <= xRadius; ++x) {
            for (int z = -zRadius; z <= zRadius; ++z) {
                if (!patternCondition.test(x, z)) continue;
                EssenceBlockPurple.activateSpike(serverLevel, x, z, chargeTime, spikeTime, essenceBlockEntity, eventEntitiesInArena, addToExistingSpike);
            }
        }
    }

    private static void activateSpike(ServerLevel serverLevel, int x, int z, int chargeTime, int spikeTime, EssenceBlockEntity essenceBlockEntity, List<EssenceBlockEntity.EventEntities> eventEntitiesInArena, boolean addToExistingSpike) {
        BlockPos arenaSize = essenceBlockEntity.getArenaSize();
        int rowLength = arenaSize.getX() - 2;
        int columnLength = arenaSize.getZ() - 2;
        int newX = x + rowLength / 2;
        int newZ = z + columnLength / 2;
        if (newX > rowLength || newZ > columnLength || newX + newZ * columnLength >= eventEntitiesInArena.size()) {
            Bumblezone.LOGGER.warn("Bumblezone: Detected invalid {} {} ({} {}) coordinate for trying to activate a spike. Grid size {} and row length {} - column length {}", new Object[]{x, z, newX, newZ, eventEntitiesInArena.size(), rowLength, columnLength});
        } else {
            EssenceBlockEntity.EventEntities eventEntities = eventEntitiesInArena.get(newX + newZ * columnLength);
            Entity entity = serverLevel.getEntity(eventEntities.uuid());
            if (entity instanceof PurpleSpikeEntity) {
                PurpleSpikeEntity purpleSpikeEntity = (PurpleSpikeEntity)entity;
                if (addToExistingSpike && !purpleSpikeEntity.hasSpikeCharge() && purpleSpikeEntity.hasSpike()) {
                    purpleSpikeEntity.setSpikeChargeTimer(0);
                    purpleSpikeEntity.setSpikeTimer(spikeTime + chargeTime);
                } else {
                    purpleSpikeEntity.setSpikeChargeTimer(chargeTime);
                    purpleSpikeEntity.setSpikeTimer(spikeTime);
                }
            }
        }
    }

    @Override
    public void onPlayerEnter(ServerLevel serverLevel, ServerPlayer serverPlayer, EssenceBlockEntity essenceBlockEntity) {
        MusicPacketFromServer.sendToClient((Player)serverPlayer, ((SoundEvent)BzSounds.KNOWING_EVENT.get()).getLocation(), true);
        super.onPlayerEnter(serverLevel, serverPlayer, essenceBlockEntity);
    }

    @Override
    public void onPlayerLeave(ServerLevel serverLevel, ServerPlayer serverPlayer, EssenceBlockEntity essenceBlockEntity) {
        MusicPacketFromServer.sendToClient((Player)serverPlayer, ((SoundEvent)BzSounds.KNOWING_EVENT.get()).getLocation(), false);
        super.onPlayerLeave(serverLevel, serverPlayer, essenceBlockEntity);
    }
}

