/*
 * Decompiled with CFR 0.152.
 */
package reliquary.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;
import reliquary.items.ToggleableItem;
import reliquary.util.PlayerInventoryProvider;

public class InventoryHelper {
    private InventoryHelper() {
    }

    public static void spawnItemStack(Level level, BlockPos pos, ItemStack stack) {
        Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
    }

    public static ItemStack getTargetItem(ItemStack self, IItemHandler inventory) {
        if (self.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack targetItem = ItemStack.EMPTY;
        int itemQuantity = 0;
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemStack stack = inventory.getStackInSlot(slot);
            if (ItemStack.isSameItemSameComponents((ItemStack)self, (ItemStack)stack) || stack.getMaxStackSize() == 1 || InventoryHelper.getItemQuantity(stack, inventory) <= itemQuantity) continue;
            itemQuantity = InventoryHelper.getItemQuantity(stack, inventory);
            targetItem = stack.copy();
        }
        return targetItem;
    }

    public static int getItemQuantity(ItemStack stack, IItemHandler inventory) {
        if (stack.isEmpty()) {
            return 0;
        }
        int itemQuantity = 0;
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemStack newStack = inventory.getStackInSlot(slot);
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)newStack)) continue;
            itemQuantity += newStack.getCount();
        }
        return itemQuantity;
    }

    public static ItemStack consumeItemStack(Predicate<ItemStack> itemMatches, Player player, int count) {
        return InventoryHelper.extractFromInventory(itemMatches, count, InventoryHelper.getMainInventoryItemHandlerFrom(player), false);
    }

    public static ItemStack extractFromInventory(Predicate<ItemStack> itemMatches, int count, IItemHandler inventory, boolean simulate) {
        ItemStack ret = ItemStack.EMPTY;
        int slots = inventory.getSlots();
        for (int slot = 0; slot < slots && ret.getCount() < count; ++slot) {
            ItemStack slotStack = inventory.getStackInSlot(slot);
            if (!itemMatches.test(slotStack) || !ret.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)ret, (ItemStack)slotStack)) continue;
            int toExtract = Math.min(slotStack.getCount(), count - ret.getCount());
            ItemStack extractedStack = inventory.extractItem(slot, toExtract, simulate);
            if (ret.isEmpty()) {
                ret = extractedStack;
                continue;
            }
            ret.setCount(ret.getCount() + extractedStack.getCount());
        }
        return ret;
    }

    public static boolean consumeItem(ItemStack itemStack, Player player, int minCount, int countToConsume) {
        if (player.isCreative()) {
            return true;
        }
        if (itemStack.isEmpty() || countToConsume <= 0) {
            return false;
        }
        int itemCount = 0;
        ArrayList<AbstractMap.SimpleEntry<Integer, Integer>> slotCounts = new ArrayList<AbstractMap.SimpleEntry<Integer, Integer>>();
        for (int slot = 0; slot < player.getInventory().items.size(); ++slot) {
            ItemStack slotStack = (ItemStack)player.getInventory().items.get(slot);
            if (!ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)itemStack)) continue;
            int n = slotStack.getCount();
            itemCount += n;
            slotCounts.add(new AbstractMap.SimpleEntry<Integer, Integer>(slot, n));
        }
        if (itemCount - countToConsume < minCount) {
            return false;
        }
        if (itemCount >= countToConsume) {
            slotCounts.sort((o1, o2) -> ((Integer)o2.getValue()).compareTo((Integer)o1.getValue()));
            int countToFill = itemCount - countToConsume;
            for (Map.Entry entry : slotCounts) {
                int slot = (Integer)entry.getKey();
                if (countToFill > 0) {
                    int stackSizeToFill = Math.min(itemStack.getMaxStackSize(), countToFill);
                    player.getInventory().getItem(slot).setCount(stackSizeToFill);
                    countToFill -= stackSizeToFill;
                    continue;
                }
                player.getInventory().removeItem(slot, player.getInventory().getItem(slot).getCount());
            }
            return true;
        }
        return false;
    }

    public static int tryToRemoveFromInventory(ItemStack contents, IItemHandler inventory, int maxToRemove) {
        int remaining = maxToRemove;
        ItemStack stackToExtract = contents.copy();
        int currentStackCount = Math.min(remaining, stackToExtract.getMaxStackSize());
        stackToExtract.setCount(currentStackCount);
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemStack extractedStack;
            if (inventory.getStackInSlot(slot).isEmpty()) continue;
            while (inventory.getStackInSlot(slot).getCount() > 0 && ItemStack.isSameItemSameComponents((ItemStack)inventory.getStackInSlot(slot), (ItemStack)contents) && remaining > 0 && (extractedStack = inventory.extractItem(slot, Math.min(maxToRemove, inventory.getStackInSlot(slot).getCount()), false)).getCount() != 0) {
                stackToExtract = contents.copy();
                currentStackCount = Math.min(remaining -= extractedStack.getCount(), stackToExtract.getMaxStackSize());
                stackToExtract.setCount(currentStackCount);
            }
            if (remaining <= 0) break;
        }
        return maxToRemove - remaining;
    }

    public static void runOnInventoryAt(Level level, BlockPos pos, Consumer<IItemHandler> run) {
        IItemHandler itemHandler = InventoryHelper.getInventoryAtPos(level, pos, null);
        if (itemHandler == null) {
            return;
        }
        run.accept(itemHandler);
    }

    @Nullable
    public static IItemHandler getInventoryAtPos(Level level, BlockPos pos, @Nullable Direction side) {
        return (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)side);
    }

    @Nullable
    public static IItemHandler getItemHandlerFrom(Player player) {
        return (IItemHandler)player.getCapability(Capabilities.ItemHandler.ENTITY);
    }

    public static IItemHandler getMainInventoryItemHandlerFrom(Player player) {
        return new PlayerMainInvWrapper(player.getInventory());
    }

    public static void executeOnItemHandlerAt(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity, Consumer<IItemHandler> run) {
        InventoryHelper.executeOnItemHandlerAt(level, pos, state, blockEntity, handler -> {
            run.accept((IItemHandler)handler);
            return null;
        }, null);
    }

    public static <T> T executeOnItemHandlerAt(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, Function<IItemHandler, T> run, @Nullable T defaultReturnValue) {
        return InventoryHelper.executeOnItemHandlerAt(level, pos, state, blockEntity, null, run, defaultReturnValue);
    }

    private static <T> T executeOnItemHandlerAt(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, @Nullable Direction side, Function<IItemHandler, T> run, @Nullable T defaultReturnValue) {
        IItemHandler itemHandler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, state, blockEntity, (Object)side);
        if (itemHandler != null) {
            return run.apply(itemHandler);
        }
        return defaultReturnValue;
    }

    public static int insertIntoInventory(ItemStack contents, IItemHandler inventory) {
        return InventoryHelper.tryToAddToInventory(contents, inventory, contents.getCount());
    }

    public static int tryToAddToInventoryAtPos(ItemStack contents, Level level, BlockPos pos, Direction side, int maxToAdd) {
        IItemHandler inventory = InventoryHelper.getInventoryAtPos(level, pos, side);
        if (inventory == null) {
            return 0;
        }
        return InventoryHelper.tryToAddToInventory(contents, inventory, maxToAdd);
    }

    public static int tryToAddToInventory(ItemStack contents, IItemHandler inventory, int maxToAdd) {
        int inventorySize = inventory.getSlots();
        int remaining = maxToAdd;
        ItemStack stackToInsert = contents.copy();
        int currentStackCount = Math.min(remaining, stackToInsert.getMaxStackSize());
        stackToInsert.setCount(currentStackCount);
        for (int slot = 0; slot < inventorySize; ++slot) {
            while (inventory.insertItem(slot, stackToInsert, true).getCount() < stackToInsert.getCount()) {
                ItemStack remainingStack = inventory.insertItem(slot, stackToInsert, false);
                if (remainingStack.getCount() >= currentStackCount) continue;
                if ((remaining -= currentStackCount - remainingStack.getCount()) <= 0) {
                    return maxToAdd;
                }
                stackToInsert = contents.copy();
                currentStackCount = Math.min(remaining, stackToInsert.getMaxStackSize());
                stackToInsert.setCount(currentStackCount);
            }
        }
        return maxToAdd - remaining;
    }

    public static void tryRemovingLastStack(IItemHandler inventory, Level level, BlockPos pos) {
        for (int i = inventory.getSlots() - 1; i >= 0; --i) {
            if (inventory.getStackInSlot(i).isEmpty()) continue;
            ItemStack stack = inventory.getStackInSlot(i).copy();
            inventory.extractItem(i, stack.getCount(), false);
            if (level.isClientSide) {
                return;
            }
            ItemEntity itemEntity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, stack);
            level.addFreshEntity((Entity)itemEntity);
            break;
        }
    }

    public static boolean tryAddingPlayerCurrentItem(Player player, IItemHandler inventory, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand).copy();
        stack.setCount(1);
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemStack remainingStack = inventory.insertItem(slot, stack, false);
            if (!remainingStack.isEmpty()) continue;
            player.getItemInHand(hand).shrink(1);
            if (player.getItemInHand(hand).getCount() == 0) {
                player.setItemInHand(hand, ItemStack.EMPTY);
            }
            player.getInventory().setChanged();
            return true;
        }
        return false;
    }

    public static boolean playerHasItem(Player player, Item item) {
        return InventoryHelper.playerHasItem(player, item, false);
    }

    public static boolean playerHasItem(Player player, Item item, boolean checkEnabled) {
        return PlayerInventoryProvider.get().getFromPlayerInventoryHandlers(player, (stack, result) -> {
            if (stack.isEmpty()) {
                return false;
            }
            return stack.getItem() == item && (!checkEnabled || !(stack.getItem() instanceof ToggleableItem) || ((ToggleableItem)stack.getItem()).isEnabled((ItemStack)stack));
        }, result -> result, () -> false);
    }

    public static ItemStack getCorrectItemFromEitherHand(Player player, Item item) {
        return InventoryHelper.getHandHoldingCorrectItem(player, item).map(arg_0 -> ((Player)player).getItemInHand(arg_0)).orElse(ItemStack.EMPTY);
    }

    private static Optional<InteractionHand> getHandHoldingCorrectItem(Player player, Item item) {
        if (player.getMainHandItem().getItem() == item) {
            return Optional.of(InteractionHand.MAIN_HAND);
        }
        if (player.getOffhandItem().getItem() == item) {
            return Optional.of(InteractionHand.OFF_HAND);
        }
        return Optional.empty();
    }

    public static void addItemToPlayerInventory(Player player, ItemStack stack) {
        for (int i = 0; i < player.getInventory().items.size(); ++i) {
            if (!player.getInventory().getItem(i).isEmpty()) continue;
            player.getInventory().setItem(i, stack);
            return;
        }
        player.level().addFreshEntity((Entity)new ItemEntity(player.level(), player.getX(), player.getY(), player.getZ(), stack));
    }

    public static NonNullList<ItemStack> getItemStacks(IItemHandler inventory) {
        NonNullList ret = NonNullList.create();
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ret.add((Object)inventory.getStackInSlot(slot));
        }
        return ret;
    }

    public static void dropInventoryItems(Level level, BlockPos pos, IItemHandler inventory) {
        InventoryHelper.dropInventoryItems(level, pos.getX(), pos.getY(), pos.getZ(), inventory);
    }

    private static void dropInventoryItems(Level level, double x, double y, double z, IItemHandler inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemstack = inventory.getStackInSlot(i);
            if (itemstack.isEmpty()) continue;
            Containers.dropItemStack((Level)level, (double)x, (double)y, (double)z, (ItemStack)itemstack);
        }
    }

    public static boolean hasItemHandler(Level level, BlockPos pos) {
        return InventoryHelper.executeOnItemHandlerAt(level, pos, level.getBlockState(pos), null, handler -> true, false);
    }
}

