/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items.util.fluid;

import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import reliquary.init.ModFluids;
import reliquary.init.ModItems;
import reliquary.util.XpHelper;

public class FluidHandlerHeroMedallion
implements IFluidHandlerItem {
    private static final int MAX_CAPACITY = Integer.MAX_VALUE;
    private final ItemStack heroMedallion;

    public FluidHandlerHeroMedallion(ItemStack heroMedallion) {
        this.heroMedallion = heroMedallion;
    }

    public ItemStack getContainer() {
        return this.heroMedallion;
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return new FluidStack((Fluid)ModFluids.XP_STILL.get(), XpHelper.experienceToLiquid(this.getMedallionXp()));
    }

    public int getTankCapacity(int tank) {
        return Integer.MAX_VALUE;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return tank == 0 && this.isXpJuiceFluid(stack);
    }

    private boolean isXpJuiceFluid(FluidStack stack) {
        return stack.getFluid().is(ModFluids.EXPERIENCE_TAG);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.isXpJuiceFluid(resource)) {
            return 0;
        }
        int currentXp = this.getMedallionXp();
        int toFill = Math.min(Integer.MAX_VALUE - XpHelper.experienceToLiquid(currentXp), resource.getAmount());
        if (action == IFluidHandler.FluidAction.EXECUTE) {
            ModItems.HERO_MEDALLION.get().setExperience(this.heroMedallion, currentXp + XpHelper.liquidToExperience(toFill));
        }
        return toFill;
    }

    private int getMedallionXp() {
        return ModItems.HERO_MEDALLION.get().getExperience(this.heroMedallion);
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.isXpJuiceFluid(resource)) {
            return FluidStack.EMPTY;
        }
        int currentXp = this.getMedallionXp();
        int currentLiquidXp = XpHelper.experienceToLiquid(currentXp);
        int toDrain = Math.min(currentLiquidXp, resource.getAmount());
        if (action == IFluidHandler.FluidAction.EXECUTE) {
            ModItems.HERO_MEDALLION.get().setExperience(this.heroMedallion, currentXp - XpHelper.liquidToExperience(toDrain));
        }
        return new FluidStack(resource.getFluid(), toDrain);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.drain(new FluidStack((Fluid)ModFluids.XP_STILL.get(), maxDrain), action);
    }
}

