/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items.util;

import java.util.ArrayDeque;
import java.util.Optional;
import java.util.Queue;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;

public class HarvestRodCache {
    @Nullable
    private BlockPos startBlockPos;
    private final Queue<BlockPos> blockQueue;

    private HarvestRodCache(Queue<BlockPos> blockQueue, @Nullable BlockPos startBlockPos) {
        this.blockQueue = blockQueue;
        this.startBlockPos = startBlockPos;
    }

    public HarvestRodCache() {
        this(new ArrayDeque<BlockPos>(), null);
    }

    public void setStartBlockPos(BlockPos pos) {
        this.startBlockPos = pos;
    }

    @Nullable
    public BlockPos getStartBlockPos() {
        return this.startBlockPos;
    }

    public void addBlockToQueue(BlockPos pos) {
        this.blockQueue.add(pos);
    }

    public Optional<BlockPos> getNextBlockInQueue() {
        return Optional.ofNullable(this.blockQueue.poll());
    }

    public void clearBlockQueue() {
        this.blockQueue.clear();
    }

    public boolean isQueueEmpty() {
        return this.blockQueue.isEmpty() || this.startBlockPos == null;
    }

    public void reset() {
        this.startBlockPos = null;
        this.blockQueue.clear();
    }
}

