/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items.component;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.IntUnaryOperator;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import reliquary.items.component.OversizedItemContainerContents;

public class OversizedComponentItemHandler
implements IItemHandlerModifiable {
    protected final ItemStack parent;
    protected final DataComponentType<OversizedItemContainerContents> component;
    protected final int size;
    private final BiFunction<ItemStack, Integer, Integer> getSlotLimit;
    private final BiPredicate<Integer, ItemStack> isItemValid;
    private final IntUnaryOperator getSlotUnitWorth;

    public OversizedComponentItemHandler(ItemStack parent, DataComponentType<OversizedItemContainerContents> component, int size, BiFunction<ItemStack, Integer, Integer> getSlotLimit, BiPredicate<Integer, ItemStack> isItemValid, IntUnaryOperator getSlotUnitWorth) {
        this.parent = parent;
        this.component = component;
        this.size = size;
        this.getSlotLimit = getSlotLimit;
        this.isItemValid = isItemValid;
        this.getSlotUnitWorth = getSlotUnitWorth;
        Preconditions.checkArgument((size <= 256 ? 1 : 0) != 0, (Object)"The max size of OversizedItemContainerContents is 256 slots.");
    }

    public int getSlots() {
        return this.size;
    }

    public ItemStack getStackInSlot(int slot) {
        OversizedItemContainerContents contents = this.getContents();
        return this.getStackFromContents(contents, slot);
    }

    public int getCountInSlot(int slot) {
        OversizedItemContainerContents contents = this.getContents();
        return contents.getSlots() > slot ? contents.getCountInSlot(slot) : 0;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.validateSlotIndex(slot);
        if (!this.isItemValid(slot, stack)) {
            throw new RuntimeException("Invalid stack " + String.valueOf(stack) + " for slot " + slot + ")");
        }
        OversizedItemContainerContents contents = this.getContents();
        ItemStack existing = this.getStackFromContents(contents, slot);
        if (!ItemStack.matches((ItemStack)stack, (ItemStack)existing)) {
            if (this.getSlotUnitWorth.applyAsInt(slot) != 1) {
                stack = stack.copy();
                stack.setCount(stack.getCount() * this.getSlotUnitWorth.applyAsInt(slot));
            }
            this.updateContents(contents, stack, slot);
        }
    }

    public ItemStack insertItemOrAddIntoNewSlotIfNoStackMatches(ItemStack stack) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        for (int slot = 0; slot < this.getSlots(); ++slot) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)this.getStackInSlot(slot)) && (!this.isItemValid(slot, stack) || !this.getStackInSlot(slot).isEmpty())) continue;
            return this.insertItem(slot, stack, false);
        }
        OversizedItemContainerContents contents = this.getContents();
        int newSlot = this.getSlots();
        NonNullList list = NonNullList.withSize((int)Math.max(contents.getSlots(), this.getSlots() + 1), (Object)ItemStack.EMPTY);
        if (!this.isItemValid(newSlot, stack)) {
            return stack;
        }
        contents.copyInto((NonNullList<ItemStack>)list);
        int countToAdd = Math.min(stack.getCount(), this.getSlotLimit(list.size()));
        ItemStack stackToAdd = stack.copyWithCount(countToAdd);
        if (this.getSlotUnitWorth.applyAsInt(newSlot) != 1) {
            stackToAdd = stackToAdd.copy();
            stackToAdd.setCount(stackToAdd.getCount() * this.getSlotUnitWorth.applyAsInt(newSlot));
        }
        list.set(newSlot, (Object)stackToAdd);
        this.parent.set(this.component, (Object)OversizedItemContainerContents.fromItems((List<ItemStack>)list));
        this.onContentsChanged(newSlot, ItemStack.EMPTY, stackToAdd);
        return countToAdd == stack.getCount() ? ItemStack.EMPTY : stack.copyWithCount(stack.getCount() - countToAdd);
    }

    public ItemStack extractItemAndRemoveSlotIfEmpty(int slot, int amount, boolean simulate) {
        return this.extractItemAndRemoveSlotIfEmpty(slot, amount, () -> {}, simulate);
    }

    public ItemStack extractItemAndRemoveSlotIfEmpty(int slot, int amount, Runnable onSlotRemoved, boolean simulate) {
        ItemStack stack = this.extractItem(slot, amount, simulate);
        if (!simulate && this.getStackInSlot(slot).isEmpty()) {
            int i;
            OversizedItemContainerContents contents = this.getContents();
            NonNullList list = NonNullList.withSize((int)Math.max(contents.getSlots(), this.getSlots()), (Object)ItemStack.EMPTY);
            for (i = 0; i < slot; ++i) {
                list.set(i, (Object)(contents.getSlots() > i ? contents.getStackInSlot(i) : ItemStack.EMPTY));
            }
            for (i = slot; i < list.size(); ++i) {
                list.set(i, (Object)(contents.getSlots() > i + 1 ? contents.getStackInSlot(i + 1) : ItemStack.EMPTY));
            }
            this.parent.set(this.component, (Object)OversizedItemContainerContents.fromItems((List<ItemStack>)list));
            this.onContentsChanged(slot, stack, ItemStack.EMPTY);
            onSlotRemoved.run();
        }
        return stack;
    }

    public ItemStack insertItem(int slot, ItemStack toInsert, boolean simulate) {
        this.validateSlotIndex(slot);
        if (toInsert.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (!this.isItemValid(slot, toInsert)) {
            return toInsert;
        }
        OversizedItemContainerContents contents = this.getContents();
        ItemStack existing = this.getStackFromContents(contents, slot);
        int insertLimit = this.getSlotLimit(slot) / this.getSlotUnitWorth.applyAsInt(slot);
        if (!existing.isEmpty()) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)toInsert, (ItemStack)existing)) {
                return toInsert;
            }
            insertLimit -= existing.getCount();
        }
        if (insertLimit <= 0) {
            return toInsert;
        }
        int inserted = Math.min(insertLimit, toInsert.getCount());
        if (!simulate) {
            this.updateContents(contents, toInsert.copyWithCount(existing.getCount() + inserted * this.getSlotUnitWorth.applyAsInt(slot)), slot);
        }
        return toInsert.copyWithCount(toInsert.getCount() - inserted);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        this.validateSlotIndex(slot);
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        OversizedItemContainerContents contents = this.getContents();
        ItemStack existing = this.getStackFromContents(contents, slot);
        if (existing.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int toExtract = Math.min(Math.min(amount, existing.getMaxStackSize()), existing.getCount() / this.getSlotUnitWorth.applyAsInt(slot));
        if (!simulate) {
            this.updateContents(contents, existing.copyWithCount(existing.getCount() - toExtract * this.getSlotUnitWorth.applyAsInt(slot)), slot);
        }
        return existing.copyWithCount(toExtract);
    }

    public int getSlotLimit(int slot) {
        return this.getSlotLimit.apply(this.parent, slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.isItemValid.test(slot, stack) && stack.getItem().canFitInsideContainerItems();
    }

    protected void onContentsChanged(int slot, ItemStack oldStack, ItemStack newStack) {
    }

    protected OversizedItemContainerContents getContents() {
        if (this.parent.has(this.component)) {
            return (OversizedItemContainerContents)this.parent.get(this.component);
        }
        return OversizedItemContainerContents.fromSize(this.size);
    }

    protected ItemStack getStackFromContents(OversizedItemContainerContents contents, int slot) {
        this.validateSlotIndex(slot);
        return contents.getSlots() <= slot ? ItemStack.EMPTY : contents.getStackInSlot(slot);
    }

    protected void updateContents(OversizedItemContainerContents contents, ItemStack stack, int slot) {
        this.validateSlotIndex(slot);
        NonNullList list = NonNullList.withSize((int)Math.max(contents.getSlots(), this.getSlots()), (Object)ItemStack.EMPTY);
        contents.copyInto((NonNullList<ItemStack>)list);
        ItemStack oldStack = (ItemStack)list.get(slot);
        list.set(slot, (Object)stack);
        this.parent.set(this.component, (Object)OversizedItemContainerContents.fromItems((List<ItemStack>)list));
        this.onContentsChanged(slot, oldStack, stack);
    }

    protected final void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.getSlots()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
        }
    }
}

