/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import reliquary.entities.TippedArrow;
import reliquary.items.ICreativeTabItemGenerator;
import reliquary.items.util.IPotionItem;
import reliquary.reference.Config;
import reliquary.util.TooltipBuilder;
import reliquary.util.potions.PotionEssence;
import reliquary.util.potions.PotionHelper;
import reliquary.util.potions.PotionMap;

public class TippedArrowItem
extends ArrowItem
implements IPotionItem,
ICreativeTabItemGenerator {
    public TippedArrowItem() {
        super(new Item.Properties());
    }

    public AbstractArrow createArrow(Level level, ItemStack arrowStack, LivingEntity shooter, @Nullable ItemStack projectileWeaponStack) {
        TippedArrow arrowEntity = new TippedArrow(level, shooter, arrowStack, projectileWeaponStack);
        arrowEntity.setPotionEffect(arrowStack);
        return arrowEntity;
    }

    @Override
    public void addCreativeTabItems(Consumer<ItemStack> itemConsumer) {
        if (Boolean.TRUE.equals(Config.COMMON.disable.disablePotions.get())) {
            return;
        }
        for (PotionEssence essence : PotionMap.uniquePotionEssences) {
            ItemStack tippedArrow = new ItemStack((ItemLike)this);
            PotionHelper.addPotionContentsToStack(tippedArrow, PotionHelper.changePotionEffectsDuration(essence.getPotionContents(), 0.125f));
            itemConsumer.accept(tippedArrow);
        }
    }

    public void appendHoverText(ItemStack arrow, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        TooltipBuilder.of(tooltip, context).potionEffects(arrow);
    }

    @Override
    public PotionContents getPotionContents(ItemStack stack) {
        return (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
    }
}

