/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import reliquary.init.ModDataComponents;
import reliquary.items.ItemBase;
import reliquary.items.MobCharmRegistry;

public class MobCharmFragmentItem
extends ItemBase {
    public MobCharmFragmentItem() {
        super(new Item.Properties());
    }

    @Override
    public void addCreativeTabItems(Consumer<ItemStack> itemConsumer) {
        for (ResourceLocation entityRegistryName : MobCharmRegistry.getRegisteredNames()) {
            itemConsumer.accept(this.getStackFor(entityRegistryName));
        }
    }

    public ItemStack getStackFor(EntityType<?> entityType) {
        return this.getStackFor(EntityType.getKey(entityType));
    }

    public ItemStack getStackFor(ResourceLocation entityRegistryName) {
        ItemStack ret = new ItemStack((ItemLike)this);
        ret.set(ModDataComponents.ENTITY_NAME.get(), (Object)entityRegistryName);
        return ret;
    }

    public static ResourceLocation getEntityRegistryName(ItemStack charm) {
        return (ResourceLocation)charm.getOrDefault(ModDataComponents.ENTITY_NAME.get(), (Object)BuiltInRegistries.ENTITY_TYPE.getDefaultKey());
    }

    @Override
    public MutableComponent getName(ItemStack stack) {
        ResourceLocation entityEggRegistryName = MobCharmFragmentItem.getEntityRegistryName(stack);
        return BuiltInRegistries.ENTITY_TYPE.getOptional(entityEggRegistryName).map(entityType -> Component.translatable((String)this.getDescriptionId(), (Object[])new Object[]{entityType.getDescription().getString()}).withStyle(ChatFormatting.GREEN)).orElseGet(() -> super.getName(stack));
    }
}

