/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import reliquary.init.ModDataComponents;
import reliquary.items.IceMagusRodItem;

public class GlacialStaffItem
extends IceMagusRodItem {
    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity e) {
        if (e instanceof LivingEntity) {
            LivingEntity livingBase = (LivingEntity)e;
            if (GlacialStaffItem.getSnowballs(stack) >= this.getSnowballCost()) {
                MobEffectInstance slow = new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 30, 0);
                MobEffectInstance slownessEffect = livingBase.getEffect(MobEffects.MOVEMENT_SLOWDOWN);
                if (slownessEffect != null) {
                    slow = new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, Math.min(slownessEffect.getDuration() + 30, 300), Math.min(slownessEffect.getAmplifier() + 1, 4));
                }
                ((LivingEntity)e).addEffect(slow);
                e.hurt(player.damageSources().playerAttack(player), (float)slow.getAmplifier());
                this.setSnowballs(stack, GlacialStaffItem.getSnowballs(stack) - this.getSnowballCost());
            }
        }
        return super.onLeftClickEntity(stack, player, e);
    }

    @Override
    public void inventoryTick(ItemStack staff, Level level, Entity entity, int itemSlot, boolean isSelected) {
        Player player;
        super.inventoryTick(staff, level, entity, itemSlot, isSelected);
        if (level.isClientSide() || !(entity instanceof Player) || (player = (Player)entity).isSpectator() || level.getGameTime() % 2L != 0L) {
            return;
        }
        if (this.isEnabled(staff)) {
            this.freezeBlocks(staff, level, player);
        }
        this.meltBlocks(staff, level, player);
    }

    private void freezeBlocks(ItemStack staff, Level level, Player player) {
        BlockPos playerPos = player.blockPosition();
        BlockPos.betweenClosed((BlockPos)playerPos.offset(-2, -1, -2), (BlockPos)playerPos.offset(2, -1, 2)).forEach(pos -> {
            if (Math.abs(playerPos.getX() - pos.getX()) == 2 && Math.abs(playerPos.getZ() - pos.getZ()) == 2) {
                return;
            }
            this.doFreezeCheck(staff, pos.immutable(), level);
        });
    }

    private void meltBlocks(ItemStack staff, Level level, Player player) {
        if (!level.isClientSide) {
            BlockPos playerPos = player.blockPosition();
            for (BlockPos pos : this.getBlockLocations(staff)) {
                if (!level.isLoaded(pos)) continue;
                int xOff = Math.abs(playerPos.getX() - pos.getX());
                int yOff = Math.abs(playerPos.getY() - pos.getY());
                int zOff = Math.abs(playerPos.getZ() - pos.getZ());
                if (xOff < 3 && yOff < 3 && zOff < 3 && (xOff != 2 || zOff != 2)) continue;
                this.doThawCheck(staff, pos, level);
            }
        }
    }

    private Set<BlockPos> getBlockLocations(ItemStack stack) {
        return (Set)stack.getOrDefault(ModDataComponents.FROZEN_POSITIONS, new HashSet());
    }

    private void doFreezeCheck(ItemStack stack, BlockPos pos, Level level) {
        block3: {
            BlockState blockState;
            block2: {
                blockState = level.getBlockState(pos);
                if (blockState.getBlock() != Blocks.WATER || (Integer)blockState.getValue((Property)LiquidBlock.LEVEL) != 0 || !level.isEmptyBlock(pos.above())) break block2;
                this.addFrozenBlockToList(stack, pos);
                level.setBlockAndUpdate(pos, Blocks.PACKED_ICE.defaultBlockState());
                for (int particleNum = level.random.nextInt(3); particleNum < 2; ++particleNum) {
                    float xVel = level.random.nextFloat();
                    float yVel = level.random.nextFloat() + 0.5f;
                    float zVel = level.random.nextFloat();
                    level.addParticle((ParticleOptions)ICE_PARTICLE, (double)((float)pos.getX() + xVel), (double)((float)pos.getY() + yVel), (double)((float)pos.getZ() + zVel), 0.75, 0.75, 1.0);
                }
                break block3;
            }
            if (blockState.getBlock() != Blocks.LAVA || (Integer)blockState.getValue((Property)LiquidBlock.LEVEL) != 0) break block3;
            this.addFrozenBlockToList(stack, pos);
            level.setBlockAndUpdate(pos, Blocks.OBSIDIAN.defaultBlockState());
            for (int particleNum = level.random.nextInt(3); particleNum < 2; ++particleNum) {
                float xVel = level.random.nextFloat();
                float yVel = level.random.nextFloat() + 0.5f;
                float zVel = level.random.nextFloat();
                level.addParticle((ParticleOptions)(level.random.nextInt(3) == 0 ? ParticleTypes.LARGE_SMOKE : ParticleTypes.SMOKE), (double)((float)pos.getX() + xVel), (double)((float)pos.getY() + yVel), (double)((float)pos.getZ() + zVel), 0.0, 0.2, 0.0);
            }
        }
    }

    private void doThawCheck(ItemStack stack, BlockPos pos, Level level) {
        block4: {
            BlockState blockState;
            block3: {
                blockState = level.getBlockState(pos);
                if (blockState != Blocks.PACKED_ICE.defaultBlockState()) break block3;
                if (!this.removeFrozenBlockFromList(stack, pos)) break block4;
                level.setBlockAndUpdate(pos, Blocks.WATER.defaultBlockState());
                for (int particleNum = level.random.nextInt(3); particleNum < 2; ++particleNum) {
                    float xVel = level.random.nextFloat();
                    float yVel = level.random.nextFloat() + 0.5f;
                    float zVel = level.random.nextFloat();
                    level.addParticle((ParticleOptions)(level.random.nextInt(3) == 0 ? ParticleTypes.LARGE_SMOKE : ParticleTypes.SMOKE), (double)((float)pos.getX() + xVel), (double)((float)pos.getY() + yVel), (double)((float)pos.getZ() + zVel), 0.0, 0.2, 0.0);
                }
                break block4;
            }
            if (blockState == Blocks.OBSIDIAN.defaultBlockState() && this.removeFrozenBlockFromList(stack, pos)) {
                level.setBlockAndUpdate(pos, Blocks.LAVA.defaultBlockState());
                for (int particleNum = level.random.nextInt(3); particleNum < 2; ++particleNum) {
                    float xVel = level.random.nextFloat();
                    float yVel = level.random.nextFloat() + 0.5f;
                    float zVel = level.random.nextFloat();
                    level.addParticle((ParticleOptions)DustParticleOptions.REDSTONE, (double)((float)pos.getX() + xVel), (double)((float)pos.getY() + yVel), (double)((float)pos.getZ() + zVel), 0.0, (double)0.2f, 0.0);
                }
            }
        }
    }

    private void addFrozenBlockToList(ItemStack stack, BlockPos pos) {
        HashSet<BlockPos> frozenPositions = new HashSet<BlockPos>(this.getBlockLocations(stack));
        frozenPositions.add(pos);
        stack.set(ModDataComponents.FROZEN_POSITIONS, (Object)ImmutableSet.copyOf(frozenPositions));
    }

    private boolean removeFrozenBlockFromList(ItemStack stack, BlockPos pos) {
        HashSet<BlockPos> frozenPositions = new HashSet<BlockPos>(this.getBlockLocations(stack));
        if (frozenPositions.remove(pos)) {
            stack.set(ModDataComponents.FROZEN_POSITIONS, (Object)ImmutableSet.copyOf(frozenPositions));
            return true;
        }
        return false;
    }
}

