/*
 * Decompiled with CFR 0.152.
 */
package reliquary.init;

import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;
import reliquary.Reliquary;
import reliquary.entities.EnderStaffProjectile;
import reliquary.entities.GlowingWater;
import reliquary.entities.HolyHandGrenade;
import reliquary.entities.KrakenSlime;
import reliquary.entities.LyssaHook;
import reliquary.entities.SpecialSnowball;
import reliquary.entities.TippedArrow;
import reliquary.entities.potion.AphroditePotion;
import reliquary.entities.potion.FertilePotion;
import reliquary.entities.potion.ThrownPotion;
import reliquary.entities.shot.BlazeShot;
import reliquary.entities.shot.BusterShot;
import reliquary.entities.shot.ConcussiveShot;
import reliquary.entities.shot.EnderShot;
import reliquary.entities.shot.ExorcismShot;
import reliquary.entities.shot.NeutralShot;
import reliquary.entities.shot.SandShot;
import reliquary.entities.shot.SeekerShot;
import reliquary.entities.shot.ShotBase;
import reliquary.entities.shot.StormShot;

public class ModEntities {
    private static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"reliquary");
    public static final Supplier<EntityType<AphroditePotion>> APHRODITE_POTION = ENTITY_TYPES.register("aphrodite_potion", () -> ModEntities.getDefaultSizeEntityType(AphroditePotion::new));
    public static final Supplier<EntityType<FertilePotion>> FERTILE_POTION = ENTITY_TYPES.register("fertile_potion", () -> ModEntities.getDefaultSizeEntityType(FertilePotion::new));
    public static final Supplier<EntityType<ThrownPotion>> THROWN_POTION = ENTITY_TYPES.register("thrown_potion", () -> ModEntities.getDefaultSizeEntityType(ThrownPotion::new));
    public static final Supplier<EntityType<BlazeShot>> BLAZE_SHOT = ENTITY_TYPES.register("blaze_shot", () -> ModEntities.getShotEntityType(BlazeShot::new));
    public static final Supplier<EntityType<BusterShot>> BUSTER_SHOT = ENTITY_TYPES.register("buster_shot", () -> ModEntities.getShotEntityType(BusterShot::new));
    public static final Supplier<EntityType<ConcussiveShot>> CONCUSSIVE_SHOT = ENTITY_TYPES.register("concussive_shot", () -> ModEntities.getShotEntityType(ConcussiveShot::new));
    public static final Supplier<EntityType<EnderShot>> ENDER_SHOT = ENTITY_TYPES.register("ender_shot", () -> ModEntities.getShotEntityType(EnderShot::new));
    public static final Supplier<EntityType<ExorcismShot>> EXORCISM_SHOT = ENTITY_TYPES.register("exorcism_shot", () -> ModEntities.getShotEntityType(ExorcismShot::new));
    public static final Supplier<EntityType<NeutralShot>> NEUTRAL_SHOT = ENTITY_TYPES.register("neutral_shot", () -> ModEntities.getShotEntityType(NeutralShot::new));
    public static final Supplier<EntityType<SandShot>> SAND_SHOT = ENTITY_TYPES.register("sand_shot", () -> ModEntities.getShotEntityType(SandShot::new));
    public static final Supplier<EntityType<SeekerShot>> SEEKER_SHOT = ENTITY_TYPES.register("seeker_shot", () -> ModEntities.getShotEntityType(SeekerShot::new));
    public static final Supplier<EntityType<StormShot>> STORM_SHOT = ENTITY_TYPES.register("storm_shot", () -> ModEntities.getShotEntityType(StormShot::new));
    public static final Supplier<EntityType<EnderStaffProjectile>> ENDER_STAFF_PROJECTILE = ENTITY_TYPES.register("ender_staff_projectile", () -> ModEntities.getEntityType(EnderStaffProjectile::new, 0.25f, 0.25f, 256));
    public static final Supplier<EntityType<GlowingWater>> GLOWING_WATER = ENTITY_TYPES.register("glowing_water", () -> ModEntities.getDefaultSizeEntityType(GlowingWater::new));
    public static final Supplier<EntityType<HolyHandGrenade>> HOLY_HAND_GRENADE = ENTITY_TYPES.register("holy_hand_grenade", () -> ModEntities.getDefaultSizeEntityType(HolyHandGrenade::new));
    public static final Supplier<EntityType<KrakenSlime>> KRAKEN_SLIME = ENTITY_TYPES.register("kraken_slime", () -> ModEntities.getDefaultSizeEntityType(KrakenSlime::new));
    public static final Supplier<EntityType<LyssaHook>> LYSSA_HOOK = ENTITY_TYPES.register("lyssa_hook", () -> ModEntities.getDefaultSizeEntityType(LyssaHook::new));
    public static final Supplier<EntityType<TippedArrow>> TIPPED_ARROW = ENTITY_TYPES.register("tipped_arrow", () -> ModEntities.getDefaultSizeEntityType(TippedArrow::new));
    public static final Supplier<EntityType<SpecialSnowball>> SPECIAL_SNOWBALL = ENTITY_TYPES.register("special_snowball", () -> ModEntities.getEntityType(SpecialSnowball::new, 0.01f, 0.01f));
    public static final ResourceKey<DamageType> BULLET_DAMAGE_TYPE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)Reliquary.getRL("bullet"));

    private ModEntities() {
    }

    public static void registerListeners(IEventBus modBus) {
        ENTITY_TYPES.register(modBus);
    }

    private static <T extends Entity> EntityType<T> getDefaultSizeEntityType(EntityType.EntityFactory<T> factory) {
        return ModEntities.getEntityType(factory, 0.25f, 0.25f);
    }

    private static <T extends ShotBase> EntityType<T> getShotEntityType(EntityType.EntityFactory<T> factory) {
        return ModEntities.getEntityType(factory, 0.01f, 0.01f);
    }

    private static <T extends Entity> EntityType<T> getEntityType(EntityType.EntityFactory<T> factory, float width, float height) {
        return ModEntities.getEntityType(factory, width, height, 128);
    }

    private static <T extends Entity> EntityType<T> getEntityType(EntityType.EntityFactory<T> factory, float width, float height, int trackingRange) {
        return EntityType.Builder.of(factory, (MobCategory)MobCategory.MISC).sized(width, height).updateInterval(5).setTrackingRange(trackingRange).setShouldReceiveVelocityUpdates(true).build("");
    }
}

