/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entities.shot;

import net.minecraft.core.Direction;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import reliquary.entities.shot.ShotBase;
import reliquary.init.ModEntities;
import reliquary.reference.ClientReference;

public class ExorcismShot
extends ShotBase {
    public ExorcismShot(EntityType<ExorcismShot> entityType, Level level) {
        super(entityType, level);
    }

    public ExorcismShot(Level level, Player player, InteractionHand hand) {
        super(ModEntities.EXORCISM_SHOT.get(), level, player, hand);
    }

    @Override
    void doFlightEffects() {
        if (this.ticksInAir % 3 == 0) {
            float gauss = this.gaussian(1.0f);
            this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)gauss, (float)gauss, (float)0.0f), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    void doFiringEffects() {
        this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)0.5f, (float)0.5f, (float)0.5f), this.getX() + this.smallGauss(0.1), this.getY() + this.smallGauss(0.1), this.getZ() + this.smallGauss(0.1), 0.0, 0.0, 0.0);
        this.spawnMotionBasedParticle((ParticleOptions)ParticleTypes.FLAME);
    }

    @Override
    void doBurstEffect(Direction sideHit) {
    }

    @Override
    void spawnHitParticles(int i) {
        for (int particles = 0; particles < i; ++particles) {
            this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)this.posGauss(1.0f), (float)this.posGauss(1.0f), (float)0.0f), this.getX() + this.smallGauss(0.1), this.getY() + this.smallGauss(0.1), this.getZ() + this.smallGauss(0.1), 0.0, 0.0, 0.0);
        }
    }

    private boolean isUndead(LivingEntity e) {
        return e.getType().is(EntityTypeTags.UNDEAD);
    }

    @Override
    int getRicochetMax() {
        return 1;
    }

    @Override
    int getDamageOfShot(LivingEntity e) {
        return (this.isUndead(e) ? 9 + this.d3() : 0) + 8 + this.d6();
    }

    @Override
    public ResourceLocation getShotTexture() {
        return ClientReference.EXORCISM;
    }
}

