/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entities.potion;

import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.network.PacketDistributor;
import reliquary.init.ModEntities;
import reliquary.init.ModItems;
import reliquary.items.util.IPotionItem;
import reliquary.network.SpawnThrownPotionImpactParticlesPayload;
import reliquary.util.potions.PotionHelper;

public class ThrownPotion
extends ThrowableProjectile
implements ItemSupplier {
    private static final EntityDataAccessor<ItemStack> ITEM = SynchedEntityData.defineId(ThrownPotion.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);

    public ThrownPotion(EntityType<ThrownPotion> entityType, Level level) {
        super(entityType, level);
    }

    public ThrownPotion(Level level, Position position, ItemStack potion) {
        super(ModEntities.THROWN_POTION.get(), position.x(), position.y(), position.z(), level);
        this.setItem(potion);
    }

    public ThrownPotion(Level level, LivingEntity entity, ItemStack potion) {
        super(ModEntities.THROWN_POTION.get(), entity, level);
        this.setItem(potion);
    }

    protected double getDefaultGravity() {
        return 0.04;
    }

    protected void onHit(HitResult result) {
        if (!this.level().isClientSide) {
            ItemStack potion = this.getItem();
            if (!(potion.getItem() instanceof IPotionItem)) {
                return;
            }
            PotionContents potionContents = ((IPotionItem)potion.getItem()).getPotionContents(potion);
            int color = potionContents.getColor();
            if (potion.getItem() == ModItems.LINGERING_POTION.get()) {
                this.spawnAreaEffectCloud(potionContents);
            } else {
                this.splashPotion(result, potionContents);
            }
            this.spawnParticles(color);
            this.discard();
        }
    }

    private void splashPotion(HitResult result, PotionContents potionContents) {
        AABB axisalignedbb = this.getBoundingBox().inflate(4.0, 2.0, 4.0);
        List livingEntities = this.level().getEntitiesOfClass(LivingEntity.class, axisalignedbb);
        if (!livingEntities.isEmpty()) {
            for (LivingEntity entity : livingEntities) {
                double distance = this.distanceTo((Entity)entity);
                if (!(distance < 16.0)) continue;
                double amplifier = 1.0 - Math.sqrt(distance) / 4.0;
                if (result.getType() == HitResult.Type.ENTITY && entity == ((EntityHitResult)result).getEntity()) {
                    amplifier = 1.0;
                }
                PotionHelper.applyEffectsToEntity(potionContents, (Entity)this, this.getOwner(), entity, amplifier);
            }
        }
    }

    private void spawnAreaEffectCloud(PotionContents potionContents) {
        Entity thrower = this.getOwner();
        if (!(thrower instanceof LivingEntity)) {
            return;
        }
        AreaEffectCloud areaEffectCloud = new AreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
        areaEffectCloud.setOwner((LivingEntity)thrower);
        areaEffectCloud.setRadius(3.0f);
        areaEffectCloud.setRadiusOnUse(-0.5f);
        areaEffectCloud.setWaitTime(10);
        areaEffectCloud.setRadiusPerTick(-areaEffectCloud.getRadius() / (float)areaEffectCloud.getDuration());
        areaEffectCloud.setPotionContents(potionContents);
        this.level().addFreshEntity((Entity)areaEffectCloud);
    }

    private void spawnParticles(int color) {
        if (this.level().isClientSide) {
            return;
        }
        RandomSource var7 = this.random;
        for (int var15 = 0; var15 < 8; ++var15) {
            this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getItem()), this.getX(), this.getY(), this.getZ(), var7.nextGaussian() * 0.15, var7.nextDouble() * 0.2, var7.nextGaussian() * 0.15);
        }
        this.level().playSound(null, this.blockPosition(), SoundEvents.GLASS_BREAK, SoundSource.BLOCKS, 1.0f, this.level().random.nextFloat() * 0.1f + 0.9f);
        PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new SpawnThrownPotionImpactParticlesPayload(color, this.getX(), this.getY(), this.getZ()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.put("item", this.getItem().save((HolderLookup.Provider)this.registryAccess(), (Tag)new CompoundTag()));
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setItem(ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)nbt.getCompound("Item")).orElseGet(() -> new ItemStack((ItemLike)ModItems.POTION.get())));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ITEM, (Object)ItemStack.EMPTY);
    }

    public ItemStack getItem() {
        return (ItemStack)this.entityData.get(ITEM);
    }

    private void setItem(ItemStack stack) {
        this.entityData.set(ITEM, (Object)stack);
    }
}

