/*
 * Decompiled with CFR 0.152.
 */
package reliquary.client.particle;

import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ColorParticleOption;

public class CauldronSteamParticle
extends TextureSheetParticle {
    private final SpriteSet spriteSet;

    private CauldronSteamParticle(ClientLevel level, ColorParticleOption particleOption, double x, double y, double z, double ySpeed, SpriteSet spriteSet) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.rCol = particleOption.getRed();
        this.gCol = particleOption.getGreen();
        this.bCol = particleOption.getBlue();
        this.xd *= (double)0.1f;
        this.yd *= (double)0.1f;
        this.zd *= (double)0.1f;
        this.yd += ySpeed;
        this.spriteSet = spriteSet;
        this.lifetime = 8 + level.random.nextInt(32);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.alpha = (float)(this.lifetime - this.age) / (float)this.lifetime;
            this.setSpriteFromAge(this.spriteSet);
            this.move(this.xd, this.yd, this.zd);
            if (this.y == this.yo) {
                this.xd *= 1.1;
                this.zd *= 1.1;
            }
            this.xd *= 0.96;
            this.yd *= 0.96;
            this.zd *= 0.96;
            if (this.onGround) {
                this.xd *= 0.7;
                this.zd *= 0.7;
            }
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Provider
    implements ParticleProvider<ColorParticleOption> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(ColorParticleOption particleOption, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            CauldronSteamParticle particle = new CauldronSteamParticle(level, particleOption, x, y, z, ySpeed, this.spriteSet);
            particle.setSprite(this.spriteSet.get(particle.age, particle.lifetime));
            return particle;
        }
    }
}

