/*
 * Decompiled with CFR 0.152.
 */
package reliquary.client.gui.hud;

import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Tuple;
import reliquary.client.gui.components.Component;
import reliquary.client.gui.hud.HUDPosition;

public class HUDRenderrer {
    private HUDRenderrer() {
    }

    public static void render(GuiGraphics guiGraphics, Component component, HUDPosition position) {
        if (component.shouldRender()) {
            Minecraft mc = Minecraft.getInstance();
            Window mainWindow = mc.getWindow();
            Tuple<Integer, Integer> xy = HUDRenderrer.getXYPosition(mainWindow, component, position);
            component.render(guiGraphics, (Integer)xy.getA(), (Integer)xy.getB());
        }
    }

    private static Tuple<Integer, Integer> getXYPosition(Window sr, Component component, HUDPosition position) {
        return switch (position) {
            case HUDPosition.BOTTOM_LEFT -> new Tuple((Object)0, (Object)(sr.getGuiScaledHeight() - component.getHeight()));
            case HUDPosition.LEFT -> new Tuple((Object)0, (Object)((sr.getGuiScaledHeight() - component.getHeight()) / 2));
            case HUDPosition.TOP_LEFT -> new Tuple((Object)0, (Object)0);
            case HUDPosition.TOP -> new Tuple((Object)((sr.getGuiScaledWidth() - component.getWidth()) / 2), (Object)0);
            case HUDPosition.TOP_RIGHT -> new Tuple((Object)(sr.getGuiScaledWidth() - component.getWidth()), (Object)0);
            case HUDPosition.RIGHT -> new Tuple((Object)(sr.getGuiScaledWidth() - component.getWidth()), (Object)((sr.getGuiScaledHeight() - component.getHeight()) / 2));
            default -> new Tuple((Object)(sr.getGuiScaledWidth() - component.getWidth()), (Object)(sr.getGuiScaledHeight() - component.getHeight()));
        };
    }
}

