/*
 * Decompiled with CFR 0.152.
 */
package reliquary.blocks;

import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import reliquary.blocks.tile.PassivePedestalBlockEntity;
import reliquary.items.ICreativeTabItemGenerator;
import reliquary.reference.Config;
import reliquary.util.InventoryHelper;
import reliquary.util.WorldHelper;

public class PassivePedestalBlock
extends Block
implements EntityBlock,
ICreativeTabItemGenerator,
SimpleWaterloggedBlock {
    static final DirectionProperty FACING = DirectionProperty.create((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE = Stream.of(Block.box((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), Block.box((double)3.5, (double)9.0, (double)4.0, (double)4.0, (double)10.0, (double)12.0), Block.box((double)12.0, (double)9.0, (double)4.0, (double)12.5, (double)10.0, (double)12.0), Block.box((double)3.5, (double)9.0, (double)3.5, (double)12.5, (double)10.0, (double)4.0), Block.box((double)3.5, (double)9.0, (double)12.0, (double)12.5, (double)10.0, (double)12.5), Block.box((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0), Block.box((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0), Block.box((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public PassivePedestalBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(1.5f, 2.0f).forceSolidOn());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void addCreativeTabItems(Consumer<ItemStack> itemConsumer) {
        if (this.isDisabled()) {
            return;
        }
        itemConsumer.accept(new ItemStack((ItemLike)this));
    }

    protected boolean isDisabled() {
        return Boolean.TRUE.equals(Config.COMMON.disable.disablePassivePedestal.get());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (context.getPlayer() == null) {
            return this.defaultBlockState();
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getPlayer().getDirection())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState state) {
        return Boolean.TRUE.equals(state.getValue((Property)WATERLOGGED)) ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (facing != Direction.DOWN && Boolean.TRUE.equals(state.getValue((Property)WATERLOGGED))) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return player.isCrouching() ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        return WorldHelper.getBlockEntity((BlockGetter)level, pos, PassivePedestalBlockEntity.class).map(pedestal -> {
            if (player.isCrouching()) {
                pedestal.removeAndSpawnItem(level);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }).orElse(InteractionResult.FAIL);
    }

    protected ItemInteractionResult useItemOn(ItemStack heldItem, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        return WorldHelper.getBlockEntity((BlockGetter)level, pos, PassivePedestalBlockEntity.class).map(pedestal -> InventoryHelper.executeOnItemHandlerAt(level, pos, state, pedestal, itemHandler -> InventoryHelper.tryAddingPlayerCurrentItem(player, itemHandler, InteractionHand.MAIN_HAND) ? ItemInteractionResult.SUCCESS : ItemInteractionResult.CONSUME, ItemInteractionResult.CONSUME)).orElse(ItemInteractionResult.FAIL);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        WorldHelper.getBlockEntity((BlockGetter)level, pos, PassivePedestalBlockEntity.class).ifPresent(pedestal -> pedestal.dropPedestalInventory(level));
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PassivePedestalBlockEntity(pos, state);
    }

    public static void onRightClicked(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (player.level().isClientSide() || !player.isCrouching() || !player.getMainHandItem().isEmpty() || player.getOffhandItem().isEmpty()) {
            return;
        }
        Block block = player.level().getBlockState(event.getPos()).getBlock();
        if (!(block instanceof PassivePedestalBlock)) {
            return;
        }
        PassivePedestalBlockEntity pedestal = (PassivePedestalBlockEntity)player.level().getBlockEntity(event.getPos());
        if (pedestal != null) {
            pedestal.removeAndSpawnItem(player.level());
        }
        event.setCanceled(true);
    }
}

