/*
 * Decompiled with CFR 0.152.
 */
package reliquary.blocks;

import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.SpecialPlantable;
import reliquary.items.ICreativeTabItemGenerator;
import reliquary.reference.Config;

public class FertileLilyPadBlock
extends BushBlock
implements ICreativeTabItemGenerator {
    public static final MapCodec<FertileLilyPadBlock> CODEC = FertileLilyPadBlock.simpleCodec(FertileLilyPadBlock::new);
    private static final Map<ResourceKey<Level>, Long> currentDimensionTicks = new HashMap<ResourceKey<Level>, Long>();
    private static final Map<ResourceKey<Level>, Set<BlockPos>> dimensionPositionsTicked = new HashMap<ResourceKey<Level>, Set<BlockPos>>();
    private static final VoxelShape AABB = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.5, (double)15.0);

    public FertileLilyPadBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT));
    }

    private FertileLilyPadBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public void addCreativeTabItems(Consumer<ItemStack> itemConsumer) {
        itemConsumer.accept(new ItemStack((ItemLike)this));
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        if (!level.isClientSide()) {
            level.scheduleTick(pos, (Block)this, 1);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        ResourceKey dimKey = level.dimension();
        if (!currentDimensionTicks.containsKey(dimKey) || currentDimensionTicks.get(dimKey).longValue() != level.getGameTime()) {
            currentDimensionTicks.put((ResourceKey<Level>)dimKey, level.getGameTime());
            dimensionPositionsTicked.put((ResourceKey<Level>)dimKey, new HashSet());
        } else if (dimensionPositionsTicked.computeIfAbsent((ResourceKey<Level>)dimKey, k -> new HashSet()).contains(pos)) {
            return;
        }
        this.growCropsNearby(level, pos, state);
        dimensionPositionsTicked.computeIfAbsent((ResourceKey<Level>)dimKey, k -> new HashSet()).add(pos);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        level.addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)0.0f, (float)0.9f, (float)0.5f), (double)pos.getX() + 0.5 + rand.nextGaussian() / 8.0, (double)pos.getY(), (double)pos.getZ() + 0.5 + rand.nextGaussian() / 8.0, 0.0, 0.0, 0.0);
    }

    private int secondsBetweenGrowthTicks() {
        return (Integer)Config.COMMON.blocks.fertileLilypad.secondsBetweenGrowthTicks.get();
    }

    private int tileRange() {
        return (Integer)Config.COMMON.blocks.fertileLilypad.tileRange.get();
    }

    private int fullPotencyRange() {
        return (Integer)Config.COMMON.blocks.fertileLilypad.fullPotencyRange.get();
    }

    private void growCropsNearby(ServerLevel level, BlockPos pos, BlockState state) {
        BlockPos.betweenClosed((BlockPos)pos.offset(-this.tileRange(), -1, -this.tileRange()), (BlockPos)pos.offset(this.tileRange(), this.tileRange(), this.tileRange())).forEach(cropPos -> {
            if (!level.hasChunkAt(cropPos)) {
                return;
            }
            BlockState cropState = level.getBlockState(cropPos);
            Block cropBlock = cropState.getBlock();
            if (this.isAllowedCropBlock(cropBlock) && (cropBlock instanceof SpecialPlantable || cropBlock instanceof BonemealableBlock) && !(cropBlock instanceof FertileLilyPadBlock)) {
                double distance = Math.sqrt(cropPos.distSqr((Vec3i)pos));
                this.tickCropBlock(level, (BlockPos)cropPos, cropState, cropBlock, distance);
            }
        });
        level.scheduleTick(pos, state.getBlock(), this.secondsBetweenGrowthTicks() * 20);
    }

    private boolean isAllowedCropBlock(Block cropBlock) {
        return cropBlock != Blocks.GRASS_BLOCK && !(cropBlock instanceof DoublePlantBlock);
    }

    private void tickCropBlock(ServerLevel level, BlockPos cropPos, BlockState cropState, Block cropBlock, double distance) {
        distance -= (double)this.fullPotencyRange();
        distance = Math.max(1.0, distance);
        double distanceCoefficient = 1.0 - distance / (double)this.tileRange();
        level.scheduleTick(cropPos, cropBlock, (int)(distanceCoefficient * (double)this.secondsBetweenGrowthTicks() * 20.0));
        cropState.randomTick(level, cropPos, level.random);
        level.levelEvent(2005, cropPos, Math.max((int)((double)this.tileRange() - distance), 1));
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entityIn) {
        super.entityInside(state, level, pos, entityIn);
        if (entityIn instanceof Boat) {
            level.destroyBlock(pos, true);
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        FluidState ifluidstate = level.getFluidState(pos);
        return ifluidstate.getType() == Fluids.WATER || state.getBlock() instanceof IceBlock;
    }
}

