/*
 * Decompiled with CFR 0.152.
 */
package reliquary.blocks;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import reliquary.blocks.tile.AlkahestryAltarBlockEntity;
import reliquary.init.ModBlocks;
import reliquary.items.AlkahestryTomeItem;
import reliquary.items.ICreativeTabItemGenerator;
import reliquary.reference.Config;
import reliquary.util.BlockEntityHelper;

public class AlkahestryAltarBlock
extends Block
implements EntityBlock,
ICreativeTabItemGenerator {
    private static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");

    public AlkahestryAltarBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(1.5f, 5.0f));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void addCreativeTabItems(Consumer<ItemStack> itemConsumer) {
        itemConsumer.accept(new ItemStack((ItemLike)this));
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return Boolean.TRUE.equals(state.getValue((Property)ACTIVE)) ? AlkahestryAltarBlock.getAltarActiveLightLevel() : 0;
    }

    private static int getAltarActiveLightLevel() {
        return (Integer)Config.COMMON.blocks.altar.outputLightLevelWhileActive.get();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ACTIVE});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AlkahestryAltarBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.isClientSide) {
            return null;
        }
        return BlockEntityHelper.createTickerHelper(blockEntityType, ModBlocks.ALKAHESTRY_ALTAR_TILE_TYPE.get(), (l, p, s, be) -> be.serverTick(l, p));
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (Boolean.FALSE.equals(state.getValue((Property)ACTIVE)) || level.getDayTime() >= 12000L || !level.canSeeSkyFromBelowWater(pos.above()) || rand.nextInt(3) != 0) {
            return;
        }
        level.addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)0.9f, (float)0.9f, (float)0.0f), (double)pos.getX() + 0.5 + rand.nextGaussian() / 8.0, (double)pos.getY() + 1.1, (double)pos.getZ() + 0.5 + rand.nextGaussian() / 8.0, 0.0, 0.0, 0.0);
    }

    protected ItemInteractionResult useItemOn(ItemStack heldItem, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult p_316140_) {
        if (Boolean.TRUE.equals(state.getValue((Property)ACTIVE))) {
            return ItemInteractionResult.CONSUME;
        }
        AlkahestryAltarBlockEntity altar = (AlkahestryAltarBlockEntity)level.getBlockEntity(pos);
        if (altar == null || heldItem.isEmpty()) {
            return ItemInteractionResult.SUCCESS;
        }
        if (heldItem.getItem() == Items.REDSTONE) {
            int slot = this.getSlotWithRedstoneDust(player);
            if (slot == -1) {
                return ItemInteractionResult.SUCCESS;
            }
            this.playSoundAndSpawnParticles(level, pos, altar);
            if (level.isClientSide) {
                return ItemInteractionResult.SUCCESS;
            }
            player.getInventory().removeItem(slot, 1);
            altar.addRedstone(level, pos);
        } else if (heldItem.getItem() instanceof AlkahestryTomeItem && AlkahestryTomeItem.getCharge(heldItem) > 0) {
            this.playSoundAndSpawnParticles(level, pos, altar);
            if (level.isClientSide) {
                return ItemInteractionResult.SUCCESS;
            }
            AlkahestryTomeItem.useCharge(heldItem, 1);
            altar.addRedstone(level, pos);
        }
        return ItemInteractionResult.CONSUME;
    }

    private void playSoundAndSpawnParticles(Level level, BlockPos pos, AlkahestryAltarBlockEntity altar) {
        level.playSound(null, pos, SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS, 0.3f, 0.5f + 0.5f * (float)altar.getRedstoneCount() + (float)(level.random.nextGaussian() / 8.0));
        for (int particles = level.random.nextInt(3); particles < 3 + altar.getRedstoneCount() * 4 + altar.getRedstoneCount(); ++particles) {
            level.addParticle((ParticleOptions)DustParticleOptions.REDSTONE, (double)pos.getX() + 0.5 + level.random.nextGaussian() / 5.0, (double)pos.getY() + 1.2, (double)pos.getZ() + 0.5 + level.random.nextGaussian() / 5.0, 1.0, 0.0, 0.0);
        }
    }

    private int getSlotWithRedstoneDust(Player player) {
        for (int slot = 0; slot < player.getInventory().items.size(); ++slot) {
            if (((ItemStack)player.getInventory().items.get(slot)).isEmpty() || ((ItemStack)player.getInventory().items.get(slot)).getItem() != Items.REDSTONE) continue;
            return slot;
        }
        return -1;
    }

    public static void updateAltarBlockState(boolean active, Level level, BlockPos pos) {
        level.setBlockAndUpdate(pos, (BlockState)level.getBlockState(pos).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(active)));
        AlkahestryAltarBlockEntity te = (AlkahestryAltarBlockEntity)level.getBlockEntity(pos);
        if (te != null) {
            if (active) {
                te.startCycle(level);
            } else {
                te.stopCycle();
            }
        }
    }
}

