/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.layers;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.layers.Layer;
import io.wispforest.owo.util.pond.OwoScreenExtension;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.fabricmc.fabric.api.event.Event;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;

public final class Layers {
    public static final ResourceLocation INIT_PHASE = ResourceLocation.fromNamespaceAndPath((String)"owo", (String)"init-layers");
    private static final Multimap<Class<? extends Screen>, Layer<?, ?>> LAYERS = HashMultimap.create();

    @SafeVarargs
    public static <S extends Screen, R extends ParentComponent> Layer<S, R> add(BiFunction<Sizing, Sizing, R> rootComponentMaker, Consumer<Layer.Instance> instanceInitializer, Class<? extends S> ... screenClasses) {
        Layer layer = new Layer(rootComponentMaker, instanceInitializer);
        for (Class<? extends S> screenClass : screenClasses) {
            LAYERS.put(screenClass, layer);
        }
        return layer;
    }

    public static <S extends Screen> Collection<Layer<S, ?>> getLayers(Class<S> screenClass) {
        return LAYERS.get(screenClass);
    }

    public static <S extends Screen> List<Layer.Instance> getInstances(S screen) {
        return ((OwoScreenExtension)screen).owo$getInstancesView();
    }

    static {
        ScreenEvents.AFTER_INIT.addPhaseOrdering(Event.DEFAULT_PHASE, INIT_PHASE);
        ScreenEvents.AFTER_INIT.register(INIT_PHASE, (client, screeen, scaledWidth, scaledHeight) -> {
            ((OwoScreenExtension)screeen).owo$updateLayers();
            ScreenEvents.remove((Screen)screeen).register(screen -> {
                for (Layer.Instance instance : Layers.getInstances(screen)) {
                    instance.adapter.dispose();
                }
            });
            ScreenEvents.beforeRender((Screen)screeen).register((screen, context, mouseX, mouseY, tickDelta) -> {
                for (Layer.Instance instance : Layers.getInstances(screen)) {
                    if (!instance.aggressivePositioning) continue;
                    instance.dispatchLayoutUpdates();
                }
            });
            ScreenEvents.afterRender((Screen)screeen).register((screen, context, mouseX, mouseY, tickDelta) -> {
                context.flush();
                for (Layer.Instance instance : Layers.getInstances(screen)) {
                    instance.adapter.render(context, mouseX, mouseY, tickDelta);
                }
            });
            ScreenMouseEvents.allowMouseClick((Screen)screeen).register((screen, mouseX, mouseY, button) -> {
                for (Layer.Instance instance : Layers.getInstances(screen)) {
                    boolean handled = instance.adapter.mouseClicked(mouseX, mouseY, button);
                    if (!handled) continue;
                    return false;
                }
                return true;
            });
            ScreenMouseEvents.allowMouseRelease((Screen)screeen).register((screen, mouseX, mouseY, button) -> {
                for (Layer.Instance instance : Layers.getInstances(screen)) {
                    boolean handled = instance.adapter.mouseReleased(mouseX, mouseY, button);
                    if (!handled) continue;
                    return false;
                }
                return true;
            });
            ScreenMouseEvents.allowMouseScroll((Screen)screeen).register((screen, mouseX, mouseY, horizontalAmount, verticalAmount) -> {
                for (Layer.Instance instance : Layers.getInstances(screen)) {
                    boolean handled = instance.adapter.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
                    if (!handled) continue;
                    return false;
                }
                return true;
            });
            ScreenKeyboardEvents.allowKeyPress((Screen)screeen).register((screen, key, scancode, modifiers) -> {
                for (Layer.Instance instance : Layers.getInstances(screen)) {
                    boolean handled = instance.adapter.keyPressed(key, scancode, modifiers);
                    if (!handled) continue;
                    return false;
                }
                return true;
            });
            ScreenKeyboardEvents.allowKeyRelease((Screen)screeen).register((screen, key, scancode, modifiers) -> {
                for (Layer.Instance instance : Layers.getInstances(screen)) {
                    boolean handled = instance.adapter.keyReleased(key, scancode, modifiers);
                    if (!handled) continue;
                    return false;
                }
                return true;
            });
        });
    }
}

