/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.config;

import com.google.common.collect.HashMultimap;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.Owo;
import io.wispforest.owo.config.ConfigWrapper;
import io.wispforest.owo.config.Option;
import io.wispforest.owo.mixin.ServerCommonNetworkHandlerAccessor;
import io.wispforest.owo.ops.TextOps;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.ChatFormatting;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLLoader;
import org.jetbrains.annotations.Nullable;

public class ConfigSynchronizer {
    public static final ResourceLocation CONFIG_SYNC_CHANNEL = ResourceLocation.fromNamespaceAndPath((String)"owo", (String)"config_sync");
    private static final Map<Connection, Map<String, Map<Option.Key, Object>>> CLIENT_OPTION_STORAGE = new WeakHashMap<Connection, Map<String, Map<Option.Key, Object>>>();
    private static final Map<String, ConfigWrapper<?>> KNOWN_CONFIGS = new HashMap();
    private static final MutableComponent PREFIX = TextOps.concat(Owo.PREFIX, Component.nullToEmpty((String)"\u00a7cunrecoverable config mismatch\n\n"));

    static void register(ConfigWrapper<?> config) {
        KNOWN_CONFIGS.put(config.name(), config);
    }

    @Nullable
    public static Map<Option.Key, ?> getClientOptions(ServerPlayer player, String configName) {
        Map<String, Map<Option.Key, Object>> storage = CLIENT_OPTION_STORAGE.get(((ServerCommonNetworkHandlerAccessor)player.connection).owo$getConnection());
        if (storage == null) {
            return null;
        }
        return storage.get(configName);
    }

    @Nullable
    public static Map<Option.Key, ?> getClientOptions(ServerPlayer player, ConfigWrapper<?> config) {
        return ConfigSynchronizer.getClientOptions(player, config.name());
    }

    private static ConfigSyncPacket toPacket(Option.SyncMode targetMode) {
        HashMap<String, ConfigEntry> configs = new HashMap<String, ConfigEntry>();
        KNOWN_CONFIGS.forEach((configName, config) -> {
            ConfigEntry entry = new ConfigEntry(new HashMap<String, FriendlyByteBuf>());
            config.allOptions().forEach((key, option) -> {
                if (option.syncMode().ordinal() < targetMode.ordinal()) {
                    return;
                }
                FriendlyByteBuf optionBuf = PacketByteBufs.create();
                option.write(optionBuf);
                entry.options().put(key.asString(), optionBuf);
            });
            configs.put((String)configName, entry);
        });
        return new ConfigSyncPacket(configs);
    }

    private static void read(ConfigSyncPacket packet, BiConsumer<Option<?>, FriendlyByteBuf> optionConsumer) {
        for (Map.Entry<String, ConfigEntry> configEntry : packet.configs().entrySet()) {
            String configName = configEntry.getKey();
            ConfigWrapper<?> config = KNOWN_CONFIGS.get(configName);
            if (config == null) {
                Owo.LOGGER.error("Received overrides for unknown config '{}', skipping", (Object)configName);
                continue;
            }
            for (Map.Entry<String, FriendlyByteBuf> optionEntry : configEntry.getValue().options().entrySet()) {
                Option.Key optionKey = new Option.Key(optionEntry.getKey());
                Option option = config.optionForKey(optionKey);
                if (option == null) {
                    Owo.LOGGER.error("Received override for unknown option '{}' in config '{}', skipping", (Object)optionKey, (Object)configName);
                    continue;
                }
                optionConsumer.accept(option, optionEntry.getValue());
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void applyClient(ConfigSyncPacket payload, ClientPlayNetworking.Context context) {
        Owo.LOGGER.info("Applying server overrides");
        HashMap<Option, Object> mismatchedOptions = new HashMap<Option, Object>();
        if (!context.client().hasSingleplayerServer() || !context.client().getSingleplayerServer().isSingleplayer()) {
            ConfigSynchronizer.read(payload, (option, packetByteBuf) -> {
                Object mismatchedValue = option.read((FriendlyByteBuf)packetByteBuf);
                if (mismatchedValue != null) {
                    mismatchedOptions.put((Option)option, mismatchedValue);
                }
            });
            if (!mismatchedOptions.isEmpty()) {
                Owo.LOGGER.error("Aborting connection, non-syncable config values were mismatched");
                mismatchedOptions.forEach((option, serverValue) -> Owo.LOGGER.error("- Option {} in config '{}' has value '{}' but server requires '{}'", (Object)option.key().asString(), (Object)option.configName(), option.value(), serverValue));
                MutableComponent errorMessage = Component.empty();
                HashMultimap optionsByConfig = HashMultimap.create();
                mismatchedOptions.forEach((option, serverValue) -> optionsByConfig.put((Object)option.configName(), (Object)new Tuple(option, serverValue)));
                for (String configName : optionsByConfig.keys()) {
                    errorMessage.append((Component)TextOps.withFormatting("in config ", ChatFormatting.GRAY)).append(configName).append("\n");
                    for (Tuple option2 : optionsByConfig.get((Object)configName)) {
                        errorMessage.append((Component)Component.translatable((String)((Option)option2.getA()).translationKey()).withStyle(ChatFormatting.YELLOW)).append(" -> ");
                        errorMessage.append(((Option)option2.getA()).value().toString()).append((Component)TextOps.withFormatting(" (client)", ChatFormatting.GRAY));
                        errorMessage.append((Component)TextOps.withFormatting(" / ", ChatFormatting.DARK_GRAY));
                        errorMessage.append(option2.getB().toString()).append((Component)TextOps.withFormatting(" (server)", ChatFormatting.GRAY)).append("\n");
                    }
                    errorMessage.append("\n");
                }
                errorMessage.append((Component)TextOps.withFormatting("these options could not be synchronized because\n", ChatFormatting.GRAY));
                errorMessage.append((Component)TextOps.withFormatting("they require your client to be restarted\n", ChatFormatting.GRAY));
                errorMessage.append((Component)TextOps.withFormatting("change them manually and restart if you want to join this server", ChatFormatting.GRAY));
                context.player().connection.getConnection().disconnect((Component)TextOps.concat((Component)PREFIX, (Component)errorMessage));
                return;
            }
        }
        Owo.LOGGER.info("Responding with client values");
        context.responseSender().sendPacket((CustomPacketPayload)ConfigSynchronizer.toPacket(Option.SyncMode.INFORM_SERVER));
    }

    private static void applyServer(ConfigSyncPacket payload, ServerPlayNetworking.Context context) {
        Owo.LOGGER.info("Receiving client config");
        Connection connection = ((ServerCommonNetworkHandlerAccessor)context.player().connection).owo$getConnection();
        ConfigSynchronizer.read(payload, (option, optionBuf) -> {
            Map config = CLIENT_OPTION_STORAGE.computeIfAbsent(connection, $ -> new HashMap()).computeIfAbsent(option.configName(), s -> new HashMap());
            config.put(option.key(), optionBuf.read(option.endec()));
        });
    }

    static {
        StreamCodec packetCodec = CodecUtils.toPacketCodec(ConfigSyncPacket.ENDEC);
        PayloadTypeRegistry.playS2C().register(ConfigSyncPacket.ID, packetCodec);
        PayloadTypeRegistry.playC2S().register(ConfigSyncPacket.ID, packetCodec);
        ResourceLocation earlyPhase = ResourceLocation.fromNamespaceAndPath((String)"owo", (String)"early");
        ServerPlayConnectionEvents.JOIN.addPhaseOrdering(earlyPhase, Event.DEFAULT_PHASE);
        ServerPlayConnectionEvents.JOIN.register(earlyPhase, (handler, sender, server) -> {
            Owo.LOGGER.info("Sending server config values to client");
            sender.sendPacket((CustomPacketPayload)ConfigSynchronizer.toPacket(Option.SyncMode.OVERRIDE_CLIENT));
        });
        if (FMLLoader.getDist() == Dist.CLIENT) {
            ClientPlayNetworking.registerGlobalReceiver(ConfigSyncPacket.ID, ConfigSynchronizer::applyClient);
            ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> KNOWN_CONFIGS.forEach((name, config) -> config.forEachOption(Option::reattach)));
        }
        ServerPlayNetworking.registerGlobalReceiver(ConfigSyncPacket.ID, ConfigSynchronizer::applyServer);
    }

    private record ConfigSyncPacket(Map<String, ConfigEntry> configs) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<ConfigSyncPacket> ID = new CustomPacketPayload.Type(CONFIG_SYNC_CHANNEL);
        public static final Endec<ConfigSyncPacket> ENDEC = StructEndecBuilder.of((StructField)ConfigEntry.ENDEC.mapOf().fieldOf("configs", ConfigSyncPacket::configs), ConfigSyncPacket::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }
    }

    private record ConfigEntry(Map<String, FriendlyByteBuf> options) {
        public static final Endec<ConfigEntry> ENDEC = StructEndecBuilder.of((StructField)MinecraftEndecs.PACKET_BYTE_BUF.mapOf().fieldOf("options", ConfigEntry::options), ConfigEntry::new);
    }
}

