/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.world.level;

import com.google.common.collect.Lists;
import fuzs.enderzoology.EnderZoology;
import fuzs.enderzoology.init.ModEntityTypes;
import fuzs.enderzoology.init.ModItems;
import fuzs.enderzoology.init.ModRegistry;
import fuzs.enderzoology.world.entity.vehicle.MinecartCharge;
import fuzs.extensibleenums.api.v2.BuiltInEnumFactories;
import fuzs.puzzleslib.api.init.v3.MinecartTypeRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.MinecartTNT;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public enum EnderExplosionType implements StringRepresentable
{
    ENDER("ender"),
    CONFUSION("confusion"),
    CONCUSSION("concussion");

    public static final StringRepresentable.StringRepresentableCodec<EnderExplosionType> CODEC;
    private final String name;
    private final AbstractMinecart.Type minecartType;

    private EnderExplosionType(String name) {
        this.name = name;
        this.minecartType = BuiltInEnumFactories.INSTANCE.createMinecartType(EnderZoology.id(name));
        MinecartTypeRegistry.INSTANCE.register(this.minecartType, (level, x, y, z) -> new MinecartCharge(this, level, x, y, z));
    }

    public List<MobEffectInstance> createEffects(int strength) {
        ArrayList effects = Lists.newArrayList();
        if (this.isTeleport()) {
            effects.add(new MobEffectInstance(ModRegistry.DISPLACEMENT_MOB_EFFECT, 1, strength));
        }
        if (this.isConfusion()) {
            effects.add(new MobEffectInstance(MobEffects.CONFUSION, 100));
        }
        return effects;
    }

    public AbstractMinecart.Type getMinecartType() {
        return this.minecartType;
    }

    public Block getChargeBlock() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> (Block)ModRegistry.ENDER_CHARGE_BLOCK.value();
            case 1 -> (Block)ModRegistry.CONFUSING_CHARGE_BLOCK.value();
            case 2 -> (Block)ModRegistry.CONCUSSION_CHARGE_BLOCK.value();
        };
    }

    public EntityType<? extends MinecartTNT> getMinecartEntityType() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> (EntityType)ModEntityTypes.ENDER_CHARGE_MINECART_ENTITY_TYPE.value();
            case 1 -> (EntityType)ModEntityTypes.CONFUSING_CHARGE_MINECART_ENTITY_TYPE.value();
            case 2 -> (EntityType)ModEntityTypes.CONCUSSION_CHARGE_MINECART_ENTITY_TYPE.value();
        };
    }

    public Item getMinecartItem() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> (Item)ModItems.ENDER_CHARGE_MINECART_ITEM.value();
            case 1 -> (Item)ModItems.CONFUSING_CHARGE_MINECART_ITEM.value();
            case 2 -> (Item)ModItems.CONCUSSION_CHARGE_MINECART_ITEM.value();
        };
    }

    public String getSerializedName() {
        return this.name;
    }

    public boolean isTeleport() {
        return this != CONFUSION;
    }

    public boolean isConfusion() {
        return this != ENDER;
    }

    static {
        CODEC = StringRepresentable.fromEnum(EnderExplosionType::values);
    }
}

