/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.FlyingAnimal;

public class OwlModel<T extends Entity>
extends AgeableListModel<T> {
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart rightWing;
    private final ModelPart leftWing;

    public OwlModel(ModelPart root) {
        super(true, 24.0f, 0.0f, 3.0f, 2.0f, 24.0f);
        this.body = root.getChild("body");
        this.head = root.getChild("head");
        this.rightLeg = this.body.getChild("right_leg");
        this.leftLeg = this.body.getChild("left_leg");
        this.rightWing = this.body.getChild("right_wing");
        this.leftWing = this.body.getChild("left_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 7.0f, 5.0f), PartPose.offset((float)0.0f, (float)15.0f, (float)0.0f));
        body.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(23, 0).addBox(-1.0f, 0.0f, -3.0f, 1.0f, 5.0f, 5.0f), PartPose.offset((float)-3.0f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(23, 0).mirror().addBox(0.0f, 0.0f, -2.5f, 1.0f, 5.0f, 5.0f), PartPose.offset((float)3.0f, (float)0.0f, (float)-0.5f));
        PartDefinition rightLeg = body.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(23, 11).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f), PartPose.offset((float)-1.5f, (float)7.0f, (float)0.0f));
        rightLeg.addOrReplaceChild("right_foot", CubeListBuilder.create().texOffs(28, 11).addBox(-1.0f, 0.0f, -2.0f, 2.0f, 1.0f, 3.0f), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition leftLeg = body.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(23, 11).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f), PartPose.offset((float)1.5f, (float)7.0f, (float)0.0f));
        leftLeg.addOrReplaceChild("left_foot", CubeListBuilder.create().texOffs(28, 11).addBox(-1.0f, 0.0f, -2.0f, 2.0f, 1.0f, 3.0f), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition tailBase = body.addOrReplaceChild("tail_base", CubeListBuilder.create().texOffs(56, 0).addBox(-1.5f, 1.0f, -1.8f, 3.0f, 3.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)3.5f, (float)2.2f, (float)0.64f, (float)0.0f, (float)0.0f));
        tailBase.addOrReplaceChild("tail_part1", CubeListBuilder.create().texOffs(58, 5).addBox(0.0f, 2.0f, -1.7f, 2.0f, 3.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.96f));
        tailBase.addOrReplaceChild("tail_part2", CubeListBuilder.create().texOffs(58, 5).mirror().addBox(-2.0f, 2.0f, -1.7f, 2.0f, 3.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.96f));
        tailBase.addOrReplaceChild("tail_part3", CubeListBuilder.create().texOffs(58, 5).addBox(-1.0f, 2.0f, -1.7f, 2.0f, 3.0f, 1.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 20).addBox(-3.5f, -6.0f, -3.0f, 7.0f, 6.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)15.0f, (float)-0.5f, (float)0.0f, (float)0.05f, (float)0.0f));
        head.addOrReplaceChild("beak", CubeListBuilder.create().texOffs(36, 29).addBox(0.0f, -0.8f, -4.0f, 1.0f, 1.0f, 2.0f), PartPose.offsetAndRotation((float)-0.5f, (float)-2.3f, (float)-0.4f, (float)0.36f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(27, 29).addBox(-5.0f, -8.0f, -3.0f, 3.0f, 2.0f, 1.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(27, 29).mirror().addBox(2.0f, -8.0f, -3.0f, 3.0f, 2.0f, 1.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.leftLeg.xRot = -0.0299f;
        this.rightLeg.xRot = -0.0299f;
        if (((FlyingAnimal)entity).isFlying()) {
            this.leftLeg.xRot += 0.6981317f;
            this.rightLeg.xRot += 0.6981317f;
        }
        this.rightWing.zRot = ageInTicks;
        this.leftWing.zRot = -ageInTicks;
    }
}

