/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.client;

import fuzs.enderzoology.EnderZoology;
import fuzs.enderzoology.client.handler.FovModifierHandler;
import fuzs.enderzoology.client.init.ModelLayerLocations;
import fuzs.enderzoology.client.model.OwlModel;
import fuzs.enderzoology.client.packs.DynamicallyCopiedPackResources;
import fuzs.enderzoology.client.renderer.entity.ConcussionCreeperRenderer;
import fuzs.enderzoology.client.renderer.entity.DireWolfRenderer;
import fuzs.enderzoology.client.renderer.entity.EnderInfestedZombieRenderer;
import fuzs.enderzoology.client.renderer.entity.EnderminyRenderer;
import fuzs.enderzoology.client.renderer.entity.FallenKnightRenderer;
import fuzs.enderzoology.client.renderer.entity.FallenMountRenderer;
import fuzs.enderzoology.client.renderer.entity.OwlRenderer;
import fuzs.enderzoology.client.renderer.entity.WitherCatRenderer;
import fuzs.enderzoology.client.renderer.entity.WitherWitchRenderer;
import fuzs.enderzoology.init.ModEntityTypes;
import fuzs.enderzoology.init.ModItems;
import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.core.v1.context.EntityRenderersContext;
import fuzs.puzzleslib.api.client.core.v1.context.EntitySpectatorShaderContext;
import fuzs.puzzleslib.api.client.core.v1.context.ItemModelPropertiesContext;
import fuzs.puzzleslib.api.client.core.v1.context.LayerDefinitionsContext;
import fuzs.puzzleslib.api.client.event.v1.entity.player.ComputeFovModifierCallback;
import fuzs.puzzleslib.api.client.event.v1.renderer.RenderHandEvents;
import fuzs.puzzleslib.api.core.v1.context.PackRepositorySourcesContext;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.resources.v1.PackResourcesHelper;
import net.minecraft.client.model.CreeperModel;
import net.minecraft.client.model.EndermanModel;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.OcelotModel;
import net.minecraft.client.model.SkeletonModel;
import net.minecraft.client.model.WitchModel;
import net.minecraft.client.model.WolfModel;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.entity.TntMinecartRenderer;
import net.minecraft.client.renderer.entity.TntRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ItemLike;

public class EnderZoologyClient
implements ClientModConstructor {
    public void onConstructMod() {
        EnderZoologyClient.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        ComputeFovModifierCallback.EVENT.register(FovModifierHandler::onComputeFovModifier);
        RenderHandEvents.MAIN_HAND.register((Object)FovModifierHandler.onRenderHand(InteractionHand.MAIN_HAND));
        RenderHandEvents.OFF_HAND.register((arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8, arg_9, arg_10) -> ((RenderHandEvents.MainHand)FovModifierHandler.onRenderHand(InteractionHand.OFF_HAND)).onRenderMainHand(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8, arg_9, arg_10));
    }

    public void onRegisterEntityRenderers(EntityRenderersContext context) {
        context.registerEntityRenderer((EntityType)ModEntityTypes.OWL_EGG_ENTITY_TYPE.value(), ThrownItemRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.PRIMED_CHARGE_ENTITY_TYPE.value(), TntRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.CONCUSSION_CREEPER_ENTITY_TYPE.value(), ConcussionCreeperRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.INFESTED_ZOMBIE_ENTITY_TYPE.value(), EnderInfestedZombieRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.ENDERMINY_ENTITY_TYPE.value(), EnderminyRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.DIRE_WOLF_ENTITY_TYPE.value(), DireWolfRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.FALLEN_MOUNT_ENTITY_TYPE.value(), FallenMountRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.WITHER_CAT_ENTITY_TYPE.value(), WitherCatRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.WITHER_WITCH_ENTITY_TYPE.value(), WitherWitchRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.OWL_ENTITY_TYPE.value(), OwlRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.FALLEN_KNIGHT_ENTITY_TYPE.value(), FallenKnightRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.ENDER_CHARGE_MINECART_ENTITY_TYPE.value(), TntMinecartRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.CONFUSING_CHARGE_MINECART_ENTITY_TYPE.value(), TntMinecartRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.CONCUSSION_CHARGE_MINECART_ENTITY_TYPE.value(), TntMinecartRenderer::new);
    }

    public void onRegisterEntitySpectatorShaders(EntitySpectatorShaderContext context) {
        context.registerSpectatorShader(ResourceLocationHelper.withDefaultNamespace((String)"shaders/post/creeper.json"), new EntityType[]{(EntityType)ModEntityTypes.CONCUSSION_CREEPER_ENTITY_TYPE.value()});
        context.registerSpectatorShader(ResourceLocationHelper.withDefaultNamespace((String)"shaders/post/invert.json"), new EntityType[]{(EntityType)ModEntityTypes.ENDERMINY_ENTITY_TYPE.value()});
    }

    public void onRegisterItemModelProperties(ItemModelPropertiesContext context) {
        context.registerItemProperty(ResourceLocationHelper.withDefaultNamespace((String)"pull"), (itemStack, level, entity, data) -> {
            if (entity == null) {
                return 0.0f;
            }
            return entity.getUseItem() != itemStack ? 0.0f : (float)(itemStack.getUseDuration(entity) - entity.getUseItemRemainingTicks()) / 20.0f;
        }, new ItemLike[]{(ItemLike)ModItems.HUNTING_BOW_ITEM.value()});
        context.registerItemProperty(ResourceLocationHelper.withDefaultNamespace((String)"pulling"), (stack, level, entity, data) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f, new ItemLike[]{(ItemLike)ModItems.HUNTING_BOW_ITEM.value()});
    }

    public void onRegisterLayerDefinitions(LayerDefinitionsContext context) {
        context.registerLayerDefinition(ModelLayerLocations.OWL, OwlModel::createBodyLayer);
        context.registerLayerDefinition(ModelLayerLocations.FALLEN_KNIGHT, SkeletonModel::createBodyLayer);
        context.registerLayerDefinition(ModelLayerLocations.FALLEN_KNIGHT_INNER_ARMOR, () -> LayerDefinition.create((MeshDefinition)HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.5f), (float)0.0f), (int)64, (int)32));
        context.registerLayerDefinition(ModelLayerLocations.FALLEN_KNIGHT_OUTER_ARMOR, () -> LayerDefinition.create((MeshDefinition)HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(1.0f), (float)0.0f), (int)64, (int)32));
        context.registerLayerDefinition(ModelLayerLocations.ENDER_INFESTED_ZOMBIE, () -> LayerDefinition.create((MeshDefinition)HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f), (int)64, (int)64));
        context.registerLayerDefinition(ModelLayerLocations.ENDER_INFESTED_ZOMBIE_INNER_ARMOR, () -> LayerDefinition.create((MeshDefinition)HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.5f), (float)0.0f), (int)64, (int)32));
        context.registerLayerDefinition(ModelLayerLocations.ENDER_INFESTED_ZOMBIE_OUTER_ARMOR, () -> LayerDefinition.create((MeshDefinition)HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(1.0f), (float)0.0f), (int)64, (int)32));
        context.registerLayerDefinition(ModelLayerLocations.ENDERMINY, EndermanModel::createBodyLayer);
        context.registerLayerDefinition(ModelLayerLocations.FALLEN_MOUNT, () -> LayerDefinition.create((MeshDefinition)HorseModel.createBodyMesh((CubeDeformation)CubeDeformation.NONE), (int)64, (int)64));
        context.registerLayerDefinition(ModelLayerLocations.FALLEN_MOUNT_ARMOR, () -> LayerDefinition.create((MeshDefinition)HorseModel.createBodyMesh((CubeDeformation)new CubeDeformation(0.1f)), (int)64, (int)64));
        context.registerLayerDefinition(ModelLayerLocations.WITHER_CAT, () -> LayerDefinition.create((MeshDefinition)OcelotModel.createBodyMesh((CubeDeformation)CubeDeformation.NONE), (int)64, (int)32));
        context.registerLayerDefinition(ModelLayerLocations.WITHER_WITCH, WitchModel::createBodyLayer);
        context.registerLayerDefinition(ModelLayerLocations.DIRE_WOLF, () -> LayerDefinition.create((MeshDefinition)WolfModel.createMeshDefinition((CubeDeformation)CubeDeformation.NONE), (int)64, (int)32));
        context.registerLayerDefinition(ModelLayerLocations.CONCUSSION_CREEPER, () -> CreeperModel.createBodyLayer((CubeDeformation)CubeDeformation.NONE));
        context.registerLayerDefinition(ModelLayerLocations.CONCUSSION_CREEPER_ARMOR, () -> CreeperModel.createBodyLayer((CubeDeformation)new CubeDeformation(2.0f)));
    }

    public void onAddResourcePackFinders(PackRepositorySourcesContext context) {
        context.addRepositorySource(new RepositorySource[]{PackResourcesHelper.buildClientPack((ResourceLocation)EnderZoology.id("dynamically_copied_textures"), DynamicallyCopiedPackResources.create(new DynamicallyCopiedPackResources.TextureCopy(FallenMountRenderer.VANILLA_TEXTURE_LOCATION, FallenMountRenderer.TEXTURE_LOCATION, 64, 64)), (boolean)false)});
    }
}

