/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.pumpkillagersquest_common_neoforge.pumpkillager;

import com.mojang.datafixers.util.Pair;
import com.natamus.pumpkillagersquest_common_neoforge.config.ConfigHandler;
import com.natamus.pumpkillagersquest_common_neoforge.pumpkillager.Conversations;
import com.natamus.pumpkillagersquest_common_neoforge.pumpkillager.Manage;
import com.natamus.pumpkillagersquest_common_neoforge.pumpkillager.Prisoner;
import com.natamus.pumpkillagersquest_common_neoforge.services.Services;
import com.natamus.pumpkillagersquest_common_neoforge.util.Data;
import com.natamus.pumpkillagersquest_common_neoforge.util.GenerateStructure;
import com.natamus.pumpkillagersquest_common_neoforge.util.Scheduler;
import com.natamus.pumpkillagersquest_common_neoforge.util.SpookyHeads;
import com.natamus.pumpkillagersquest_common_neoforge.util.Util;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PlayerHeadBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Actions {
    public static void sendDistanceMessage(Level level, Villager pumpkillager, Player player) {
        Set pumpkillagerTags = pumpkillager.getTags();
        if (pumpkillagerTags.contains("pumpkillagersquest.isleaving")) {
            return;
        }
        if (pumpkillagerTags.contains("pumpkillagersquest.initialencounter")) {
            Conversations.addEmptyMessage(level, pumpkillager, player, 0);
            Conversations.addMessage(level, pumpkillager, player, "Fine. Just leave me here.", ChatFormatting.WHITE, 0);
            Conversations.addMessage(level, pumpkillager, player, "Goodbye, " + player.getName().getString() + ".", ChatFormatting.WHITE, 0);
        } else if (pumpkillagerTags.contains("pumpkillagersquest.finalform")) {
            Conversations.addEmptyMessage(level, pumpkillager, player, 0);
            Conversations.addMessage(level, pumpkillager, player, "There's no running from my new world order, " + player.getName().getString() + ".", ChatFormatting.WHITE, 0);
            Conversations.addMessage(level, pumpkillager, player, "I will find you again. Goodbye.", ChatFormatting.WHITE, 0);
        }
    }

    public static void givePlayerQuestbook(Level level, Villager pumpkillager, Player player) {
        if (!(pumpkillager.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof WrittenBookItem) || pumpkillager.getTags().contains("pumpkillagersquest.questbookgiven")) {
            return;
        }
        pumpkillager.getTags().add("pumpkillagersquest.questbookgiven");
        player.getTags().add("pumpkillagersquest.questbookgiven");
        pumpkillager.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        Conversations.addEmptyMessage(level, pumpkillager, player, 50);
        Conversations.addMessage(level, pumpkillager, player, "Thank you for accepting my quest. Take this book, it will give you more information.", ChatFormatting.WHITE, 60, Data.getQuestbook(level), "give");
        Conversations.addEmptyMessage(level, pumpkillager, player, 2000);
        if (!player.getTags().contains("pumpkillagersquest.wasgiventnt")) {
            Conversations.addMessage(level, pumpkillager, player, "--Before I leave, take this. It might come in handy.", ChatFormatting.WHITE, 2010, new ItemStack((ItemLike)Items.TNT, 1), "give");
            Conversations.addEmptyMessage(level, pumpkillager, player, 4000);
            player.getTags().add("pumpkillagersquest.wasgiventnt");
        } else {
            Conversations.addMessage(level, pumpkillager, player, "I've already given you some tnt.", ChatFormatting.WHITE, 2010);
        }
        Conversations.addMessage(level, pumpkillager, player, "Bye!", ChatFormatting.WHITE, 4010);
        Scheduler.scheduleCharacterLeave(level, pumpkillager, 5000);
    }

    public static ItemStack generatePrisonAndCoordinatePaper(Level level, Villager pumpkillager, Player player) {
        Object coordinateString = "";
        BlockPos prisonerCampCoordinates = Util.getPrisonerCampCoordinates(level, pumpkillager, player);
        if (prisonerCampCoordinates != null) {
            coordinateString = prisonerCampCoordinates.getX() + ", " + prisonerCampCoordinates.getY() + ", " + prisonerCampCoordinates.getZ();
        }
        ItemStack paperStack = new ItemStack((ItemLike)Items.PAPER, 1);
        paperStack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)("Prisoner Coordinates: " + (String)coordinateString + ".")));
        CompletableFuture.runAsync(() -> GenerateStructure.generatePrisonerCamp(level, player, prisonerCampCoordinates, 40));
        return paperStack;
    }

    public static void makePrisonerGuardsStepOffHorse(Level level, Villager prisoner, Player targetPlayer) {
        for (Entity entityAround : level.getEntities(null, new AABB(prisoner.getX() - 30.0, prisoner.getY() - 30.0, prisoner.getZ() - 30.0, prisoner.getX() + 30.0, prisoner.getY() + 30.0, prisoner.getZ() + 30.0))) {
            if (!(entityAround instanceof SkeletonHorse)) continue;
            SkeletonHorse skeletonHorse = (SkeletonHorse)entityAround;
            skeletonHorse.unRide();
            break;
        }
    }

    public static void processPrisonerItemGeneration(Level level, Villager prisoner, Player player, int msDelay) {
        new Thread(() -> {
            try {
                Thread.sleep(msDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Vec3 pvec = prisoner.position();
            level.explode(null, level.damageSources().explosion(null, null), null, pvec.x, pvec.y, pvec.z, 3.0f, false, Level.ExplosionInteraction.NONE);
            Conversations.startTalking(level, prisoner, player, 6);
        }).start();
    }

    public static void startFinalBossSequence(Level level, Player player, BlockPos centerPos, List<Pair<BlockPos, BlockState>> candlePositions) {
        Vec3 centerVec = new Vec3((double)centerPos.getX() + 0.5, (double)centerPos.getY(), (double)centerPos.getZ() + 0.5);
        level.explode(null, level.damageSources().explosion(null, null), null, centerVec.x, centerVec.y, centerVec.z, 3.0f, false, Level.ExplosionInteraction.NONE);
        level.setBlock(centerPos, Blocks.AIR.defaultBlockState(), 3);
        for (Pair<BlockPos, BlockState> candlePair : candlePositions) {
            boolean bl = false;
        }
        Villager pumpkillager = Manage.createPumpkillager(level, centerPos, player, VillagerProfession.WEAPONSMITH, SpookyHeads.getEvilJackoLantern(1), Data.defaultPumpkillagerColour, "3.0", false);
        pumpkillager.getTags().add("pumpkillagersquest.nodamage");
        pumpkillager.getTags().add("pumpkillagersquest.finalform");
        level.setBlock(centerPos.below(), Blocks.OBSIDIAN.defaultBlockState(), 3);
        level.addFreshEntity((Entity)pumpkillager);
        Services.PUMPKILLAGER_API.pumpkillagerSummonEvent(player, pumpkillager, centerPos, "FINAL_BOSS");
        Conversations.startTalking(level, pumpkillager, player, 7);
    }

    public static void pumpkillagerLightning(Level level, Villager pumpkillager, Player targetPlayer) {
        new Thread(() -> {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (pumpkillager.isRemoved() || !Data.allPumpkillagers.get(level).contains(pumpkillager)) {
                return;
            }
            if (!pumpkillager.getTags().contains("pumpkillagersquest.summoninglightning")) {
                return;
            }
            level.getServer().execute(() -> {
                BlockPos playerPos = targetPlayer.blockPosition();
                new Thread(() -> {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Data.lightningTasks.get(level).put(pumpkillager, () -> {
                        if (!pumpkillager.getTags().contains("pumpkillagersquest.firstlightning")) {
                            Conversations.sendJaxMessage(level, targetPlayer, targetPlayer.getName().getString() + "! The Pumpkillager is summoning lightning at your position! It looks like it's delayed, so just keep moving!", ChatFormatting.WHITE, 10);
                            pumpkillager.getTags().add("pumpkillagersquest.firstlightning");
                        }
                        Util.spawnLightning(level, playerPos, (LivingEntity)targetPlayer, targetPlayer, false);
                    });
                }).start();
            });
            Actions.pumpkillagerLightning(level, pumpkillager, targetPlayer);
        }).start();
    }

    public static void startWeakenedBossEvent(Level level, Villager pumpkillager, Player player) {
        Conversations.addEmptyMessage(level, null, player, 1500);
        Conversations.sendJaxMessage(level, player, "You did it! Now finish him!", ChatFormatting.GRAY, 1510);
        ServerBossEvent serverBossEvent = new ServerBossEvent((Component)Component.translatable((String)"The Pumpkillager"), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);
        Data.pumpkillagerBossEvents.put(pumpkillager, serverBossEvent);
        if (!level.isClientSide) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverBossEvent.addPlayer(serverPlayer);
        }
        Conversations.startTalking(level, pumpkillager, player, 8);
    }

    public static void shrinkAndKillPumpkillager(Level level, Villager pumpkillager, Player targetPlayer) {
        ItemStack feetStack;
        ServerBossEvent serverBossEvent;
        pumpkillager.getTags().remove("pumpkillagersquest.summoninglightning");
        pumpkillager.getTags().add("pumpkillagersquest.iskilled");
        if (!level.isClientSide && (serverBossEvent = Data.pumpkillagerBossEvents.get(pumpkillager)) != null) {
            serverBossEvent.setProgress(0.0f);
            serverBossEvent.setVisible(false);
            serverBossEvent.removeAllPlayers();
            Data.pumpkillagerBossEvents.remove(pumpkillager);
        }
        if ((feetStack = pumpkillager.getItemBySlot(EquipmentSlot.FEET)).getItem().equals(Items.BARRIER)) {
            feetStack.setCount(10);
        }
        if (targetPlayer != null) {
            targetPlayer.getTags().remove("pumpkillagersquest.aimforfeet");
            Conversations.addPostDeathMessage(level, pumpkillager, targetPlayer, "", ChatFormatting.WHITE);
            Conversations.addPostDeathMessage(level, pumpkillager, targetPlayer, "I can't believe you've defeated me.. Goodbye, cruel world.", ChatFormatting.WHITE);
        }
    }

    public static void turnPumpkillagerIntoHead(Level level, Villager pumpkillager, Player targetPlayer) {
        BlockPos headPos = pumpkillager.blockPosition().immutable();
        float floatRotation = pumpkillager.getYHeadRot() + 180.0f;
        if (floatRotation > 360.0f) {
            floatRotation -= 360.0f;
        }
        PlayerHeadBlock playerHeadBlock = (PlayerHeadBlock)Blocks.PLAYER_HEAD;
        int intRotation = Mth.floor((double)((double)(floatRotation * 16.0f / 360.0f) + 0.5)) & 0xF;
        BlockState playerHeadBlockState = (BlockState)playerHeadBlock.defaultBlockState().setValue((Property)SkullBlock.ROTATION, (Comparable)Integer.valueOf(intRotation));
        level.setBlock(headPos, playerHeadBlockState, 3);
        playerHeadBlock.setPlacedBy(level, headPos, playerHeadBlockState, null, SpookyHeads.getEvilJackoLantern(1));
        level.playSound(null, pumpkillager.getX(), pumpkillager.getY(), pumpkillager.getZ(), SoundEvents.UI_TOAST_CHALLENGE_COMPLETE, SoundSource.AMBIENT, 2.0f, 1.0f);
        pumpkillager.remove(Entity.RemovalReason.KILLED);
        new Thread(() -> {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            level.getServer().execute(() -> Actions.spawnPostFinalBossPrisoner(level, headPos, targetPlayer));
        }).start();
    }

    public static void spawnPostFinalBossPrisoner(Level level, BlockPos pumpkillagerPos, Player targetPlayer) {
        BlockPos prisonerPos = pumpkillagerPos.above(2).immutable();
        Vec3 prisonerVec = new Vec3((double)prisonerPos.getX() + 0.5, (double)prisonerPos.getY(), (double)prisonerPos.getZ() + 0.5);
        Villager prisoner = Prisoner.createPrisoner(level, prisonerPos, targetPlayer, VillagerProfession.NITWIT, SpookyHeads.getCarvedPumpkin(1), ChatFormatting.GOLD, true);
        prisoner.getBrain().removeAllBehaviors();
        prisoner.setNoGravity(true);
        prisoner.getTags().add("pumpkillagersquest.lookingatplayer");
        prisoner.getTags().add("pumpkillagersquest.afterfinal");
        prisoner.getTags().add("pumpkillagersquest.isknownto." + targetPlayer.getName().getString());
        targetPlayer.getTags().add("pumpkillagersquest.completedquest");
        level.addFreshEntity((Entity)prisoner);
        level.explode(null, level.damageSources().explosion(null, null), null, prisonerVec.x, prisonerVec.y, prisonerVec.z, 3.0f, false, Level.ExplosionInteraction.NONE);
        if (!level.isClientSide) {
            ExperienceOrb.award((ServerLevel)((ServerLevel)level), (Vec3)new Vec3((double)pumpkillagerPos.getX() + 0.5, (double)pumpkillagerPos.getY(), (double)pumpkillagerPos.getZ() + 0.5), (int)ConfigHandler.experienceAmountRewardFinalBoss);
        }
        Conversations.startTalking(level, prisoner, targetPlayer, 9);
    }
}

