/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.pumpkillagersquest_common_fabric.events;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_fabric.functions.EntityFunctions;
import com.natamus.collective_common_fabric.functions.MessageFunctions;
import com.natamus.collective_common_fabric.functions.TaskFunctions;
import com.natamus.pumpkillagersquest_common_fabric.pumpkillager.Actions;
import com.natamus.pumpkillagersquest_common_fabric.pumpkillager.Conversations;
import com.natamus.pumpkillagersquest_common_fabric.pumpkillager.Manage;
import com.natamus.pumpkillagersquest_common_fabric.pumpkillager.Prisoner;
import com.natamus.pumpkillagersquest_common_fabric.pumpkillager.Summon;
import com.natamus.pumpkillagersquest_common_fabric.util.Data;
import com.natamus.pumpkillagersquest_common_fabric.util.Util;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1679;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1809;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3213;
import net.minecraft.class_5250;

public class PkLivingEvents {
    public static float onDamagePumpkillager(class_1937 level, class_1297 entity, class_1282 damageSource, float damageAmount) {
        boolean yeet;
        if (entity.method_5752().contains("pumpkillagersquest.summoned") && damageSource.method_5525().equals("lightningBolt")) {
            return 0.0f;
        }
        if (!(entity instanceof class_1646) && !(entity instanceof class_1657)) {
            return damageAmount;
        }
        class_1297 sourceEntity = damageSource.method_5529();
        class_1297 directSourceEntity = damageSource.method_5526();
        if (entity instanceof class_1657) {
            class_2338 ppos = entity.method_24515();
            if (damageSource.toString().contains("explosion") && (Data.allPumpkillagers.get(level).size() > 0 || Data.allPrisoners.get(level).size() > 0)) {
                for (class_1297 nearbyEntity : level.method_8335(null, new class_238((double)(ppos.method_10263() - 10), (double)(ppos.method_10264() - 10), (double)(ppos.method_10260() - 10), (double)(ppos.method_10263() + 10), (double)(ppos.method_10264() + 10), (double)(ppos.method_10260() + 10)))) {
                    if (!(nearbyEntity instanceof class_1646) || !Util.isPumpkillager(nearbyEntity) && !Util.isPrisoner(nearbyEntity)) continue;
                    return 0.0f;
                }
            }
            return damageAmount;
        }
        if (!Util.isPumpkillager(entity)) {
            if (Util.isPrisoner(entity)) {
                if (sourceEntity instanceof class_1309 && !(sourceEntity instanceof class_1657)) {
                    Manage.yeetLivingEntityIntoSky(level, (class_1309)sourceEntity);
                }
                return 0.0f;
            }
            return damageAmount;
        }
        class_1646 pumpkillager = (class_1646)entity;
        class_2338 pos = pumpkillager.method_24515();
        Set pumpkillagerTags = pumpkillager.method_5752();
        float returnDamage = damageAmount;
        if (!pumpkillagerTags.contains("pumpkillagersquest.isweakened")) {
            returnDamage = 0.0f;
        } else if (!(sourceEntity instanceof class_1657)) {
            returnDamage = 0.0f;
        }
        boolean bl = yeet = !pumpkillagerTags.contains("pumpkillagersquest.nodamage") && !pumpkillagerTags.contains("pumpkillagersquest.isweakened");
        if (sourceEntity instanceof class_1657) {
            class_1657 player = (class_1657)sourceEntity;
            if (yeet) {
                MessageFunctions.sendMessage((class_1657)player, (class_5250)class_2561.method_43470((String)""));
                Conversations.addMessage(level, pumpkillager, player, "You cannot kill me, " + player.method_5477().getString() + ".", class_124.field_1068, 0);
                Conversations.addMessage(level, pumpkillager, player, "I will be back.", class_124.field_1068, 0);
                pumpkillager.method_5752().add("pumpkillagersquest.preventactions");
                Manage.initiateCharacterLeave(level, pumpkillager);
            } else if (!pumpkillagerTags.contains("pumpkillagersquest.isweakened")) {
                if (directSourceEntity instanceof class_1679) {
                    pumpkillager.method_6092(new class_1293(class_1294.field_5912, Integer.MAX_VALUE));
                    pumpkillager.method_5752().add("pumpkillagersquest.isweakened");
                    pumpkillager.method_5752().remove("pumpkillagersquest.nodamage");
                    Actions.startWeakenedBossEvent(level, pumpkillager, player);
                    return returnDamage;
                }
                if (!player.method_7337()) {
                    Conversations.addMessageWithoutPrefix(level, pumpkillager, player, "Your damage is reflected back to you!", class_124.field_1080, 0);
                    float playerDamage = damageAmount;
                    if (playerDamage > 3.0f) {
                        playerDamage = 3.0f;
                    }
                    player.method_5643(level.method_48963().method_48812((class_1309)pumpkillager), playerDamage);
                }
                if (pumpkillagerTags.contains("pumpkillagersquest.finalform")) {
                    Conversations.addEmptyMessage(level, pumpkillager, player, 0);
                    Conversations.addMessageWithoutPrefix(level, pumpkillager, player, "It doesn't look like you did any damage!", class_124.field_1080, 10);
                    Conversations.addMessageWithoutPrefix(level, pumpkillager, player, "Perhaps Jax o'Saturn's spectral arrows could weaken him?", class_124.field_1080, 20);
                    Prisoner.checkForSpectralArrows(level, pumpkillager, player);
                }
            } else {
                class_3213 serverBossEvent = Data.pumpkillagerBossEvents.get(pumpkillager);
                float currentHealth = pumpkillager.method_6032();
                float newHealth = currentHealth - damageAmount;
                returnDamage = 0.0f;
                EntityFunctions.forceSetHealth((class_1309)pumpkillager, (float)newHealth);
                if (serverBossEvent != null) {
                    serverBossEvent.method_5408(newHealth / Data.pumpkillagerMaxHealth);
                }
                if (!pumpkillager.method_5752().contains("pumpkillagersquest.saidouch")) {
                    Conversations.addMessage(level, pumpkillager, player, "Ouch!", class_124.field_1080, 0);
                    pumpkillager.method_5752().add("pumpkillagersquest.saidouch");
                }
                Summon.checkForNewSummon(level, pumpkillager, player, newHealth);
            }
        } else if (sourceEntity instanceof class_1309 && !sourceEntity.method_5752().contains("pumpkillagersquest.summoned")) {
            Manage.yeetLivingEntityIntoSky(level, (class_1309)sourceEntity);
        }
        return returnDamage;
    }

    public static boolean onLivingDeath(class_1309 livingEntity, class_1282 damageSource, float damageAmount) {
        if (livingEntity instanceof class_1657) {
            if (Data.pumpkillagerPlayerTarget.size() > 0) {
                class_1657 player = (class_1657)livingEntity;
                class_1937 level = player.method_37908();
                for (class_1646 pumpkillager : Data.pumpkillagerPlayerTarget.keySet()) {
                    class_1657 targetPlayer;
                    if (!pumpkillager.method_5752().contains("pumpkillagersquest.finalform") || !(targetPlayer = Data.pumpkillagerPlayerTarget.get(pumpkillager)).method_5477().getString().equals(player.method_5477().getString())) continue;
                    targetPlayer.method_5752().add("pumpkillagersquest.diedonce");
                    targetPlayer.method_5752().remove("pumpkillagersquest.aimforfeet");
                    Conversations.addEmptyMessage(level, pumpkillager, targetPlayer, 0);
                    Conversations.addMessage(level, pumpkillager, player, "I knew you couldn't defeat me, " + targetPlayer.method_5477().getString() + ".", class_124.field_1068, 1);
                    Conversations.addMessage(level, pumpkillager, player, "Bye.", class_124.field_1068, 20);
                    Manage.initiateCharacterLeave(level, pumpkillager);
                    return true;
                }
            }
        } else if (Util.isPumpkillager((class_1297)livingEntity)) {
            class_1646 pumpkillager = (class_1646)livingEntity;
            pumpkillager.method_6033(1000.0f);
            Actions.shrinkAndKillPumpkillager(pumpkillager.method_37908(), pumpkillager, Data.pumpkillagerPlayerTarget.get(pumpkillager));
            return false;
        }
        return true;
    }

    public static void onEntityItemDrop(class_1937 level, class_1309 livingEntity, class_1282 damageSource) {
        if (level.field_9236) {
            return;
        }
        if (!livingEntity.method_16914()) {
            return;
        }
        String entityName = livingEntity.method_5477().getString();
        if (!entityName.contains("Ghost")) {
            return;
        }
        class_1799 headStack = livingEntity.method_6118(class_1304.field_6169);
        class_1792 headItem = headStack.method_7909();
        if (headItem instanceof class_1809) {
            class_2338 epos = livingEntity.method_24515();
            TaskFunctions.enqueueTask((class_1937)level, () -> {
                ArrayList<class_1542> dropEntities = new ArrayList<class_1542>();
                for (Object ea : level.method_8335(null, new class_238((double)(epos.method_10263() - 1), (double)(epos.method_10264() - 1), (double)(epos.method_10260() - 1), (double)(epos.method_10263() + 1), (double)(epos.method_10264() + 1), (double)(epos.method_10260() + 1)))) {
                    if (!(ea instanceof class_1542)) continue;
                    dropEntities.add((class_1542)ea);
                }
                boolean foundStack = false;
                for (class_1542 dropEntity : dropEntities) {
                    if (!dropEntity.method_6983().method_7909().equals(headItem)) continue;
                    foundStack = true;
                    break;
                }
                class_243 vec = livingEntity.method_19538();
                if (!foundStack) {
                    level.method_8649((class_1297)new class_1542(level, vec.field_1352, vec.field_1351 + 0.5, vec.field_1350, headStack));
                    class_1297 sourceEntity = damageSource.method_5529();
                    if (sourceEntity instanceof class_1657) {
                        class_1657 player = (class_1657)sourceEntity;
                        String deathMessageString = "You'll never get away with this!";
                        if (entityName.contains("Rider")) {
                            deathMessageString = "No! This was supposed to be a new age!";
                        }
                        Data.messagesToSend.get(level).add((Pair<class_1657, class_5250>)new Pair((Object)player, (Object)Data.addCharacterPrefix(entityName, player, class_2561.method_43471((String)deathMessageString))));
                    }
                }
            }, (int)0);
        }
    }
}

