/*
 * Decompiled with CFR 0.152.
 */
package fuzs.echochest.world.level.block.entity;

import fuzs.echochest.init.ModRegistry;
import fuzs.echochest.world.level.block.entity.EchoChestBlockEntity;
import java.util.Optional;
import net.minecraft.Optionull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.GameEventTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.phys.Vec3;

final class EchoChestListener
implements GameEventListener {
    private final EchoChestBlockEntity blockEntity;
    private final PositionSource positionSource;

    EchoChestListener(EchoChestBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
        this.positionSource = new BlockPositionSource(blockEntity.getBlockPos());
    }

    public PositionSource getListenerSource() {
        return this.positionSource;
    }

    public int getListenerRadius() {
        return 8;
    }

    public boolean handleGameEvent(ServerLevel level, Holder<GameEvent> gameEvent, GameEvent.Context context, Vec3 pos) {
        Optional optional;
        if (this.isValidVibration(gameEvent, context) && (optional = this.getListenerSource().getPosition((Level)level)).isPresent()) {
            Vec3 destination = (Vec3)optional.get();
            if (VibrationSystem.Listener.isOccluded((Level)level, (Vec3)pos, (Vec3)destination)) {
                return false;
            }
            if (!this.canReceiveVibration(level, BlockPos.containing((Position)pos), gameEvent, context)) {
                return false;
            }
            this.blockEntity.animate();
            int travelTimeInTicks = Mth.floor((double)pos.distanceTo(destination));
            level.sendParticles((ParticleOptions)new VibrationParticleOption(this.getListenerSource(), travelTimeInTicks), pos.x(), pos.y(), pos.z(), 1, 0.0, 0.0, 0.0, 0.0);
            return true;
        }
        return false;
    }

    public boolean isValidVibration(Holder<GameEvent> gameEvent, GameEvent.Context context) {
        if (!gameEvent.is(ModRegistry.ECHO_CHEST_CAN_LISTEN)) {
            return false;
        }
        Entity entity = context.sourceEntity();
        if (entity != null) {
            if (entity.isSpectator()) {
                return false;
            }
            if (entity.isSteppingCarefully() && gameEvent.is(GameEventTags.IGNORE_VIBRATIONS_SNEAKING)) {
                return false;
            }
            if (!(entity instanceof ItemEntity) && entity.dampensVibrations()) {
                return false;
            }
        } else {
            return false;
        }
        if (context.affectedState() != null) {
            return !context.affectedState().is(BlockTags.DAMPENS_VIBRATIONS);
        }
        return true;
    }

    public boolean canReceiveVibration(ServerLevel level, BlockPos pos, Holder<GameEvent> gameEvent, GameEvent.Context context) {
        if (gameEvent.is((Holder)GameEvent.ENTITY_DIE)) {
            Entity entity = context.sourceEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (this.blockEntity.canAcceptExperience() && !livingEntity.wasExperienceConsumed()) {
                    DamageSource damageSource = livingEntity.getLastDamageSource();
                    int experienceReward = livingEntity.getExperienceReward(level, (Entity)Optionull.map((Object)damageSource, DamageSource::getEntity));
                    if (livingEntity.shouldDropExperience() && experienceReward > 0) {
                        this.blockEntity.acceptExperience(experienceReward);
                    }
                    livingEntity.skipDropExperience();
                    return true;
                }
            }
        } else {
            ItemEntity item;
            Entity livingEntity = context.sourceEntity();
            if (livingEntity instanceof ItemEntity && !(item = (ItemEntity)livingEntity).isRemoved()) {
                int oldCount = item.getItem().getCount();
                return HopperBlockEntity.addItem((Container)this.blockEntity, (ItemEntity)item) || oldCount != item.getItem().getCount();
            }
        }
        return false;
    }

    public GameEventListener.DeliveryMode getDeliveryMode() {
        return GameEventListener.DeliveryMode.BY_DISTANCE;
    }
}

