/*
 * Decompiled with CFR 0.152.
 */
package fuzs.echochest.world.level.block.entity;

import fuzs.echochest.EchoChest;
import fuzs.echochest.init.ModRegistry;
import fuzs.echochest.world.inventory.EchoChestMenu;
import fuzs.echochest.world.level.block.entity.EchoChestListener;
import fuzs.echochest.world.level.block.entity.EchoChestOpenersCounter;
import fuzs.puzzleslib.api.block.v1.entity.TickingBlockEntity;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EnderChestBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEventListener;
import org.jetbrains.annotations.Nullable;

public class EchoChestBlockEntity
extends ChestBlockEntity
implements WorldlyContainer,
GameEventListener.Provider<GameEventListener>,
TickingBlockEntity {
    public static final String TAG_EXPERIENCE = EchoChest.id("experience").toString();
    public static final MutableComponent CONTAINER_ECHO_CHEST = Component.translatable((String)"container.echo_chest");
    public static final int CONTAINER_SIZE = 25;
    public static final int MAX_EXPERIENCE = 3000;
    public static final int EXPERIENCE_PER_BOTTLE = 7;
    private final ContainerData dataAccess;
    private final EchoChestOpenersCounter openersCounter;
    private final int[] allSlots;
    private final int[] inventorySlots;
    private final GameEventListener listener;
    private int experience;

    public EchoChestBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModRegistry.ECHO_CHEST_BLOCK_ENTITY_TYPE.value(), blockPos, blockState);
        this.setItems(NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY));
        this.allSlots = IntStream.range(0, this.getContainerSize()).toArray();
        this.inventorySlots = IntStream.range(1, this.getContainerSize()).toArray();
        this.openersCounter = new EchoChestOpenersCounter((Container)this);
        this.listener = new EchoChestListener(this);
        this.dataAccess = new ContainerData(){

            public int get(int index) {
                return index == 0 ? EchoChestBlockEntity.this.experience : 0;
            }

            public void set(int index, int value) {
                if (index == 0) {
                    EchoChestBlockEntity.this.experience = value;
                }
            }

            public int getCount() {
                return 1;
            }
        };
    }

    public void clientTick() {
        EchoChestBlockEntity.lidAnimateTick((Level)this.getLevel(), (BlockPos)this.getBlockPos(), (BlockState)this.getBlockState(), (ChestBlockEntity)this);
    }

    public void serverTick() {
        if (this.experience >= 7 && EchoChestMenu.validBottleItem(this.getItem(0)) && HopperBlockEntity.addItem(null, (Container)this, (ItemStack)new ItemStack((ItemLike)Items.EXPERIENCE_BOTTLE), null).isEmpty()) {
            this.extractExperienceBottle();
            ItemStack stack = this.getItem(0).copy();
            stack.shrink(1);
            this.setItem(0, stack);
        }
    }

    void animate() {
        this.openersCounter.incrementOpeners(null, this.getLevel(), this.getBlockPos(), this.getBlockState());
        if (!((Boolean)this.getBlockState().getValue((Property)EnderChestBlock.WATERLOGGED)).booleanValue()) {
            this.getLevel().playSound(null, (double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + 0.5, SoundEvents.DEEPSLATE_BRICKS_BREAK, SoundSource.BLOCKS, 1.0f, this.getLevel().random.nextFloat() * 0.2f + 0.8f);
        }
    }

    public int getContainerSize() {
        return 25;
    }

    protected Component getDefaultName() {
        return CONTAINER_ECHO_CHEST;
    }

    public boolean canAcceptExperience() {
        return this.experience < 3000;
    }

    public void acceptExperience(int amount) {
        int lastExperience = this.experience;
        this.experience = Mth.clamp((int)(this.experience + amount), (int)0, (int)3000);
        if (this.experience != lastExperience) {
            this.setChanged();
        }
    }

    public void extractExperienceBottle() {
        this.acceptExperience(-7);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.setItems(NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY));
        if (!this.tryLoadLootTable(tag)) {
            ContainerHelper.loadAllItems((CompoundTag)tag, (NonNullList)this.getItems(), (HolderLookup.Provider)registries);
        }
        this.experience = tag.getInt(TAG_EXPERIENCE);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (!this.trySaveLootTable(tag)) {
            ContainerHelper.saveAllItems((CompoundTag)tag, (NonNullList)this.getItems(), (boolean)true, (HolderLookup.Provider)registries);
        }
        tag.putInt(TAG_EXPERIENCE, this.experience);
    }

    protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new EchoChestMenu(containerId, inventory, (Container)this, this.dataAccess);
    }

    public void startOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.openersCounter.incrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.openersCounter.decrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void recheckOpen() {
        if (!this.remove) {
            this.openersCounter.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return index != 0 || EchoChestMenu.validBottleItem(stack);
    }

    public int[] getSlotsForFace(Direction side) {
        return side.getAxis().getPlane() == Direction.Plane.HORIZONTAL ? this.allSlots : this.inventorySlots;
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack itemStack, @Nullable Direction direction) {
        return (index != 0 || direction != null) && this.canPlaceItem(index, itemStack);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return index != 0;
    }

    public GameEventListener getListener() {
        return this.listener;
    }
}

