/*
 * Decompiled with CFR 0.152.
 */
package fuzs.echochest.mixin;

import fuzs.echochest.init.ModRegistry;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
abstract class ItemEntityMixin
extends Entity {
    @Unique
    private int echochest$tickCooldown;

    public ItemEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.echochest$tickCooldown = 30 + this.random.nextInt(20);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo callback) {
        if (!this.isRemoved() && !this.level().isClientSide && --this.echochest$tickCooldown == 0) {
            this.gameEvent((Holder)ModRegistry.ITEM_TICK_GAME_EVENT);
            this.echochest$tickCooldown = 30 + this.random.nextInt(20);
        }
    }
}

