/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.variantsandventures.common.entity.event;

import com.faboslav.variantsandventures.common.events.entity.EntitySpawnEvent;
import com.faboslav.variantsandventures.common.versions.VersionedEntitySpawnReason;
import net.minecraft.core.Holder;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;

public final class OnEntitySpawn {
    public static boolean handleOnEntitySpawn(EntitySpawnEvent event, EntityType<? extends Mob> entityTypeToReplace, EntityType<? extends Mob> entityTypeToSpawn, boolean spawnCondition, double spawnChanceCondition, int minimumSpawnYLevel, TagKey<Biome> biomeTagKey) {
        Mob entity = event.entity();
        RandomSource random = entity.getRandom();
        if (event.spawnReason() == VersionedEntitySpawnReason.NATURAL || event.spawnReason() == VersionedEntitySpawnReason.CHUNK_GENERATION || event.spawnReason() == VersionedEntitySpawnReason.STRUCTURE) {
            if (entity.getType() != entityTypeToReplace) {
                return false;
            }
            if (!spawnCondition || (double)random.nextFloat() >= spawnChanceCondition || entity.blockPosition().getY() < minimumSpawnYLevel) {
                return false;
            }
            LevelAccessor world = event.worldAccess();
            Holder biome = world.getBiome(entity.blockPosition());
            if (!biome.is(biomeTagKey)) {
                return false;
            }
            Mob entityToSpawn = (Mob)entityTypeToSpawn.create(entity.level());
            if (entityToSpawn == null) {
                return false;
            }
            entityToSpawn.moveTo(entity.getX(), entity.getY(), entity.getZ(), entityToSpawn.getRandom().nextFloat() * 360.0f, 0.0f);
            entityToSpawn.copyPosition((Entity)entity);
            entityToSpawn.yBodyRotO = entity.yBodyRotO;
            entityToSpawn.yBodyRot = entity.yBodyRot;
            entityToSpawn.yHeadRotO = entity.yHeadRotO;
            entityToSpawn.yHeadRot = entity.yHeadRot;
            entityToSpawn.setBaby(entity.isBaby());
            entityToSpawn.setNoAi(entity.isNoAi());
            entityToSpawn.setInvulnerable(entity.isInvulnerable());
            if (entity.hasCustomName()) {
                entityToSpawn.setCustomName(entity.getCustomName());
                entityToSpawn.setCustomNameVisible(entity.isCustomNameVisible());
            }
            if (entity.isPersistenceRequired()) {
                entityToSpawn.setPersistenceRequired();
            }
            entityToSpawn.setCanPickUpLoot(entity.canPickUpLoot());
            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                ItemStack itemStack = entity.getItemBySlot(equipmentSlot);
                if (itemStack.isEmpty()) continue;
                entityToSpawn.setItemSlot(equipmentSlot, itemStack.copyAndClear());
                entityToSpawn.setDropChance(equipmentSlot, entity.getEquipmentDropChance(equipmentSlot));
            }
            entityToSpawn.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(entity.blockPosition()), event.spawnReason(), null);
            boolean spawnResult = world.addFreshEntity((Entity)entityToSpawn);
            if (!spawnResult) {
                entity.discard();
                return false;
            }
            return true;
        }
        return false;
    }
}

