/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.mixin;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.kinetics.crusher.CrushingWheelControllerBlock;
import com.simibubi.create.content.kinetics.crusher.CrushingWheelControllerBlockEntity;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import plus.dragons.createenchantmentindustry.config.CEIConfig;

@Mixin(value={CrushingWheelControllerBlockEntity.class})
public class CrushingWheelControllerBlockEntityMixin {
    @Shadow(remap=false)
    public Entity processingEntity;

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;setPos(DDD)V", shift=At.Shift.AFTER)})
    private void injected(CallbackInfo ci) {
        Entity entity;
        if (((Boolean)CEIConfig.kinetics().crushingWheelKillDropXp.get()).booleanValue() && !this.processingEntity.isAlive() && (entity = this.processingEntity) instanceof LivingEntity) {
            int count;
            LivingEntity livingEntity = (LivingEntity)entity;
            Level level = this.processingEntity.level();
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            int reward = Math.max((int)Math.floor((double)livingEntity.getExperienceReward(serverLevel, this.processingEntity) * (Double)CEIConfig.kinetics().crushingWheelKillDropXpScale.get()), 1);
            if ((reward >= 1000 || Math.random() < (Double)CEIConfig.kinetics().crushingWheelKillDropXpChance.get()) && (count = reward / 3 + (Math.random() < (double)((float)(reward % 3) / 3.0f) ? 1 : 0)) != 0) {
                CrushingWheelControllerBlockEntity self = (CrushingWheelControllerBlockEntity)this;
                Vec3 centerPos = VecHelper.getCenterOf((Vec3i)self.getBlockPos());
                Direction facing = (Direction)self.getBlockState().getValue((Property)CrushingWheelControllerBlock.FACING);
                int offset = facing.getAxisDirection().getStep();
                Vec3 outSpeed = new Vec3((facing.getAxis() == Direction.Axis.X ? 0.25 : 0.0) * (double)offset, offset == 1 ? (facing.getAxis() == Direction.Axis.Y ? 0.5 : 0.0) : 0.0, (facing.getAxis() == Direction.Axis.Z ? 0.25 : 0.0) * (double)offset);
                Vec3 outPos = centerPos.add((double)(facing.getAxis() == Direction.Axis.X ? 0.55f * (float)offset : 0.0f), (double)(facing.getAxis() == Direction.Axis.Y ? 0.55f * (float)offset : 0.0f), (double)(facing.getAxis() == Direction.Axis.Z ? 0.55f * (float)offset : 0.0f));
                ItemEntity expItem = new ItemEntity(this.processingEntity.level(), outPos.x(), outPos.y(), outPos.z(), new ItemStack((ItemLike)AllItems.EXP_NUGGET.get(), count));
                expItem.setDeltaMovement(outSpeed);
                expItem.getPersistentData().put("BypassCrushingWheel", NbtUtils.writeBlockPos((BlockPos)self.getBlockPos()));
                this.processingEntity.level().addFreshEntity((Entity)expItem);
            }
        }
    }
}

