/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.registry;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateDataMapProvider;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.data.DataMapProvider;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import net.neoforged.neoforge.registries.datamaps.RegisterDataMapTypesEvent;
import plus.dragons.createdragonsplus.common.registry.CDPFluids;
import plus.dragons.createdragonsplus.util.Pairs;
import plus.dragons.createenchantmentindustry.common.CEICommon;
import plus.dragons.createenchantmentindustry.common.fluids.experience.ExperienceFuel;
import plus.dragons.createenchantmentindustry.common.registry.CEIBlocks;
import plus.dragons.createenchantmentindustry.common.registry.CEIFluids;
import plus.dragons.createenchantmentindustry.common.registry.CEIItems;
import plus.dragons.createenchantmentindustry.util.CEIIntIntPair;

public class CEIDataMaps {
    public static final DataMapType<Item, ExperienceFuel> EXPERIENCE_FUEL = DataMapType.builder((ResourceLocation)CEICommon.asResource("experience_fuel"), (ResourceKey)Registries.ITEM, ExperienceFuel.CODEC).synced(ExperienceFuel.FULL_CODEC, true).build();
    public static final DataMapType<Fluid, Integer> FLUID_UNIT_EXPERIENCE = DataMapType.builder((ResourceLocation)CEICommon.asResource("unit/experience"), (ResourceKey)Registries.FLUID, (Codec)ExtraCodecs.POSITIVE_INT).synced((Codec)Codec.INT, true).build();
    public static final DataMapType<Fluid, Integer> PRINTING_ADDRESS_INGREDIENT = DataMapType.builder((ResourceLocation)CEICommon.asResource("printing/address/ingredient"), (ResourceKey)Registries.FLUID, (Codec)ExtraCodecs.POSITIVE_INT).synced((Codec)Codec.INT, true).build();
    public static final DataMapType<Fluid, Integer> PRINTING_PATTERN_INGREDIENT = DataMapType.builder((ResourceLocation)CEICommon.asResource("printing/pattern/ingredient"), (ResourceKey)Registries.FLUID, (Codec)ExtraCodecs.POSITIVE_INT).synced((Codec)Codec.INT, true).build();
    public static final DataMapType<Fluid, Integer> PRINTING_COPY_INGREDIENT = DataMapType.builder((ResourceLocation)CEICommon.asResource("printing/copy/ingredient"), (ResourceKey)Registries.FLUID, (Codec)ExtraCodecs.POSITIVE_INT).synced((Codec)Codec.INT, true).build();
    public static final DataMapType<Fluid, Integer> PRINTING_CUSTOM_NAME_INGREDIENT = DataMapType.builder((ResourceLocation)CEICommon.asResource("printing/custom_name/ingredient"), (ResourceKey)Registries.FLUID, (Codec)ExtraCodecs.POSITIVE_INT).synced((Codec)Codec.INT, true).build();
    public static final DataMapType<Fluid, Style> PRINTING_CUSTOM_NAME_STYLE = DataMapType.builder((ResourceLocation)CEICommon.asResource("printing/custom_name/style"), (ResourceKey)Registries.FLUID, (Codec)Style.Serializer.CODEC).synced(Style.Serializer.CODEC, true).build();
    public static final DataMapType<Fluid, Integer> PRINTING_WRITTEN_BOOK_INGREDIENT = DataMapType.builder((ResourceLocation)CEICommon.asResource("printing/written_book/ingredient"), (ResourceKey)Registries.FLUID, (Codec)ExtraCodecs.POSITIVE_INT).synced((Codec)Codec.INT, true).build();
    public static final DataMapType<Enchantment, List<CEIIntIntPair>> PRINTING_ENCHANTED_BOOK_COST = DataMapType.builder((ResourceLocation)CEICommon.asResource("printing/enchanted_book/custom_cost"), (ResourceKey)Registries.ENCHANTMENT, (Codec)Codec.list(CEIIntIntPair.CODEC)).synced(Codec.list(CEIIntIntPair.CODEC), true).build();
    public static final DataMapType<Enchantment, Float> FORGING_COST_MULTIPLIER = DataMapType.builder((ResourceLocation)CEICommon.asResource("forging/cost_multiplier"), (ResourceKey)Registries.ENCHANTMENT, (Codec)ExtraCodecs.POSITIVE_FLOAT).synced(ExtraCodecs.POSITIVE_FLOAT, true).build();
    public static final DataMapType<Enchantment, Float> SPLITTING_COST_MULTIPLIER = DataMapType.builder((ResourceLocation)CEICommon.asResource("forging/split_enchantment_cost_multiplier"), (ResourceKey)Registries.ENCHANTMENT, (Codec)ExtraCodecs.POSITIVE_FLOAT).synced(ExtraCodecs.POSITIVE_FLOAT, true).build();
    public static final DataMapType<Enchantment, Integer> SUPER_ENCHANTING_LEVEL_EXTENSION = DataMapType.builder((ResourceLocation)CEICommon.asResource("super_enchanting/custom_level_extension"), (ResourceKey)Registries.ENCHANTMENT, (Codec)ExtraCodecs.NON_NEGATIVE_INT).synced((Codec)Codec.INT, true).build();

    public static void register(IEventBus modBus) {
        modBus.register(CEIDataMaps.class);
        CEICommon.REGISTRATE.addDataGenerator(ProviderType.DATA_MAP, CEIDataMaps::generate);
    }

    @SubscribeEvent
    public static void register(RegisterDataMapTypesEvent event) {
        event.register(EXPERIENCE_FUEL);
        event.register(FLUID_UNIT_EXPERIENCE);
        event.register(PRINTING_ADDRESS_INGREDIENT);
        event.register(PRINTING_PATTERN_INGREDIENT);
        event.register(PRINTING_COPY_INGREDIENT);
        event.register(PRINTING_CUSTOM_NAME_INGREDIENT);
        event.register(PRINTING_CUSTOM_NAME_STYLE);
        event.register(PRINTING_WRITTEN_BOOK_INGREDIENT);
        event.register(PRINTING_ENCHANTED_BOOK_COST);
        event.register(FORGING_COST_MULTIPLIER);
        event.register(SPLITTING_COST_MULTIPLIER);
        event.register(SUPER_ENCHANTING_LEVEL_EXTENSION);
    }

    public static <T> Stream<Pair<Fluid, T>> getSourceFluidEntries(DataMapType<Fluid, T> type) {
        return BuiltInRegistries.FLUID.getDataMap(type).entrySet().stream().map(Pairs.mapKey(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.FLUID).get(arg_0))).filter(Pairs.filterFirst(fluid -> FluidHelper.convertToStill((Fluid)fluid) == fluid));
    }

    public static void generate(RegistrateDataMapProvider provider) {
        provider.builder(EXPERIENCE_FUEL).add(CEIItems.EXPERIENCE_BUCKET, (Object)ExperienceFuel.normal(1000, Items.BUCKET.getDefaultInstance()), false, new ICondition[0]).add(CEIItems.EXPERIENCE_CAKE, (Object)ExperienceFuel.special(1000), false, new ICondition[0]).add(CEIItems.EXPERIENCE_CAKE_SLICE, (Object)ExperienceFuel.special(250), false, new ICondition[0]).add(CEIBlocks.SUPER_EXPERIENCE_BLOCK.getId(), (Object)ExperienceFuel.special(27), false, new ICondition[0]).add(CEIItems.SUPER_EXPERIENCE_NUGGET, (Object)ExperienceFuel.special(3), false, new ICondition[0]).add(AllBlocks.EXPERIENCE_BLOCK.getId(), (Object)ExperienceFuel.normal(27), false, new ICondition[0]).add((Holder)AllItems.EXP_NUGGET, (Object)ExperienceFuel.normal(3), false, new ICondition[0]).add(ResourceLocation.fromNamespaceAndPath((String)"create_sa", (String)"heap_of_experience"), (Object)ExperienceFuel.normal(12), false, new ICondition[]{new ModLoadedCondition("create_sa")}).add(ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)"experience_gem"), (Object)ExperienceFuel.normal(3), false, new ICondition[]{new ModLoadedCondition("ars_nouveau")}).add(ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)"greater_experience_gem"), (Object)ExperienceFuel.normal(12), false, new ICondition[]{new ModLoadedCondition("ars_nouveau")}).add(ResourceLocation.fromNamespaceAndPath((String)"mysticalagriculture", (String)"experience_droplet"), (Object)ExperienceFuel.normal(10), false, new ICondition[]{new ModLoadedCondition("mysticalagriculture")});
        provider.builder(FLUID_UNIT_EXPERIENCE).add(ResourceLocation.fromNamespaceAndPath((String)"cofh_core", (String)"experience"), (Object)25, false, new ICondition[]{new ModLoadedCondition("cofh_core")}).add(ResourceLocation.fromNamespaceAndPath((String)"cyclic", (String)"xpjuice"), (Object)20, false, new ICondition[]{new ModLoadedCondition("cyclic")}).add(ResourceLocation.fromNamespaceAndPath((String)"enderio", (String)"xpjuice"), (Object)20, false, new ICondition[]{new ModLoadedCondition("enderio")}).add(ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"essence"), (Object)20, false, new ICondition[]{new ModLoadedCondition("industrialforegoing")}).add(ResourceLocation.fromNamespaceAndPath((String)"mob_grinding_utils", (String)"fluid_xp"), (Object)20, false, new ICondition[]{new ModLoadedCondition("mob_grinding_utils")}).add(ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"essence"), (Object)20, false, new ICondition[]{new ModLoadedCondition("industrialforegoing")}).add(ResourceLocation.fromNamespaceAndPath((String)"pneumaticcraft", (String)"memory_essence"), (Object)20, false, new ICondition[]{new ModLoadedCondition("pneumaticcraft")}).add(ResourceLocation.fromNamespaceAndPath((String)"reliquary", (String)"xp_juice_still"), (Object)20, false, new ICondition[]{new ModLoadedCondition("reliquary")}).add(ResourceLocation.fromNamespaceAndPath((String)"sophisticatedcore", (String)"xp_still"), (Object)20, false, new ICondition[]{new ModLoadedCondition("sophisticatedcore")});
        TagKey blackDye = (TagKey)CDPFluids.COMMON_TAGS.dyesByColor.get(DyeColor.BLACK);
        provider.builder(PRINTING_ADDRESS_INGREDIENT).add(blackDye, (Object)10, false, new ICondition[0]);
        provider.builder(PRINTING_PATTERN_INGREDIENT).add(blackDye, (Object)100, false, new ICondition[0]);
        provider.builder(PRINTING_COPY_INGREDIENT).add(blackDye, (Object)10, false, new ICondition[0]);
        provider.builder(PRINTING_CUSTOM_NAME_INGREDIENT).add(CEIFluids.EXPERIENCE, (Object)10, false, new ICondition[0]).add(CDPFluids.COMMON_TAGS.dyes, (Object)250, false, new ICondition[0]);
        provider.builder(PRINTING_WRITTEN_BOOK_INGREDIENT).add(blackDye, (Object)10, false, new ICondition[0]);
        DataMapProvider.Builder customNameStyles = provider.builder(PRINTING_CUSTOM_NAME_STYLE);
        CDPFluids.COMMON_TAGS.dyesByColor.forEach((color, tag) -> customNameStyles.add(tag, (Object)Style.EMPTY.withColor(color.getTextColor()), false, new ICondition[0]));
        provider.builder(PRINTING_ENCHANTED_BOOK_COST);
        provider.builder(FORGING_COST_MULTIPLIER);
        provider.builder(SPLITTING_COST_MULTIPLIER);
        provider.builder(SUPER_ENCHANTING_LEVEL_EXTENSION).add(Enchantments.MENDING, (Object)0, false, new ICondition[0]).add(Enchantments.INFINITY, (Object)0, false, new ICondition[0]);
    }
}

