/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.registry;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.logistics.box.PackageStyles;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import plus.dragons.createdragonsplus.common.advancements.CDPAdvancement;
import plus.dragons.createdragonsplus.common.advancements.criterion.BuiltinTrigger;
import plus.dragons.createdragonsplus.common.registry.CDPItems;
import plus.dragons.createdragonsplus.util.CodeReference;
import plus.dragons.createenchantmentindustry.common.registry.CEIBlocks;
import plus.dragons.createenchantmentindustry.common.registry.CEIItems;
import plus.dragons.createenchantmentindustry.common.registry.CEIStats;
import plus.dragons.createenchantmentindustry.util.CEIAdvancement;

public class CEIAdvancements
implements DataProvider {
    public static final List<CDPAdvancement> ENTRIES = new ArrayList<CDPAdvancement>();
    public static final CDPAdvancement START = null;
    public static final CDPAdvancement ROOT = CEIAdvancements.create("root", b -> b.icon(CEIItems.EXPERIENCE_BUCKET).title("Welcome to Create: Enchantment Industry").description("Road to master enchanting begins").awardedForFree().special(CDPAdvancement.TaskType.SILENT));
    public static final CDPAdvancement EXPERIENCED_ENGINEER = CEIAdvancements.create("experienced_engineer", b -> b.icon((ItemProviderEntry)AllItems.EXP_NUGGET).title("Experienced Engineer").description("Obtain some Nuggets of Experience").whenIconCollected().after(ROOT));
    public static final CDPAdvancement SPIRIT_TAKING = CEIAdvancements.create("spirit_taking", b -> b.icon((ItemProviderEntry)AllItems.EXP_NUGGET).title("Spirit-Taking").description("Store your experience using an Experience Hatch").after(EXPERIENCED_ENGINEER));
    public static final CDPAdvancement SPIRITUAL_RETURN = CEIAdvancements.create("spiritual_return", b -> b.icon((ItemProviderEntry)AllItems.EXP_NUGGET).title("Spiritual Return").description("Retrieve some experience using an Experience Hatch").after(SPIRIT_TAKING));
    public static final CDPAdvancement A_SHOWER_EXPERIENCE = CEIAdvancements.create("a_shower_experience", b -> b.icon((ItemProviderEntry)AllItems.EXP_NUGGET).title("A Shower \"Experience\"").description("Break a Fluid Pipe and bathe in the leaked experience").special(CDPAdvancement.TaskType.SECRET).after(SPIRITUAL_RETURN));
    public static final CDPAdvancement LUMEN_NEXUS = CEIAdvancements.create("lumen_nexus", b -> b.icon(CEIBlocks.EXPERIENCE_LANTERN).title("Lumen Nexus").whenIconCollected().description("Obtain an Experience Lantern").after(SPIRITUAL_RETURN));
    public static final CDPAdvancement GONE_WITH_THE_FOIL = CEIAdvancements.create("gone_with_the_foil", b -> b.icon(CEIBlocks.MECHANICAL_GRINDSTONE).title("Gone with the Foil").description("Watch an enchanted item be disenchanted by a Mechanical Grindstone").after(EXPERIENCED_ENGINEER));
    public static final CDPAdvancement GRIND_TO_POLISH = CEIAdvancements.create("grind_to_polish", b -> b.icon((ItemProviderEntry)AllItems.SAND_PAPER).title("Grind to Polish").description("Sandpaper? I've got a better one").special(CDPAdvancement.TaskType.NOISY).after(GONE_WITH_THE_FOIL));
    public static final CDPAdvancement EXPERIENCED_RECYCLER = CEIAdvancements.create("experienced_recycler", b -> b.icon(CEIBlocks.GRINDSTONE_DRAIN).title("Experienced Recycler").description("Obtain 1,000,000 mB of Liquid Experience from Mechanical Grindstones").special(CDPAdvancement.TaskType.EXPERT).whenStatReach(Stats.CUSTOM.get((Object)((ResourceLocation)CEIStats.GRINDSTONE_EXPERIENCE.get())), MinMaxBounds.Ints.atLeast((int)1000000)).after(GONE_WITH_THE_FOIL));
    public static final CDPAdvancement BLAZE_ENCHANTERY = CEIAdvancements.create("blaze_enchantery", b -> b.icon(CEIBlocks.BLAZE_ENCHANTER).title("Blaze Enchantry").description("Blazes can do more than boil water. Obtain a Blaze Enchanter").whenIconCollected().after(EXPERIENCED_ENGINEER));
    public static final CDPAdvancement BLAZING_ENCHANTMENT = CEIAdvancements.create("blazing_enchantment", b -> b.icon((ItemLike)Items.GOLDEN_HELMET).title("Blazing Enchantment").description("Enchant an unenchanted item using a Blaze Enchanter").after(BLAZE_ENCHANTERY));
    public static final CDPAdvancement SIGIL_FORGING = CEIAdvancements.create("sigil_forging", b -> b.icon(CEIItems.ENCHANTING_TEMPLATE).title("Sigil Forging").description("Add a new enchantment to an Enchanting Template using a Blaze Enchanter").after(BLAZING_ENCHANTMENT));
    public static final CDPAdvancement THOUSAND_RUNES = CEIAdvancements.create("thousand_runes", b -> b.icon(CEIBlocks.BLAZE_ENCHANTER).title("Thousand Runes").description("Use a Blaze Enchanter 1,000 times").whenStatReach(Stats.CUSTOM.get((Object)((ResourceLocation)CEIStats.ENCHANT.get())), MinMaxBounds.Ints.atLeast((int)1000)).special(CDPAdvancement.TaskType.EXPERT).after(SIGIL_FORGING));
    public static final CDPAdvancement BORN_TALENT_OF_FIRE = CEIAdvancements.create("born_talent_of_fire", b -> b.icon(CEIBlocks.BLAZE_FORGER).title("Born Talent of Fire").description("Blazes were born for this. Obtain a Blaze Forger").whenIconCollected().after(EXPERIENCED_ENGINEER));
    public static final CDPAdvancement BLAZING_FUSION = CEIAdvancements.create("blazing_fusion", b -> b.icon((ItemLike)Items.GOLDEN_SWORD).title("Blazing Fusion").description("Merge two of the same item using a Blaze Forger").after(BORN_TALENT_OF_FIRE));
    public static final CDPAdvancement SIGIL_CASTING = CEIAdvancements.create("sigil_casting", b -> b.icon(CEIItems.ENCHANTING_TEMPLATE).title("Sigil Casting").description("Apply an Enchanting Template using a Blaze Forger").after(BLAZING_FUSION));
    public static final CDPAdvancement MAGIC_UNBINDING = CEIAdvancements.create("magic_unbinding", b -> b.icon(CEIItems.ENCHANTING_TEMPLATE).title("Magic Unbinding").description("Strip an item's enchantment off using a Blaze Forger").after(SIGIL_CASTING));
    public static final CDPAdvancement BLAZING_CENTURION = CEIAdvancements.create("blazing_centurion", b -> b.icon(CEIBlocks.BLAZE_FORGER).title("Blazing Centurion").description("Use a Blaze Forger 1,000 times").whenStatReach(Stats.CUSTOM.get((Object)((ResourceLocation)CEIStats.FORGE.get())), MinMaxBounds.Ints.atLeast((int)1000)).special(CDPAdvancement.TaskType.EXPERT).after(MAGIC_UNBINDING));
    public static final CDPAdvancement LIGHTNING_CATALYSIS = CEIAdvancements.create("lightning_catalysis", b -> b.icon(CEIBlocks.BLAZE_FORGER).title("Lightning Catalysis").description("Obtain Super Experience").whenItemCollected(CEIBlocks.SUPER_EXPERIENCE_BLOCK).special(CDPAdvancement.TaskType.EXPERT).after(EXPERIENCED_ENGINEER));
    public static final CDPAdvancement PROBABILITY_SPIKE = CEIAdvancements.create("probability_spike", b -> b.icon((ItemLike)Items.DIAMOND).title("Probability Spike").description("How did all these treasures get here?").special(CDPAdvancement.TaskType.EXPERT).after(LIGHTNING_CATALYSIS));
    public static final CDPAdvancement TRANSCENDENT_OVERCLOCK = CEIAdvancements.create("transcendent_overclock", b -> b.icon((ItemLike)Items.EMERALD).title("Transcendent Overclock").description("How is this possible? Enchantment level caps don't exist?").special(CDPAdvancement.TaskType.EXPERT).after(PROBABILITY_SPIKE));
    public static final CDPAdvancement PARADOX_FUSION = CEIAdvancements.create("paradox_fusion", b -> b.icon((ItemLike)Items.REDSTONE).title("Paradox Fusion").description("How is this possible? They shouldn't appear at the same time!").special(CDPAdvancement.TaskType.EXPERT).after(TRANSCENDENT_OVERCLOCK));
    public static final CDPAdvancement OSHA_VIOLATION = CEIAdvancements.create("osha_violation", b -> b.icon((ItemLike)Items.BARRIER).title("OSHA Violation").description("You should NOT have let this happen!!!").special(CDPAdvancement.TaskType.SECRET).after(LIGHTNING_CATALYSIS));
    public static final CDPAdvancement OMNI_ENCHANTER = CEIAdvancements.create("omni_enchanter", b -> b.icon((ItemLike)Items.NETHER_STAR).title("Omni-Enchanter").description("Unbelievable! You've Super Enchanted 1,000 times! Now the number speaks for itself").whenStatReach(Stats.CUSTOM.get((Object)((ResourceLocation)CEIStats.SUPER_ENCHANT.get())), MinMaxBounds.Ints.atLeast((int)100)).special(CDPAdvancement.TaskType.EXPERT).after(PARADOX_FUSION));
    public static final CDPAdvancement COPIABLE_MASTERPIECE = CEIAdvancements.create("copiable_masterpiece", b -> b.icon((ItemLike)Items.WRITTEN_BOOK).title("Copiable Masterpiece").description("Copy a Written Book using a Printer").after(EXPERIENCED_ENGINEER));
    public static final CDPAdvancement COPIABLE_MYSTERY = CEIAdvancements.create("copiable_mystery", b -> b.icon((ItemLike)Items.ENCHANTED_BOOK).title("Copiable Mystery").description("Copy an Enchanted Book using a Printer").after(COPIABLE_MASTERPIECE));
    public static final CDPAdvancement BRAND_REGISTRY = CEIAdvancements.create("brand_registry", b -> b.icon((ItemLike)Items.NAME_TAG).title("Brand Registry").description("Use a Printer to rename an item").after(COPIABLE_MYSTERY));
    public static final CDPAdvancement SUPPLY_CHAIN_REFACTOR = CEIAdvancements.create("supply_chain_refactor", b -> b.icon(PackageStyles.getDefaultBox()).title("Supply Chain Refactor").description("Use a Printer to change a package's address").after(BRAND_REGISTRY));
    public static final CDPAdvancement ASSEMBLY_AESTHETICS = CEIAdvancements.create("assembly_aesthetics", b -> b.icon((ItemProviderEntry)CDPItems.RARE_MARBLE_GATE_PACKAGE).title("Assembly Aesthetics").description("Use a Printer to change a package's pattern").after(SUPPLY_CHAIN_REFACTOR));
    public static final CDPAdvancement GREAT_PUBLISHER = CEIAdvancements.create("great_publisher", b -> b.icon(CEIBlocks.PRINTER).title("Great Publisher").description("Use a Printer 1,000 times").whenStatReach(Stats.CUSTOM.get((Object)((ResourceLocation)CEIStats.PRINT.get())), MinMaxBounds.Ints.atLeast((int)1000)).special(CDPAdvancement.TaskType.EXPERT).after(BRAND_REGISTRY));
    private final PackOutput output;
    private final CompletableFuture<HolderLookup.Provider> registries;

    private static CDPAdvancement create(String id, UnaryOperator<CDPAdvancement.Builder> b) {
        return new CEIAdvancement(id, b);
    }

    public CEIAdvancements(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        this.output = output;
        this.registries = registries;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        return this.registries.thenCompose(provider -> {
            PackOutput.PathProvider pathProvider = this.output.createPathProvider(PackOutput.Target.DATA_PACK, "advancement");
            ArrayList futures = new ArrayList();
            HashSet set = Sets.newHashSet();
            Consumer<AdvancementHolder> consumer = advancement -> {
                ResourceLocation id = advancement.id();
                if (!set.add(id)) {
                    throw new IllegalStateException("Duplicate advancement " + String.valueOf(id));
                }
                Path path = pathProvider.json(id);
                LOGGER.info("Saving advancement {}", (Object)id);
                futures.add(DataProvider.saveStable((CachedOutput)cache, (HolderLookup.Provider)provider, (Codec)Advancement.CODEC, (Object)advancement.value(), (Path)path));
            };
            for (CDPAdvancement advancement2 : ENTRIES) {
                advancement2.save(consumer, provider);
            }
            return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
        });
    }

    public static void provideLang(BiConsumer<String, String> consumer) {
        for (CDPAdvancement advancement : ENTRIES) {
            advancement.provideLang(consumer);
        }
    }

    public static void register() {
    }

    public String getName() {
        return "Create: Enchantment Industry Advancements";
    }

    @CodeReference(value={AllTriggers.class}, source={"create"}, license={"mit"})
    public static class BuiltinTriggersQuickDeploy {
        private static final Map<ResourceLocation, BuiltinTrigger> triggers = new IdentityHashMap<ResourceLocation, BuiltinTrigger>();

        public static BuiltinTrigger add(ResourceLocation id) {
            BuiltinTrigger instance = new BuiltinTrigger();
            triggers.put(id, instance);
            return instance;
        }

        public static void register() {
            triggers.entrySet().forEach(set -> Registry.register((Registry)BuiltInRegistries.TRIGGER_TYPES, (ResourceLocation)((ResourceLocation)set.getKey()), (Object)((BuiltinTrigger)set.getValue())));
        }
    }
}

