/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.fluids.printer.behaviour;

import com.mojang.serialization.DataResult;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import plus.dragons.createenchantmentindustry.common.CEICommon;
import plus.dragons.createenchantmentindustry.common.fluids.printer.PrinterBlockEntity;
import plus.dragons.createenchantmentindustry.common.fluids.printer.behaviour.PrintingBehaviour;
import plus.dragons.createenchantmentindustry.common.registry.CEIDataMaps;
import plus.dragons.createenchantmentindustry.config.CEIConfig;
import plus.dragons.createenchantmentindustry.util.CEILang;

public class WrittenBookPrintingBehaviour
implements PrintingBehaviour {
    private final SmartFluidTankBehaviour tank;
    private final WrittenBookContent content;

    private WrittenBookPrintingBehaviour(SmartFluidTankBehaviour tank, WrittenBookContent content) {
        this.tank = tank;
        this.content = content;
    }

    public static Optional<DataResult<PrintingBehaviour>> create(Level level, SmartFluidTankBehaviour tank, ItemStack stack) {
        int change;
        if (!stack.is(Items.WRITTEN_BOOK)) {
            return Optional.empty();
        }
        WrittenBookContent content = (WrittenBookContent)stack.get(DataComponents.WRITTEN_BOOK_CONTENT);
        if (content == null || content.pages().isEmpty()) {
            return Optional.of(DataResult.error(() -> CEICommon.asLocalization("gui.printer.written_book.invalid")));
        }
        int generation = content.generation();
        int newGeneration = Math.max(0, generation + (change = ((Integer)CEIConfig.fluids().printingGenerationChange.get()).intValue()));
        if (newGeneration > 2) {
            return Optional.of(DataResult.error(() -> CEICommon.asLocalization("gui.printer.written_book.invalid")));
        }
        content = new WrittenBookContent(content.title(), content.author(), newGeneration, content.pages(), content.resolved());
        return Optional.of(DataResult.success((Object)new WrittenBookPrintingBehaviour(tank, content)));
    }

    private OptionalInt getCost(FluidStack fluid) {
        int cost = this.content.pages().size();
        if ((cost *= Objects.requireNonNullElse((Integer)fluid.getFluidHolder().getData(CEIDataMaps.PRINTING_WRITTEN_BOOK_INGREDIENT), 0).intValue()) == 0) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(cost);
    }

    @Override
    public boolean isValid() {
        FluidStack fluid = this.tank.getPrimaryHandler().getFluid();
        if (fluid.isEmpty()) {
            return true;
        }
        OptionalInt cost = this.getCost(fluid);
        return cost.isPresent() && cost.getAsInt() <= (Integer)CEIConfig.fluids().printerFluidCapacity.get();
    }

    @Override
    public boolean isSafeNBT() {
        return false;
    }

    @Override
    public int getRequiredItemCount(Level level, ItemStack stack) {
        if (stack.is(Items.BOOK)) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getRequiredFluidAmount(Level level, ItemStack stack, FluidStack fluidStack) {
        return this.getCost(fluidStack).orElse(0);
    }

    @Override
    public ItemStack getResult(Level level, ItemStack stack, FluidStack fluidStack) {
        ItemStack result = stack.transmuteCopy((ItemLike)Items.WRITTEN_BOOK, 1);
        result.set(DataComponents.WRITTEN_BOOK_CONTENT, (Object)this.content);
        return result;
    }

    @Override
    public void onFinished(Level level, BlockPos pos, PrinterBlockEntity printer) {
        level.levelEvent(1043, pos.below(), 0);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CEILang.translate("gui.goggles.printing", new Object[0]).forGoggles(tooltip);
        CEILang.builder().add(Component.literal((String)((String)this.content.title().raw()))).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
        CEILang.builder().add(Component.translatable((String)"book.byAuthor", (Object[])new Object[]{this.content.author()})).style(ChatFormatting.GRAY).forGoggles(tooltip);
        this.getCost(this.tank.getPrimaryHandler().getFluid()).ifPresent(cost -> CEILang.translate("gui.goggles.printing.cost", CEILang.number(cost).add(CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0])).style(cost <= (Integer)CEIConfig.fluids().printerFluidCapacity.get() ? ChatFormatting.GREEN : ChatFormatting.RED)).forGoggles(tooltip, 1));
        return true;
    }
}

