/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.fluids.printer.behaviour;

import com.mojang.serialization.DataResult;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.recipe.ItemCopyingRecipe;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import plus.dragons.createenchantmentindustry.common.CEICommon;
import plus.dragons.createenchantmentindustry.common.fluids.printer.PrinterBlockEntity;
import plus.dragons.createenchantmentindustry.common.fluids.printer.behaviour.PrintingBehaviour;
import plus.dragons.createenchantmentindustry.common.registry.CEIDataMaps;
import plus.dragons.createenchantmentindustry.config.CEIConfig;
import plus.dragons.createenchantmentindustry.util.CEILang;

public class CopyPrintingBehaviour
implements PrintingBehaviour {
    private final ItemCopyingRecipe.SupportsItemCopying itemCopying;
    private final ItemStack original;
    private final SmartFluidTankBehaviour tank;

    public CopyPrintingBehaviour(ItemCopyingRecipe.SupportsItemCopying itemCopying, ItemStack original, SmartFluidTankBehaviour tank) {
        this.itemCopying = itemCopying;
        this.original = original;
        this.tank = tank;
    }

    public static Optional<DataResult<PrintingBehaviour>> create(Level level, SmartFluidTankBehaviour tank, ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof ItemCopyingRecipe.SupportsItemCopying) {
            ItemCopyingRecipe.SupportsItemCopying copiable = (ItemCopyingRecipe.SupportsItemCopying)item;
            return Optional.of(copiable.canCopyFromItem(stack) ? DataResult.success((Object)new CopyPrintingBehaviour(copiable, stack, tank)) : DataResult.error(() -> CEICommon.asLocalization("gui.printer.copy.invalid")));
        }
        return Optional.empty();
    }

    @Override
    public int getRequiredItemCount(Level level, ItemStack stack) {
        if (ItemStack.isSameItem((ItemStack)this.original, (ItemStack)stack) && this.itemCopying.canCopyToItem(stack)) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getRequiredFluidAmount(Level level, ItemStack stack, FluidStack fluidStack) {
        Integer amount = (Integer)fluidStack.getFluidHolder().getData(CEIDataMaps.PRINTING_COPY_INGREDIENT);
        return amount == null ? 0 : amount;
    }

    @Override
    public ItemStack getResult(Level level, ItemStack stack, FluidStack fluidStack) {
        return this.itemCopying.createCopy(this.original, 1);
    }

    @Override
    public void onFinished(Level level, BlockPos pos, PrinterBlockEntity printer) {
        level.levelEvent(1043, pos.below(), 0);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CEILang.translate("gui.goggles.printing.copy", new Object[0]).forGoggles(tooltip);
        CEILang.item(this.original).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
        Integer amount = (Integer)this.tank.getPrimaryHandler().getFluid().getFluidHolder().getData(CEIDataMaps.PRINTING_COPY_INGREDIENT);
        if (amount != null) {
            CEILang.translate("gui.goggles.printing.cost", CEILang.number(amount.intValue()).add(CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0])).style(amount <= (Integer)CEIConfig.fluids().printerFluidCapacity.get() ? ChatFormatting.GREEN : ChatFormatting.RED)).forGoggles(tooltip, 1);
        } else if (!this.tank.getPrimaryHandler().getFluid().isEmpty()) {
            CEILang.translate("gui.goggles.printing.incorrect_liquid", new Object[0]).style(ChatFormatting.RED).forGoggles(tooltip);
        }
        return true;
    }
}

