/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.fluids.printer;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.compat.jei.category.sequencedAssembly.SequencedAssemblySubCategory;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeParams;
import com.simibubi.create.content.processing.sequenced.IAssemblyRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.effects.PlaySoundEffect;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import plus.dragons.createenchantmentindustry.common.fluids.printer.PrintingInput;
import plus.dragons.createenchantmentindustry.common.fluids.printer.PrintingRecipeParams;
import plus.dragons.createenchantmentindustry.common.registry.CEIBlocks;
import plus.dragons.createenchantmentindustry.common.registry.CEIRecipes;
import plus.dragons.createenchantmentindustry.integration.jei.category.assembly.AssemblyPrintingCategory;
import plus.dragons.createenchantmentindustry.util.CEILang;

public class PrintingRecipe
extends ProcessingRecipe<PrintingInput, PrintingRecipeParams>
implements IAssemblyRecipe {
    public PrintingRecipe(PrintingRecipeParams params) {
        super(CEIRecipes.PRINTING, (ProcessingRecipeParams)params);
    }

    public static Builder builder(ResourceLocation id, PlaySoundEffect sound) {
        return new Builder(id, sound);
    }

    public static Builder builder(ResourceLocation id) {
        return new Builder(id, new PlaySoundEffect(BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)SoundEvents.ENCHANTMENT_TABLE_USE), (FloatProvider)ConstantFloat.of((float)1.0f), (FloatProvider)UniformFloat.of((float)0.9f, (float)1.0f)));
    }

    public void playSound(Level level, BlockPos pos, SoundSource source) {
        PlaySoundEffect sound = ((PrintingRecipeParams)this.params).sound;
        level.playSound(null, pos, (SoundEvent)sound.soundEvent().value(), source, sound.volume().sample(level.random), sound.pitch().sample(level.random));
    }

    protected int getMaxInputCount() {
        return 2;
    }

    protected int getMaxFluidInputCount() {
        return 1;
    }

    protected int getMaxOutputCount() {
        return 1;
    }

    public boolean matches(PrintingInput input, Level level) {
        return ((Ingredient)this.ingredients.get(0)).test(input.base()) && ((Ingredient)this.ingredients.get(1)).test(input.template()) && (input.fluid().isEmpty() || ((FluidIngredient)this.fluidIngredients.get(0)).test(input.fluid()));
    }

    public Component getDescriptionForAssembly() {
        ItemStack[] matchingStacks = ((Ingredient)this.ingredients.get(1)).getItems();
        List matchingFluidStacks = ((FluidIngredient)this.fluidIngredients.getFirst()).getMatchingFluidStacks();
        if (matchingStacks.length == 0 || matchingFluidStacks.isEmpty()) {
            return Component.literal((String)"Invalid");
        }
        return CEILang.translate("recipe.assembly.printing", matchingStacks[0].getHoverName(), ((FluidStack)matchingFluidStacks.getFirst()).getHoverName()).component();
    }

    public void addRequiredMachines(Set<ItemLike> required) {
        required.add((ItemLike)CEIBlocks.PRINTER);
    }

    public void addAssemblyIngredients(List<Ingredient> list) {
        list.add((Ingredient)this.getIngredients().get(1));
    }

    public void addAssemblyFluidIngredients(List<FluidIngredient> list) {
        list.add((FluidIngredient)this.getFluidIngredients().getFirst());
    }

    public Supplier<Supplier<SequencedAssemblySubCategory>> getJEISubCategory() {
        return () -> AssemblyPrintingCategory::new;
    }

    public static class Builder
    extends ProcessingRecipeBuilder<PrintingRecipeParams, PrintingRecipe, Builder> {
        protected Builder(ResourceLocation id, PlaySoundEffect sound) {
            super(PrintingRecipe::new, id);
            PrintingRecipeParams params = (PrintingRecipeParams)this.params;
            params.sound = sound;
        }

        protected PrintingRecipeParams createParams() {
            return new PrintingRecipeParams();
        }

        public Builder self() {
            return this;
        }
    }

    public static class Serializer<R extends PrintingRecipe>
    implements RecipeSerializer<R> {
        private final MapCodec<R> codec;
        private final StreamCodec<RegistryFriendlyByteBuf, R> streamCodec;

        public Serializer(ProcessingRecipe.Factory<PrintingRecipeParams, R> factory) {
            this.codec = ProcessingRecipe.codec(factory, PrintingRecipeParams.CODEC);
            this.streamCodec = ProcessingRecipe.streamCodec(factory, PrintingRecipeParams.STREAM_CODEC);
        }

        public MapCodec<R> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, R> streamCodec() {
            return this.streamCodec;
        }
    }
}

