/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.fluids.printer;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createdragonsplus.common.advancements.AdvancementBehaviour;
import plus.dragons.createdragonsplus.util.FieldsNullabilityUnknownByDefault;
import plus.dragons.createenchantmentindustry.common.fluids.printer.PrinterBehaviour;
import plus.dragons.createenchantmentindustry.common.fluids.printer.PrinterBlock;
import plus.dragons.createenchantmentindustry.common.fluids.printer.behaviour.AddressPrintingBehaviour;
import plus.dragons.createenchantmentindustry.common.fluids.printer.behaviour.CustomNamePrintingBehaviour;
import plus.dragons.createenchantmentindustry.common.fluids.printer.behaviour.PackagePatternPrintingBehaviour;
import plus.dragons.createenchantmentindustry.common.fluids.printer.behaviour.PrintingBehaviour;
import plus.dragons.createenchantmentindustry.common.registry.CEIAdvancements;
import plus.dragons.createenchantmentindustry.common.registry.CEIStats;
import plus.dragons.createenchantmentindustry.config.CEIConfig;

@FieldsNullabilityUnknownByDefault
public class PrinterBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public static final int PROCESSING_TIME = 50;
    protected SmartFluidTankBehaviour tank;
    private PrinterBehaviour printer;
    public int processingTicks = -1;
    private AdvancementBehaviour advancement;

    public PrinterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)((Integer)CEIConfig.fluids().printerFluidCapacity.get()));
        this.printer = new PrinterBehaviour(this, this.tank, (ValueBoxTransform)new CenteredSideValueBoxTransform((state, direction) -> state.getValue((Property)PrinterBlock.FACING) == direction));
        BeltProcessingBehaviour processing = new BeltProcessingBehaviour((SmartBlockEntity)this).whenItemEnters(this::onItemEnters).whileItemHeld(this::onItemHeld);
        this.advancement = new AdvancementBehaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.tank);
        behaviours.add((BlockEntityBehaviour)this.printer);
        behaviours.add((BlockEntityBehaviour)processing);
        behaviours.add((BlockEntityBehaviour)this.advancement);
    }

    @Nullable
    public IFluidHandler getFluidHandler(@Nullable Direction side) {
        if (side != Direction.DOWN) {
            return this.tank.getCapability();
        }
        return null;
    }

    private FluidStack getFluidInTank() {
        return this.tank.getPrimaryHandler().getFluid();
    }

    private void setFluidInTank(FluidStack fluidStack) {
        this.tank.getPrimaryHandler().setFluid(fluidStack);
    }

    public BeltProcessingBehaviour.ProcessingResult onItemEnters(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        Level level = this.level;
        assert (level != null);
        if (handler.blockEntity.isVirtual()) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        PrintingBehaviour printing = this.printer.getPrintingBehaviour();
        if (!printing.isValid()) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (printing.getRequiredItemCount(level, transported.stack) == 0) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        FluidStack fluidStack = this.getFluidInTank();
        if (fluidStack.isEmpty()) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (printing.getRequiredFluidAmount(level, transported.stack, fluidStack) == 0) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    public BeltProcessingBehaviour.ProcessingResult onItemHeld(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        Level level = this.level;
        assert (level != null);
        if (this.processingTicks != -1 && this.processingTicks != 5) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        PrintingBehaviour printing = this.printer.getPrintingBehaviour();
        if (!printing.isValid()) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        int requiredItem = printing.getRequiredItemCount(level, transported.stack);
        if (requiredItem == 0) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        FluidStack fluidStack = this.getFluidInTank();
        int requiredFluid = printing.getRequiredFluidAmount(level, transported.stack, fluidStack);
        if (requiredFluid == 0) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (fluidStack.getAmount() < requiredFluid) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (this.processingTicks == -1) {
            this.processingTicks = 50;
            this.notifyUpdate();
            AllSoundEvents.SPOUTING.playOnServer(level, (Vec3i)this.worldPosition, 0.75f, 0.9f + 0.2f * level.random.nextFloat());
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        ItemStack resultItem = printing.getResult(level, transported.stack.split(requiredItem), fluidStack);
        if (!resultItem.isEmpty()) {
            transported.clearFanProcessingData();
            TransportedItemStack held = null;
            TransportedItemStack result = transported.copy();
            result.stack = resultItem;
            if (!transported.stack.isEmpty()) {
                held = transported.copy();
            }
            ArrayList<TransportedItemStack> resultList = new ArrayList<TransportedItemStack>();
            resultList.add(result);
            handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertToAndLeaveHeld(resultList, (TransportedItemStack)held));
            if (this.printer.getPrintingBehaviour() instanceof CustomNamePrintingBehaviour) {
                this.advancement.trigger(CEIAdvancements.BRAND_REGISTRY.builtinTrigger());
            } else if (resultItem.is(Items.WRITTEN_BOOK)) {
                this.advancement.trigger(CEIAdvancements.COPIABLE_MASTERPIECE.builtinTrigger());
            } else if (resultItem.is(Items.ENCHANTED_BOOK)) {
                this.advancement.trigger(CEIAdvancements.COPIABLE_MYSTERY.builtinTrigger());
            } else if (this.printer.getPrintingBehaviour() instanceof PackagePatternPrintingBehaviour) {
                this.advancement.trigger(CEIAdvancements.ASSEMBLY_AESTHETICS.builtinTrigger());
            } else if (this.printer.getPrintingBehaviour() instanceof AddressPrintingBehaviour) {
                this.advancement.trigger(CEIAdvancements.SUPPLY_CHAIN_REFACTOR.builtinTrigger());
            }
        }
        fluidStack.shrink(requiredFluid);
        this.setFluidInTank(fluidStack);
        this.notifyUpdate();
        printing.onFinished(level, this.worldPosition, this);
        this.advancement.awardStat((ResourceLocation)CEIStats.PRINT.get(), 1);
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        tag.putInt("ProcessingTicks", this.processingTicks);
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.processingTicks = tag.getInt("ProcessingTicks");
    }

    public void tick() {
        super.tick();
        if (this.processingTicks >= 0) {
            --this.processingTicks;
        }
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().expandTowards(0.0, -2.0, 0.0);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        assert (this.level != null);
        boolean added = this.containedFluidTooltip(tooltip, isPlayerSneaking, (IFluidHandler)this.tank.getPrimaryHandler());
        return added |= this.printer.getPrintingBehaviour().addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    protected static class PrinterFilterSlot
    extends ValueBoxTransform.Sided {
        protected PrinterFilterSlot() {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)16.0);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            return state.getValue((Property)PrinterBlock.FACING) == direction;
        }
    }
}

