/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.loading.json.typeadapter;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.doubles.DoubleObjectPair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.util.GsonHelper;
import org.apache.commons.lang3.math.NumberUtils;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.EasingType;
import software.bernie.geckolib.animation.keyframe.BoneAnimation;
import software.bernie.geckolib.animation.keyframe.Keyframe;
import software.bernie.geckolib.animation.keyframe.KeyframeStack;
import software.bernie.geckolib.loading.math.MathParser;
import software.bernie.geckolib.loading.math.MathValue;
import software.bernie.geckolib.loading.math.value.Constant;
import software.bernie.geckolib.loading.object.BakedAnimations;
import software.bernie.geckolib.util.CompoundException;
import software.bernie.geckolib.util.JsonUtil;

public class BakedAnimationsAdapter
implements JsonDeserializer<BakedAnimations> {
    public static ConcurrentMap<Double, Constant> COMPRESSION_CACHE = null;

    public BakedAnimations deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws RuntimeException {
        JsonObject obj = json.getAsJsonObject();
        Object2ObjectOpenHashMap animations = new Object2ObjectOpenHashMap(obj.size());
        for (Map.Entry entry : obj.entrySet()) {
            try {
                animations.put((String)entry.getKey(), this.bakeAnimation((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonObject(), context));
            }
            catch (Exception ex) {
                if (ex instanceof CompoundException) {
                    CompoundException compoundEx = (CompoundException)ex;
                    GeckoLibConstants.LOGGER.error(compoundEx.withMessage("Unable to parse animation: " + (String)entry.getKey()).getLocalizedMessage());
                } else {
                    GeckoLibConstants.LOGGER.error("Unable to parse animation: " + (String)entry.getKey());
                }
                ex.printStackTrace();
            }
        }
        return new BakedAnimations((Map<String, Animation>)animations);
    }

    private Animation bakeAnimation(String name, JsonObject animationObj, JsonDeserializationContext context) throws CompoundException {
        double length = animationObj.has("animation_length") ? GsonHelper.getAsDouble((JsonObject)animationObj, (String)"animation_length") * 20.0 : -1.0;
        Animation.LoopType loopType = Animation.LoopType.fromJson(animationObj.get("loop"));
        BoneAnimation[] boneAnimations = this.bakeBoneAnimations(GsonHelper.getAsJsonObject((JsonObject)animationObj, (String)"bones", (JsonObject)new JsonObject()));
        Animation.Keyframes keyframes = (Animation.Keyframes)context.deserialize((JsonElement)animationObj, Animation.Keyframes.class);
        if (length == -1.0) {
            length = BakedAnimationsAdapter.calculateAnimationLength(boneAnimations);
        }
        return new Animation(name, length, loopType, boneAnimations, keyframes);
    }

    private BoneAnimation[] bakeBoneAnimations(JsonObject bonesObj) throws CompoundException {
        BoneAnimation[] animations = new BoneAnimation[bonesObj.size()];
        int index = 0;
        for (Map.Entry entry : bonesObj.entrySet()) {
            JsonObject entryObj = ((JsonElement)entry.getValue()).getAsJsonObject();
            KeyframeStack<Keyframe<MathValue>> scaleFrames = this.buildKeyframeStack(BakedAnimationsAdapter.getKeyframes(entryObj.get("scale")), false);
            KeyframeStack<Keyframe<MathValue>> positionFrames = this.buildKeyframeStack(BakedAnimationsAdapter.getKeyframes(entryObj.get("position")), false);
            KeyframeStack<Keyframe<MathValue>> rotationFrames = this.buildKeyframeStack(BakedAnimationsAdapter.getKeyframes(entryObj.get("rotation")), true);
            animations[index] = new BoneAnimation((String)entry.getKey(), rotationFrames, positionFrames, scaleFrames);
            ++index;
        }
        return animations;
    }

    private static List<DoubleObjectPair<JsonElement>> getKeyframes(JsonElement element) {
        if (element == null) {
            return List.of();
        }
        if (element instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            JsonArray array = new JsonArray(3);
            array.add((JsonElement)primitive);
            array.add((JsonElement)primitive);
            array.add((JsonElement)primitive);
            element = array;
        }
        if (element instanceof JsonArray) {
            JsonArray array = (JsonArray)element;
            return ObjectArrayList.of((Object[])new DoubleObjectPair[]{DoubleObjectPair.of((double)0.0, (Object)array)});
        }
        if (element instanceof JsonObject) {
            JsonObject obj = (JsonObject)element;
            if (obj.has("vector")) {
                return ObjectArrayList.of((Object[])new DoubleObjectPair[]{DoubleObjectPair.of((double)0.0, (Object)obj)});
            }
            ObjectArrayList list = new ObjectArrayList();
            for (Map.Entry entry : obj.entrySet()) {
                JsonObject entryObj;
                double timestamp = BakedAnimationsAdapter.readTimestamp((String)entry.getKey());
                if (timestamp == 0.0 && !list.isEmpty()) {
                    throw new JsonParseException("Invalid keyframe data - multiple starting keyframes?" + (String)entry.getKey());
                }
                Object v = entry.getValue();
                if (v instanceof JsonObject && !(entryObj = (JsonObject)v).has("vector")) {
                    BakedAnimationsAdapter.addBedrockKeyframes(timestamp, entryObj, (List<DoubleObjectPair<JsonElement>>)list);
                    continue;
                }
                list.add(DoubleObjectPair.of((double)timestamp, (Object)((JsonElement)entry.getValue())));
            }
            return list;
        }
        throw new JsonParseException("Invalid object type provided to getTripletObj, got: " + String.valueOf(element));
    }

    private static void addBedrockKeyframes(double timestamp, JsonObject keyframe, List<DoubleObjectPair<JsonElement>> keyframes) {
        boolean addedFrame = false;
        if (keyframe.has("pre")) {
            JsonElement pre = keyframe.get("pre");
            addedFrame = true;
            keyframes.add((DoubleObjectPair<JsonElement>)DoubleObjectPair.of((double)(timestamp == 0.0 ? timestamp : timestamp - 0.001), (Object)(pre.isJsonArray() ? pre.getAsJsonArray() : GsonHelper.getAsJsonArray((JsonObject)pre.getAsJsonObject(), (String)"vector"))));
        }
        if (keyframe.has("post")) {
            JsonArray values;
            JsonElement post = keyframe.get("post");
            JsonArray jsonArray = values = post.isJsonArray() ? post.getAsJsonArray() : GsonHelper.getAsJsonArray((JsonObject)post.getAsJsonObject(), (String)"vector");
            if (keyframe.has("lerp_mode")) {
                JsonObject keyframeObj = new JsonObject();
                keyframeObj.add("vector", (JsonElement)values);
                keyframeObj.add("easing", keyframe.get("lerp_mode"));
                keyframes.add((DoubleObjectPair<JsonElement>)DoubleObjectPair.of((double)timestamp, (Object)keyframeObj));
            } else {
                keyframes.add((DoubleObjectPair<JsonElement>)DoubleObjectPair.of((double)timestamp, (Object)values));
            }
            return;
        }
        if (!addedFrame) {
            throw new JsonParseException("Invalid keyframe data - expected array, found " + String.valueOf(keyframe));
        }
    }

    private KeyframeStack<Keyframe<MathValue>> buildKeyframeStack(List<DoubleObjectPair<JsonElement>> entries, boolean isForRotation) throws CompoundException {
        if (entries.isEmpty()) {
            return new KeyframeStack<Keyframe<MathValue>>();
        }
        ObjectArrayList xFrames = new ObjectArrayList();
        ObjectArrayList yFrames = new ObjectArrayList();
        ObjectArrayList zFrames = new ObjectArrayList();
        MathValue xPrev = null;
        MathValue yPrev = null;
        MathValue zPrev = null;
        DoubleObjectPair<JsonElement> prevEntry = null;
        for (DoubleObjectPair<JsonElement> entry : entries) {
            JsonObject obj;
            JsonArray array;
            JsonElement element = (JsonElement)entry.right();
            double prevTime = prevEntry != null ? prevEntry.leftDouble() : 0.0;
            double curTime = entry.leftDouble();
            double timeDelta = curTime - prevTime;
            JsonArray keyFrameVector = element instanceof JsonArray ? (array = (JsonArray)element) : GsonHelper.getAsJsonArray((JsonObject)element.getAsJsonObject(), (String)"vector");
            MathValue rawXValue = MathParser.parseJson(keyFrameVector.get(0));
            MathValue rawYValue = MathParser.parseJson(keyFrameVector.get(1));
            MathValue rawZValue = MathParser.parseJson(keyFrameVector.get(2));
            MathValue xValue = this.compressMathValue(isForRotation && rawXValue instanceof Constant ? new Constant(Math.toRadians(-rawXValue.get())) : rawXValue);
            MathValue yValue = this.compressMathValue(isForRotation && rawYValue instanceof Constant ? new Constant(Math.toRadians(-rawYValue.get())) : rawYValue);
            MathValue zValue = this.compressMathValue(isForRotation && rawZValue instanceof Constant ? new Constant(Math.toRadians(rawZValue.get())) : rawZValue);
            JsonObject entryObj = element instanceof JsonObject ? (obj = (JsonObject)element) : null;
            EasingType easingType = entryObj != null && entryObj.has("easing") ? EasingType.fromJson(entryObj.get("easing")) : EasingType.LINEAR;
            ObjectArrayList easingArgs = entryObj != null && entryObj.has("easingArgs") ? JsonUtil.jsonArrayToList(GsonHelper.getAsJsonArray((JsonObject)entryObj, (String)"easingArgs"), ele -> new Constant(ele.getAsDouble())) : new ObjectArrayList();
            xFrames.add(new Keyframe<MathValue>(timeDelta * 20.0, prevEntry == null ? xValue : xPrev, xValue, easingType, (List<MathValue>)easingArgs));
            yFrames.add(new Keyframe<MathValue>(timeDelta * 20.0, prevEntry == null ? yValue : yPrev, yValue, easingType, (List<MathValue>)easingArgs));
            zFrames.add(new Keyframe<MathValue>(timeDelta * 20.0, prevEntry == null ? zValue : zPrev, zValue, easingType, (List<MathValue>)easingArgs));
            xPrev = xValue;
            yPrev = yValue;
            zPrev = zValue;
            prevEntry = entry;
        }
        return new KeyframeStack<Keyframe<MathValue>>(this.addSplineArgs((List<Keyframe<MathValue>>)xFrames), this.addSplineArgs((List<Keyframe<MathValue>>)yFrames), this.addSplineArgs((List<Keyframe<MathValue>>)zFrames));
    }

    private List<Keyframe<MathValue>> addSplineArgs(List<Keyframe<MathValue>> frames) {
        Keyframe<MathValue> frame;
        if (frames.size() == 1 && (frame = frames.getFirst()).easingType() != EasingType.LINEAR) {
            frames.set(0, new Keyframe<MathValue>(frame.length(), frame.startValue(), frame.endValue()));
            return frames;
        }
        for (int i = 0; i < frames.size(); ++i) {
            Keyframe<MathValue> frame2 = frames.get(i);
            if (frame2.easingType() != EasingType.CATMULLROM) continue;
            frames.set(i, new Keyframe<MathValue>(frame2.length(), frame2.startValue(), frame2.endValue(), frame2.easingType(), (List<MathValue>)ObjectArrayList.of((Object[])new MathValue[]{i == 0 ? frame2.startValue() : frames.get(i - 1).endValue(), i + 1 >= frames.size() ? frame2.endValue() : frames.get(i + 1).endValue()})));
        }
        return frames;
    }

    private MathValue compressMathValue(MathValue input) {
        if (COMPRESSION_CACHE == null || input.isMutable()) {
            return input;
        }
        return COMPRESSION_CACHE.computeIfAbsent(input.get(), Constant::new);
    }

    private static double calculateAnimationLength(BoneAnimation[] boneAnimations) {
        double length = 0.0;
        for (BoneAnimation animation : boneAnimations) {
            length = Math.max(length, animation.rotationKeyFrames().getLastKeyframeTime());
            length = Math.max(length, animation.positionKeyFrames().getLastKeyframeTime());
            length = Math.max(length, animation.scaleKeyFrames().getLastKeyframeTime());
        }
        return length == 0.0 ? Double.MAX_VALUE : length;
    }

    private static double readTimestamp(String timestamp) {
        return NumberUtils.isCreatable((String)timestamp) ? Double.parseDouble(timestamp) : 0.0;
    }
}

