/*
 * Decompiled with CFR 0.152.
 */
package waves.util;

import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.irisshaders.iris.Iris;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.ModList;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector3f;
import waves.client.particle.WaveParticleOption;
import waves.common.WavesTags;
import waves.common.entities.Wave;
import waves.common.entities.WaveEntities;
import waves.config.Config;
import waves.util.Noise2D;
import waves.util.OpenSimplex2D;
import waves.util.WaveDataManager;

public class WaveHelpers {
    public static final Map<ResourceKey<Level>, Map<Long, Vec3>> NEAREST_SHORE_POS = new HashMap<ResourceKey<Level>, Map<Long, Vec3>>();
    public static final Map<ResourceKey<Level>, Map<Long, Boolean>> IS_SHORE_AT_POS = new HashMap<ResourceKey<Level>, Map<Long, Boolean>>();
    public static final Map<ResourceKey<Level>, Map<Long, Boolean>> IS_SURROUNDED_BY_WATER = new HashMap<ResourceKey<Level>, Map<Long, Boolean>>();
    public static final Map<ResourceKey<Level>, Map<Long, Integer>> SURROUNDING_WATER_COUNT = new HashMap<ResourceKey<Level>, Map<Long, Integer>>();
    public static final Map<ResourceKey<Level>, Map<Long, Map<Long, Boolean>>> HAS_LINE_OF_SIGHT = new HashMap<ResourceKey<Level>, Map<Long, Map<Long, Boolean>>>();
    public static final Direction[] DIRECTIONS_HORIZONTAL = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};

    public static ResourceLocation identifier(String name) {
        return WaveHelpers.resourceLocation("waves", name);
    }

    public static ResourceLocation resourceLocation(String name) {
        return ResourceLocation.parse((String)name);
    }

    public static ResourceLocation resourceLocation(String domain, String path) {
        return ResourceLocation.fromNamespaceAndPath((String)domain, (String)path);
    }

    public static boolean areShadersEnabled() {
        if (ModList.get().isLoaded("oculus") || ModList.get().isLoaded("iris")) {
            return Iris.getIrisConfig().areShadersEnabled();
        }
        return false;
    }

    public static void wipeCaches() {
        NEAREST_SHORE_POS.clear();
        IS_SHORE_AT_POS.clear();
        IS_SURROUNDED_BY_WATER.clear();
        SURROUNDING_WATER_COUNT.clear();
        HAS_LINE_OF_SIGHT.clear();
    }

    public static Noise2D noise(long seed, int octaves, float scale, int minHeight, int maxHeight) {
        OpenSimplex2D warp = new OpenSimplex2D(seed).octaves(octaves).spread(0.03f).scaled(-scale, scale);
        return new OpenSimplex2D(seed + 1L).octaves(octaves).spread(0.06f).warped(warp).map(x -> x > 0.4 ? x - (double)0.8f : -x).scaled(-0.4f, 0.8f, minHeight, maxHeight);
    }

    public static double noise(double x, long seed, int octaves, int minHeight, int maxHeight, double factor) {
        return WaveHelpers.noise(seed, octaves, 100.0f, minHeight, maxHeight).noise(x, 0.0) * factor;
    }

    public static float triangle(RandomSource random) {
        return random.nextFloat() - random.nextFloat() * 0.5f;
    }

    public static float lerp(float delta, float min, float max) {
        return min + (max - min) * delta;
    }

    public static double lerp(double delta, double min, double max) {
        return min + (max - min) * delta;
    }

    public static double easeOutQuart(double t, double min, double max) {
        double change = max - min;
        return -change * ((t -= 1.0) * t * t * t - 1.0) + min;
    }

    public static Vec3 applyEaseOutQuart(Vec3 direction, double distance, double initialDistance, double min, double max) {
        double t = distance / initialDistance;
        double speed = WaveHelpers.easeOutQuart(t, min, max);
        return direction.scale(speed);
    }

    public static double easeInOutExpo(double t, double min, double max) {
        double range = max - min;
        if (t <= 0.0) {
            return min;
        }
        if (t >= 1.0) {
            return max;
        }
        if (t < 0.5) {
            return min + range / 2.0 * Math.pow(2.0, 20.0 * t - 10.0);
        }
        return min + range / 2.0 * (2.0 - Math.pow(2.0, -20.0 * t + 10.0));
    }

    public static double easeOutInExpo(double t, double min, double max) {
        double range = max - min;
        if (t >= 1.0) {
            return min;
        }
        if (t <= 0.0) {
            return max;
        }
        if (t < 0.5) {
            return min + range * (1.0 - Math.pow(2.0, -20.0 * t));
        }
        return min + range * (Math.pow(2.0, 20.0 * (t - 1.0)) / 2.0 + 0.5);
    }

    public static double easeInOutExpoNorm(double t, double min, double max, double lowerBound, double upperBound) {
        double range = max - min;
        double normalizedT = (t - lowerBound) / (upperBound - lowerBound);
        if (normalizedT <= 0.0) {
            return min;
        }
        if (normalizedT >= 1.0) {
            return max;
        }
        if (normalizedT < 0.5) {
            return min + range / 2.0 * Math.pow(2.0, 20.0 * normalizedT - 10.0);
        }
        return min + range / 2.0 * (2.0 - Math.pow(2.0, -20.0 * normalizedT + 10.0));
    }

    public static double easeInExpo(double t, double min, double max) {
        double range = max - min;
        return t <= 0.0 ? min : min + range * Math.pow(2.0, 10.0 * (t - 1.0));
    }

    public static double easeOutExpo(double t, double min, double max) {
        double range = max - min;
        return t >= 1.0 ? max : min + range * (1.0 - Math.pow(2.0, -10.0 * t));
    }

    public static Vec3 inverse(Vec3 vector) {
        return new Vec3(-vector.x(), -vector.y(), -vector.z());
    }

    public static BlockPos toBlockPos(Vec3 pos) {
        return WaveHelpers.toBlockPos(pos, 0);
    }

    public static BlockPos toBlockPos(Vec3 pos, int roundingMethod) {
        if (roundingMethod >= 2) {
            return new BlockPos((int)Math.ceil(pos.x()), (int)Math.ceil(pos.y()), (int)Math.ceil(pos.z()));
        }
        if (roundingMethod == 1) {
            return new BlockPos((int)Math.round(pos.x()), (int)Math.round(pos.y()), (int)Math.round(pos.z()));
        }
        return new BlockPos((int)Math.floor(pos.x()), (int)Math.floor(pos.y()), (int)Math.floor(pos.z()));
    }

    public static BlockPos toBlockPos(Vector3f pos) {
        return WaveHelpers.toBlockPos(pos, 0);
    }

    public static BlockPos toBlockPos(Vector3f pos, int roundingMethod) {
        if (roundingMethod >= 2) {
            return new BlockPos((int)Math.ceil(pos.x()), (int)Math.ceil(pos.y()), (int)Math.ceil(pos.z()));
        }
        if (roundingMethod == 1) {
            return new BlockPos(Math.round(pos.x()), Math.round(pos.y()), Math.round(pos.z()));
        }
        return new BlockPos((int)Math.floor(pos.x()), (int)Math.floor(pos.y()), (int)Math.floor(pos.z()));
    }

    public static Vec3 toVec3(BlockPos pos) {
        return new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
    }

    public static Vector3f toVector3f(BlockPos pos) {
        return new Vector3f((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
    }

    public static Optional<Block> randomBlock(TagKey<Block> tag, RandomSource random) {
        return WaveHelpers.getRandomElement(BuiltInRegistries.BLOCK, tag, random);
    }

    public static <T> Optional<T> getRandomElement(Registry<T> registry, TagKey<T> tag, RandomSource random) {
        return registry.getTag(tag).flatMap(set -> set.getRandomElement(random)).map(Holder::value);
    }

    public static boolean isEntity(Entity entity, TagKey<EntityType<?>> tag) {
        return WaveHelpers.isEntity(entity.getType(), tag);
    }

    public static boolean isEntity(EntityType<?> entity, TagKey<EntityType<?>> tag) {
        return entity.is(tag);
    }

    public static boolean isBlock(BlockState block, Block other) {
        return block.is(other);
    }

    public static boolean isBlock(BlockState state, TagKey<Block> tag) {
        return state.is(tag);
    }

    public static boolean isBlock(Block block, TagKey<Block> tag) {
        return block.builtInRegistryHolder().is(tag);
    }

    public static boolean isBlackOrWhitelisted(Block block, TagKey<Block> whitelistTag, TagKey<Block> blacklistTag) {
        boolean isWhitelisted = WaveHelpers.isBlock(block, whitelistTag);
        boolean isBlacklisted = WaveHelpers.isBlock(block, blacklistTag);
        return isWhitelisted && !isBlacklisted || !isWhitelisted && !isBlacklisted;
    }

    public static boolean isFluid(Level level, FluidState fluidState, TagKey<Fluid> tag) {
        return fluidState.is(tag);
    }

    public static boolean isBlackOrWhitelisted(Level level, BlockState block, TagKey<Block> whitelistTag, TagKey<Block> blacklistTag) {
        boolean isWhitelisted = block.is(whitelistTag);
        boolean isBlacklisted = block.is(blacklistTag);
        return isWhitelisted && !isBlacklisted || !isWhitelisted && !isBlacklisted;
    }

    public static boolean isBiome(Level level, Holder<Biome> biome, TagKey<Biome> tag) {
        return biome.is(tag);
    }

    public static Vec3 findNearestShorePos(Level level, Vec3 currentPos, int searchRadius, double minDistance) {
        if (((Boolean)Config.COMMON.useCaches.get()).booleanValue() && ((Boolean)Config.COMMON.cacheNearestShorePos.get()).booleanValue()) {
            ResourceKey dimension = level.dimension();
            long posKey = WaveHelpers.toBlockPos(currentPos).asLong();
            if (NEAREST_SHORE_POS.containsKey(dimension)) {
                Map<Long, Vec3> dimensionCache = NEAREST_SHORE_POS.get(dimension);
                if (dimensionCache.containsKey(posKey)) {
                    return dimensionCache.get(posKey);
                }
                Vec3 computedResult = WaveHelpers.computeNearestShorePos(level, currentPos, searchRadius, minDistance);
                NEAREST_SHORE_POS.get(dimension).put(posKey, computedResult);
                return computedResult;
            }
            return NEAREST_SHORE_POS.computeIfAbsent((ResourceKey<Level>)dimension, key -> new HashMap()).computeIfAbsent(posKey, bp -> WaveHelpers.computeNearestShorePos(level, currentPos, searchRadius, minDistance));
        }
        return WaveHelpers.computeNearestShorePos(level, currentPos, searchRadius, minDistance);
    }

    public static Vec3 computeNearestShorePos(Level level, Vec3 currentPos, int searchRadius, double minDistance) {
        Vec3 nearestShorePos = null;
        double closestDistance = 1000000.0;
        int iterationCount = 0;
        int maxIterations = (Integer)Config.COMMON.waveFindNearestShoreIterations.get();
        for (int radius = 0; radius <= searchRadius; ++radius) {
            for (int i = -radius; i <= radius; ++i) {
                for (int j = -radius; j <= radius; ++j) {
                    double distance;
                    if (Math.abs(i) != radius && Math.abs(j) != radius) continue;
                    double x = currentPos.x() + (double)i;
                    double z = currentPos.z() + (double)j;
                    Vec3 checkPos = new Vec3(x, currentPos.y(), z);
                    if (WaveHelpers.isShore(level, checkPos) && (distance = currentPos.distanceTo(checkPos)) < closestDistance && distance > minDistance) {
                        closestDistance = distance;
                        nearestShorePos = checkPos;
                        ++iterationCount;
                    }
                    if (iterationCount < maxIterations) continue;
                    return nearestShorePos;
                }
            }
        }
        return nearestShorePos;
    }

    public static Vector3f simplifyDecimals(Vector3f input, int decimals) {
        float factor = (float)Math.pow(10.0, decimals);
        float x = (float)Math.round(input.x() * factor) / factor;
        float y = (float)Math.round(input.y() * factor) / factor;
        float z = (float)Math.round(input.z() * factor) / factor;
        return new Vector3f(x, y, z);
    }

    public static double calculateDistanceToShore(Level level, Vec3 currentPos, int searchRadius, double minDistance) {
        Vec3 nearestShorePos = WaveHelpers.findNearestShorePos(level, currentPos, searchRadius, minDistance);
        return WaveHelpers.calculateDistanceToShore(currentPos, nearestShorePos);
    }

    public static double calculateDistanceToShore(Vec3 currentPos, Vec3 nearestShorePos) {
        return currentPos.distanceTo(nearestShorePos);
    }

    public static double calculateAngleToShore(Level level, Vec3 currentPos, int searchRadius, double minDistance) {
        Vec3 nearestShorePos = WaveHelpers.findNearestShorePos(level, currentPos, searchRadius, minDistance);
        if (nearestShorePos != null) {
            double deltaX = nearestShorePos.x() - currentPos.x();
            double deltaZ = nearestShorePos.z() - currentPos.z();
            return Math.toDegrees(Math.atan2(deltaZ, deltaX));
        }
        return -1.0;
    }

    public static double calculateAngleToTarget(Vec3 currentPos, Vec3 shorePos) {
        Vec3 direction = shorePos.subtract(currentPos).normalize();
        return WaveHelpers.getAngle(direction);
    }

    public static double getAngle(Vec3 vec) {
        Vec3 norm = vec.normalize();
        return Math.atan2(norm.z(), norm.x());
    }

    public static double calculateAverageAngle(Level level, BlockPos targetCenter, int radius) {
        ArrayList<Double> angles = new ArrayList<Double>();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                BlockPos checkPos = targetCenter.offset(x, 0, z);
                if (!WaveHelpers.isShore(level, checkPos)) continue;
                Vec3 vecCenter = WaveHelpers.toVec3(targetCenter);
                Vec3 vecCheck = WaveHelpers.toVec3(checkPos);
                double angle = WaveHelpers.calculateAngleToTarget(vecCenter, vecCheck);
                angles.add(angle);
            }
        }
        return angles.stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
    }

    public static Vec3 calculateCenterPoint(Level level, BlockPos targetCenter, int radius) {
        ArrayList<BlockPos> shorePositions = new ArrayList<BlockPos>();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                BlockPos checkPos = targetCenter.offset(x, 0, z);
                if (!WaveHelpers.isShore(level, checkPos)) continue;
                shorePositions.add(checkPos);
            }
        }
        if (shorePositions.isEmpty()) {
            return Vec3.ZERO;
        }
        double sumX = 0.0;
        double sumY = 0.0;
        double sumZ = 0.0;
        for (BlockPos pos : shorePositions) {
            sumX += (double)pos.getX();
            sumY += (double)pos.getY();
            sumZ += (double)pos.getZ();
        }
        double centerX = sumX / (double)shorePositions.size();
        double centerY = sumY / (double)shorePositions.size();
        double centerZ = sumZ / (double)shorePositions.size();
        return new Vec3(centerX, centerY, centerZ);
    }

    public static double calculateWaveOrthogonalToTarget(Level level, BlockPos targetCenter, int radius) {
        return WaveHelpers.calculateAverageAngle(level, targetCenter, radius) + 1.5707963267948966;
    }

    public static boolean isShore(Level level, Vec3 pos) {
        return WaveHelpers.isShore(level, WaveHelpers.toBlockPos(pos));
    }

    public static boolean isShore(Level level, BlockPos pos) {
        if (((Boolean)Config.COMMON.useCaches.get()).booleanValue() && ((Boolean)Config.COMMON.cacheShorePos.get()).booleanValue()) {
            ResourceKey dimension = level.dimension();
            long posKey = pos.asLong();
            if (IS_SHORE_AT_POS.containsKey(dimension)) {
                Map<Long, Boolean> dimensionCache = IS_SHORE_AT_POS.get(dimension);
                if (dimensionCache.containsKey(posKey)) {
                    return dimensionCache.get(posKey);
                }
                boolean computedResult = WaveHelpers.computeIsShore(level, pos);
                IS_SHORE_AT_POS.get(dimension).put(posKey, computedResult);
                return computedResult;
            }
            return IS_SHORE_AT_POS.computeIfAbsent((ResourceKey<Level>)dimension, key -> new HashMap()).computeIfAbsent(posKey, bp -> WaveHelpers.computeIsShore(level, pos));
        }
        return WaveHelpers.computeIsShore(level, pos);
    }

    public static boolean computeIsShore(Level level, BlockPos pos) {
        FluidState fluidState = WaveHelpers.getFastFluidState(level, pos);
        return fluidState != null && fluidState.isEmpty() && WaveHelpers.isSurroundedByWater(level, pos, 1, 1);
    }

    public static boolean isSurroundedByWater(Level level, Vec3 pos, int radius) {
        return WaveHelpers.isSurroundedByWater(level, pos, radius, 4 * radius);
    }

    public static boolean isSurroundedByWater(Level level, Vec3 pos, int radius, int requiredAmount) {
        return WaveHelpers.isSurroundedByWater(level, WaveHelpers.toBlockPos(pos), radius, requiredAmount);
    }

    public static boolean isSurroundedByWater(Level level, BlockPos pos, int radius, int requiredAmount) {
        if (((Boolean)Config.COMMON.useCaches.get()).booleanValue() && ((Boolean)Config.COMMON.cacheSurroundedByWater.get()).booleanValue()) {
            ResourceKey dimension = level.dimension();
            long posKey = pos.asLong();
            if (IS_SURROUNDED_BY_WATER.containsKey(dimension)) {
                Map<Long, Boolean> dimensionCache = IS_SURROUNDED_BY_WATER.get(dimension);
                if (dimensionCache.containsKey(posKey)) {
                    return dimensionCache.get(posKey);
                }
                boolean computedResult = WaveHelpers.computeIsSurroundedByWater(level, pos, radius, requiredAmount);
                IS_SURROUNDED_BY_WATER.get(dimension).put(posKey, computedResult);
                return computedResult;
            }
            return IS_SURROUNDED_BY_WATER.computeIfAbsent((ResourceKey<Level>)dimension, key -> new HashMap()).computeIfAbsent(posKey, bp -> WaveHelpers.computeIsSurroundedByWater(level, pos, radius, requiredAmount));
        }
        return WaveHelpers.computeIsSurroundedByWater(level, pos, radius, requiredAmount);
    }

    public static boolean computeIsSurroundedByWater(Level level, BlockPos pos, int radius, int requiredAmount) {
        int waterFaces = 0;
        for (Direction direction : DIRECTIONS_HORIZONTAL) {
            for (int offset = 0; offset < radius; ++offset) {
                BlockPos relative = pos.relative(direction, offset + 1);
                FluidState fluidState = WaveHelpers.getFastFluidState(level, relative);
                if (fluidState != null && WaveHelpers.isFluid(level, fluidState, WavesTags.Fluids.HAS_WAVES)) {
                    ++waterFaces;
                }
                if (waterFaces < requiredAmount) continue;
                return true;
            }
        }
        return waterFaces >= requiredAmount;
    }

    public static FluidState getFastFluidState(Level level, BlockPos pos) {
        if (level.isOutsideBuildHeight(pos)) {
            return Fluids.EMPTY.defaultFluidState();
        }
        ChunkAccess chunk = WaveHelpers.getFastChunkAccess(level, pos);
        return chunk == null ? null : chunk.getFluidState(pos);
    }

    public static BlockState getFastBlockState(Level level, BlockPos pos) {
        if (level.isOutsideBuildHeight(pos)) {
            return Blocks.VOID_AIR.defaultBlockState();
        }
        ChunkAccess chunk = WaveHelpers.getFastChunkAccess(level, pos);
        return chunk == null ? Blocks.VOID_AIR.defaultBlockState() : chunk.getBlockState(pos);
    }

    public static ChunkAccess getFastChunkAccess(Level level, BlockPos pos) {
        int x = SectionPos.blockToSectionCoord((int)pos.getX());
        int z = SectionPos.blockToSectionCoord((int)pos.getZ());
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            return server.getChunkSource().getChunkNow(x, z);
        }
        return level.getChunkSource().getChunkNow(x, z);
    }

    public static boolean isSurroundedByWaterCircle(Level level, Vec3 pos, int radius) {
        return WaveHelpers.isSurroundedByWaterCircle(level, pos, radius, Mth.floor((double)(Math.PI * Math.pow(radius, 2.0))) - 1);
    }

    public static boolean isSurroundedByWaterCircle(Level level, Vec3 pos, int radius, int requiredAmount) {
        return WaveHelpers.isSurroundedByWaterCircle(level, WaveHelpers.toBlockPos(pos), radius, requiredAmount);
    }

    public static boolean isSurroundedByWaterCircle(Level level, BlockPos pos, int radius, int requiredAmount) {
        if (((Boolean)Config.COMMON.useCaches.get()).booleanValue() && ((Boolean)Config.COMMON.cacheSurroundedByWater.get()).booleanValue()) {
            ResourceKey dimension = level.dimension();
            long posKey = pos.asLong();
            if (IS_SURROUNDED_BY_WATER.containsKey(dimension)) {
                Map<Long, Boolean> dimensionCache = IS_SURROUNDED_BY_WATER.get(dimension);
                if (dimensionCache.containsKey(posKey)) {
                    return dimensionCache.get(posKey);
                }
                boolean computedResult = WaveHelpers.computeIsSurroundedByWaterCircle(level, pos, radius, requiredAmount);
                IS_SURROUNDED_BY_WATER.get(dimension).put(posKey, computedResult);
                return computedResult;
            }
            return IS_SURROUNDED_BY_WATER.computeIfAbsent((ResourceKey<Level>)dimension, key -> new HashMap()).computeIfAbsent(posKey, bp -> WaveHelpers.computeIsSurroundedByWaterCircle(level, pos, radius, requiredAmount));
        }
        return WaveHelpers.computeIsSurroundedByWaterCircle(level, pos, radius, requiredAmount);
    }

    public static boolean computeIsSurroundedByWaterCircle(Level level, BlockPos pos, int radius, int requiredAmount) {
        int waterFaces = 0;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (x * x + z * z > radius * radius) continue;
                BlockPos relative = pos.offset(x, 0, z);
                FluidState fluidState = WaveHelpers.getFastFluidState(level, relative);
                if (fluidState != null && WaveHelpers.isFluid(level, fluidState, WavesTags.Fluids.HAS_WAVES)) {
                    ++waterFaces;
                }
                if (waterFaces < requiredAmount) continue;
                return true;
            }
        }
        return waterFaces >= requiredAmount;
    }

    public static int getSurroundingWaterBlocks(Level level, Vec3 input, int radius) {
        boolean useCaches = (Boolean)Config.COMMON.useCaches.get();
        BlockPos pos = WaveHelpers.toBlockPos(input);
        if (useCaches && ((Boolean)Config.COMMON.cacheSurroundingWaterAmount.get()).booleanValue()) {
            ResourceKey dimension = level.dimension();
            long posKey = pos.asLong();
            if (SURROUNDING_WATER_COUNT.containsKey(dimension)) {
                Map<Long, Integer> dimensionCache = SURROUNDING_WATER_COUNT.get(dimension);
                if (dimensionCache.containsKey(posKey)) {
                    return dimensionCache.get(posKey);
                }
                int computedResult = WaveHelpers.computeSurroundingWaterBlocks(level, pos, radius);
                SURROUNDING_WATER_COUNT.get(dimension).put(posKey, computedResult);
                return computedResult;
            }
            return SURROUNDING_WATER_COUNT.computeIfAbsent((ResourceKey<Level>)level.dimension(), key -> new HashMap()).computeIfAbsent(pos.asLong(), bp -> WaveHelpers.computeSurroundingWaterBlocks(level, pos, radius));
        }
        return WaveHelpers.computeSurroundingWaterBlocks(level, pos, radius);
    }

    public static int computeSurroundingWaterBlocks(Level level, BlockPos blockPos, int radius) {
        int waterFaces = 0;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                BlockPos relative;
                FluidState fluidState;
                if (x == 0 && z == 0 || (fluidState = WaveHelpers.getFastFluidState(level, relative = blockPos.offset(x, 0, z))) == null || !WaveHelpers.isFluid(level, fluidState, WavesTags.Fluids.HAS_WAVES)) continue;
                ++waterFaces;
            }
        }
        return waterFaces;
    }

    public static String toSize(int index) {
        switch (index) {
            case 1: {
                return "medium";
            }
            case 2: {
                return "large";
            }
        }
        return "small";
    }

    public static void playSound(Level level, RandomSource random, BlockPos pos, SoundEvent sound, SoundSource source, boolean distanceDelay, float amplifier) {
        level.playLocalSound(pos, sound, source, (random.nextFloat() * 0.75f + 0.35f) * amplifier, random.nextFloat() * 0.8f + 0.7f, distanceDelay);
    }

    public static double soundDistanceMod(Player player, Vec3 targetPos, double min, double max) {
        double distance = player.position().distanceTo(targetPos);
        if (distance <= max) {
            return 1.0;
        }
        if (distance >= min) {
            return 0.0;
        }
        double lerpFactor = (min - distance) / (min - max);
        lerpFactor = Mth.clamp((double)lerpFactor, (double)0.0, (double)1.0);
        return lerpFactor;
    }

    public static BlockPos getRandomBlockPosAlongWave(Level level, RandomSource random, Vec3 pos, Vec3 direction, double width, int seaLevel) {
        Quaternionf quaternion = new Quaternionf().rotateY((float)Math.toRadians(90.0));
        Vec3 rotatedVec = new Vec3(direction.toVector3f().rotate((Quaternionfc)quaternion));
        double pointOnWave = (random.nextDouble() - 0.5) * 2.0 * width;
        double thickness = (random.nextDouble() - 0.5) * 2.0 * 2.0;
        Vec3 position = new Vec3(pos.x(), (double)seaLevel, pos.z()).add(rotatedVec.scale(pointOnWave).x(), 0.0, rotatedVec.scale(pointOnWave).z()).add(direction.scale(thickness).x(), 0.0, direction.scale(thickness).z());
        return WaveHelpers.toBlockPos(position, 1);
    }

    public static int updateSprite(double initialDistance, double currentDistance) {
        if (initialDistance == 0.0) {
            return 0;
        }
        double lerpFactor = 1.0 - currentDistance / initialDistance;
        return (int)Math.round(Mth.clamp((double)(Mth.clamp((double)lerpFactor, (double)0.0, (double)1.0) * (double)((Integer)Config.COMMON.waveSpriteCount.get() - 1)), (double)0.0, (double)((Integer)Config.COMMON.waveSpriteCount.get() - 1)));
    }

    public static int updateSprite(double initialDistance, double currentDistance, double power) {
        if (initialDistance == 0.0) {
            return 0;
        }
        double progress = 1.0 - currentDistance / initialDistance;
        double easeInQuartFactor = Math.pow(progress, power);
        return (int)Math.round(Mth.clamp((double)(easeInQuartFactor * (double)((Integer)Config.COMMON.waveSpriteCount.get() - 1)), (double)0.0, (double)((Integer)Config.COMMON.waveSpriteCount.get() - 1)));
    }

    public static BlockPos getRandomPositionInChunk(LevelChunk chunk, RandomSource random) {
        int x = chunk.getPos().getMinBlockX() + random.nextInt(16);
        int z = chunk.getPos().getMinBlockZ() + random.nextInt(16);
        int y = chunk.getHeight(Heightmap.Types.WORLD_SURFACE, x, z);
        return new BlockPos(x, y, z);
    }

    public static boolean isWithinDistanceToPlayer(ServerLevel level, BlockPos pos, double maxDistance) {
        List players = level.players();
        for (Player player : players) {
            if (!(player.blockPosition().distSqr((Vec3i)pos) <= maxDistance * maxDistance)) continue;
            return true;
        }
        return false;
    }

    public static Vec3 getPositionOffset(Vec3 currentPos, double direction, double directionOffset, double distance) {
        double angle = Math.toRadians(direction + directionOffset);
        double x = currentPos.x() + distance * Math.cos(angle);
        double z = currentPos.z() + distance * Math.sin(angle);
        return new Vec3(x, currentPos.y(), z);
    }

    public static double getMoonPhase(Level level) {
        double phase = ((double)(level.dayTime() / 24000L) % 8.0 + 8.0) % 8.0;
        double shift = phase - 3.75;
        double adjust = shift < 0.0 ? 8.0 + shift : (shift >= 8.0 ? shift - 8.0 : shift);
        return adjust >= 4.0 ? 1.0 - (adjust - 4.0) / 4.0 : adjust / 4.0;
    }

    public static double getSkyBrightness(Level level, float partialTicks) {
        double d0 = 1.0 - (double)(level.getRainLevel(partialTicks) * 5.0f) / 16.0;
        double d1 = 1.0 - (double)(level.getThunderLevel(partialTicks) * 5.0f) / 16.0;
        double d2 = 0.5 + 2.0 * Mth.clamp((double)Math.cos((double)level.getTimeOfDay(partialTicks) * (Math.PI * 2)), (double)-0.25, (double)0.25);
        return 1.0 - (1.0 - d2 * d0 * d1) * 11.0 / 11.0;
    }

    public static Noise2D bioluminescenceNoise(Level level, long seed, int octaves) {
        double moonPhase = WaveHelpers.easeInOutExpoNorm(WaveHelpers.getMoonPhase(level), 0.0, 1.0, 0.875, 0.9375) * 0.3;
        OpenSimplex2D layer = new OpenSimplex2D(seed).octaves(octaves).scaled(0.0, 1.0);
        return layer.easeInOutExpoNorm(0.0, 1.0, 0.78 - moonPhase, 0.875 - moonPhase);
    }

    public static int getServerChunkRenderDistance(Level level) {
        int n;
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            n = server.getServer().getPlayerList().getViewDistance();
        } else {
            n = level.getServer().getPlayerList().getViewDistance();
        }
        return n;
    }

    public static int getServerChunkSimulationDistance(Level level) {
        int n;
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            n = server.getServer().getPlayerList().getSimulationDistance();
        } else {
            n = level.getServer().getPlayerList().getSimulationDistance();
        }
        return n;
    }

    public static <T extends ParticleOptions> boolean sendParticle(Level level, T particle, Player player, Vec3 startPos, Vec3 shorePos, Vec3 direction, float scale, float size, float speed, int waveSize, int surroundWaterBlocks) {
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                return server.sendParticles(serverPlayer, particle, true, startPos.x(), startPos.y(), startPos.z(), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        return false;
    }

    public static Axis getAxis() {
        switch ((Integer)Config.COMMON.axisIndex.get()) {
            case 1: {
                return Axis.YP;
            }
            case 2: {
                return Axis.ZP;
            }
            case 3: {
                return Axis.XN;
            }
            case 4: {
                return Axis.YN;
            }
            case 5: {
                return Axis.ZN;
            }
        }
        return Axis.XP;
    }

    public static boolean isWithinAngle(Vec3 targetPos, Player player, double fov) {
        Vec3 directionToObject = targetPos.subtract(player.position()).normalize();
        return Math.acos(player.getLookAngle().dot(directionToObject)) <= Math.toRadians(fov);
    }

    public static Vec3 unpackToVec3(List<Double> list) {
        return new Vec3(list.get(0).doubleValue(), list.get(1).doubleValue(), list.get(2).doubleValue());
    }

    public static boolean hasLineOfSight(Level level, Vec3 thisPos, Vec3 targetPos) {
        return level.clip(new ClipContext(thisPos, targetPos, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, EntityType.ARROW.create(level))).getType() == HitResult.Type.MISS;
    }

    public static boolean isOverlappingRegion(Level level, Player player, Vec3 playerPos, Vec3 wavePos, double radiusCheck) {
        boolean isOverlapping = false;
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            for (ServerPlayer serverPlayer : server.players()) {
                Vector2d wave;
                Vector2d pos2;
                Vector2d pos1;
                if (serverPlayer.equals((Object)player) || (pos1 = new Vector2d(playerPos.x(), playerPos.z())).distance((Vector2dc)(pos2 = new Vector2d(serverPlayer.position().x(), serverPlayer.position().z()))) > radiusCheck * 2.0 || !(pos1.distance((Vector2dc)(wave = new Vector2d(wavePos.x(), wavePos.z()))) > pos2.distance((Vector2dc)wave))) continue;
                isOverlapping = true;
                break;
            }
        }
        return isOverlapping;
    }

    public static void spawnWaves(ServerLevel level, Player player, boolean spawnWaveEntity) {
        if (level.getGameTime() % (long)((Integer)Config.COMMON.waveSpawnFrequency.get()).intValue() == 0L) {
            RandomSource random = level.getRandom();
            int seaLevel = WaveDataManager.WAVE_DATA.getCachedSeaLevelOrDefault((Level)level);
            int seaLevelWave = seaLevel - 1;
            Vec3 playerPos = player.position();
            float rainfall = 1.0f + level.rainLevel;
            double renderDistance = WaveHelpers.getServerChunkRenderDistance((Level)level);
            double simulationDistance = (double)WaveHelpers.getServerChunkSimulationDistance((Level)level) * 16.0;
            if (renderDistance > 0.0) {
                boolean equalSpawnDistribution = (Boolean)Config.COMMON.waveEqualSpawnDistribution.get();
                double spawnAmount = equalSpawnDistribution ? (Double)Config.COMMON.waveSpawnAmount.get() : (Double)Config.COMMON.waveSpawnAmount.get() * 0.05;
                int iterations = (int)Math.round((Math.pow(Math.log(0.5 + renderDistance), 6.0) + 1.0) * spawnAmount * (double)rainfall);
                int searchRadius = (Integer)Config.COMMON.waveSearchDistance.get();
                double spawnRadius = renderDistance * 16.0 + (Double)Config.COMMON.waveSpawnDistance.get();
                double minShoreDistance = (Double)Config.COMMON.waveSpawnDistanceFromShoreMin.get();
                double maxShoreDistance = (Double)Config.COMMON.waveSpawnDistanceFromShoreMax.get();
                if (spawnRadius > 0.0 && (double)iterations > 0.0) {
                    for (int i = 0; i < iterations; ++i) {
                        Wave wave;
                        Vec3 shorePos;
                        BlockPos waveBlockPos;
                        double z;
                        double angle = random.nextDouble() * 2.0 * Math.PI;
                        double radius = (equalSpawnDistribution ? Math.sqrt(random.nextDouble()) : random.nextDouble()) * spawnRadius;
                        double x = playerPos.x() + radius * Math.cos(angle);
                        Vec3 wavePos = new Vec3(x, (double)seaLevelWave, z = playerPos.z() + radius * Math.sin(angle));
                        double distanceToWave = wavePos.distanceTo(playerPos);
                        if (distanceToWave >= renderDistance * 16.0 || !WaveHelpers.isWithinAngle(wavePos, player, (Double)Config.COMMON.waveSpawningFOVLimit.get()) || WaveHelpers.isOverlappingRegion((Level)level, player, playerPos, wavePos, spawnRadius) || !level.isLoaded(waveBlockPos = WaveHelpers.toBlockPos(wavePos)) || !WaveHelpers.isBiome((Level)level, (Holder<Biome>)level.getBiome(waveBlockPos), WavesTags.Biomes.HAS_WAVES) || (shorePos = WaveHelpers.findNearestShorePos((Level)level, wavePos, searchRadius, minShoreDistance)) == null) continue;
                        BlockPos shoreBlockPos = WaveHelpers.toBlockPos(shorePos);
                        BlockState shoreBlock = WaveHelpers.getFastBlockState((Level)level, shoreBlockPos);
                        if (!level.isLoaded(shoreBlockPos) || !WaveHelpers.isBlackOrWhitelisted((Level)level, shoreBlock, WavesTags.Blocks.SHORE_BLOCKS_WHITELIST, WavesTags.Blocks.SHORE_BLOCKS_BLACKLIST) || !(WaveHelpers.calculateDistanceToShore(shorePos, wavePos) <= maxShoreDistance) || !WaveHelpers.isSurroundedByWaterCircle((Level)level, wavePos, Mth.floor((double)minShoreDistance))) continue;
                        Vec3 direction = new Vec3(shorePos.x() - wavePos.x(), shorePos.y() - wavePos.y(), shorePos.z() - wavePos.z()).normalize();
                        float waveWidth = 3.0f + (float)random.nextInt(12);
                        float waveSpeed = 0.1f * rainfall;
                        int surroundWaterBlocks = WaveHelpers.getSurroundingWaterBlocks((Level)level, shorePos, 1);
                        if (surroundWaterBlocks > 3 && random.nextInt(Math.round((float)surroundWaterBlocks * 0.7f)) != 0) continue;
                        int surroundWaterBlocksJitter = Mth.clamp((int)(surroundWaterBlocks - random.nextInt(4)), (int)0, (int)8);
                        int waveSize = Mth.clamp((int)Math.round((float)surroundWaterBlocksJitter / 4.0f), (int)0, (int)2);
                        double heightOffset = random.nextDouble() * 0.01;
                        Vec3 wavePosOffset = wavePos.add(0.0, 1.001 + heightOffset, 0.0);
                        Vec3 shorePosOffset = shorePos.add(0.0, 1.001 + heightOffset, 0.0);
                        WaveParticleOption waveParticles = new WaveParticleOption(wavePosOffset, shorePosOffset, direction, 0.01f, waveWidth, waveSpeed, waveSize, surroundWaterBlocks);
                        boolean spawnedParticle = WaveHelpers.sendParticle((Level)level, waveParticles, player, wavePosOffset, shorePosOffset, direction, 0.01f, waveWidth, waveSpeed, waveSize, surroundWaterBlocks);
                        if (!((Boolean)Config.COMMON.toggleWaveEntities.get()).booleanValue() || !spawnWaveEntity || !spawnedParticle || WaveEntities.WAVES == null || (wave = (Wave)((EntityType)WaveEntities.WAVES.get()).create((Level)level)) == null || !(distanceToWave < simulationDistance)) continue;
                        wave.setParameters(wavePosOffset, shorePosOffset, direction, 0.01f, waveWidth, waveSpeed, waveSize, surroundWaterBlocks, seaLevel);
                        level.addFreshEntity((Entity)wave);
                    }
                }
            }
        }
    }
}

