/*
 * Decompiled with CFR 0.152.
 */
package waves.common.entities;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import waves.common.WavesTags;
import waves.config.Config;
import waves.util.WaveHelpers;

public class Wave
extends Entity {
    public boolean hasInitializedParameters = false;
    public Level level;
    public Vec3 startPos;
    public Vec3 shorePos;
    public Vec3 direction;
    public float scale;
    public float size;
    public float speed;
    public int waveSize;
    public int surroundWaterBlocks;
    public int seaLevel;
    public double initialDistance;
    public boolean hasReachedShore = false;
    public boolean hasTouchedLand = false;
    public boolean hasPlacedBlock = false;
    public int waveSpriteOld;
    public double angleToShore;
    public float quadSize;
    public boolean onGround;
    public float bbWidth = 0.6f;
    public float bbHeight = 1.8f;
    public double x;
    public double y;
    public double z;
    public double xd;
    public double yd;
    public double zd;
    public int age;
    public double diagonalSize;
    public AABB aabb;

    public Wave(EntityType<? extends Entity> entityType, Level level) {
        super(entityType, level);
        this.level = level;
    }

    public void setParameters(Vec3 startPos, Vec3 shorePos, Vec3 direction, float scale, float size, float speed, int waveSize, int surroundWaterBlocks, int seaLevel) {
        this.hasInitializedParameters = true;
        this.startPos = startPos;
        this.shorePos = shorePos;
        this.direction = direction;
        this.scale = scale;
        this.size = size;
        this.speed = speed;
        this.waveSize = waveSize;
        this.surroundWaterBlocks = surroundWaterBlocks;
        this.seaLevel = seaLevel;
        this.setPos(startPos);
        this.xd = direction.x() * (double)speed;
        this.zd = direction.z() * (double)speed;
        this.angleToShore = WaveHelpers.getAngle(direction);
        this.quadSize = size * 0.5f;
        this.setSize(this.quadSize, (double)this.quadSize * 0.075, (double)this.quadSize * 0.2);
        this.setInvulnerable(true);
        this.noPhysics = true;
        this.initialDistance = startPos.distanceTo(shorePos);
        this.waveSpriteOld = 0;
        this.age = 0;
        this.diagonalSize = Math.sqrt(Math.pow(this.quadSize, 2.0) + Math.pow(this.quadSize, 2.0)) / 2.0;
        this.aabb = new AABB(-this.diagonalSize, -this.diagonalSize, -this.diagonalSize, this.diagonalSize, this.diagonalSize, this.diagonalSize);
    }

    public void tick() {
        Level level;
        if (!this.hasInitializedParameters) {
            return;
        }
        Vec3 currentPos = new Vec3(this.getX(), this.getY(), this.getZ());
        BlockPos blockPos = WaveHelpers.toBlockPos(currentPos);
        if (((Boolean)Config.COMMON.debug.get()).booleanValue() && (level = this.level) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (this.level.getGameTime() % 10L == 0L) {
                server.sendParticles((ParticleOptions)ParticleTypes.CLOUD, currentPos.x() + this.random.nextGaussian() * 0.1, currentPos.y() + 0.25 + this.random.nextDouble() * 0.1, currentPos.z() + this.random.nextGaussian() * 0.1, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        double distance = currentPos.distanceTo(this.shorePos);
        boolean hasFluidBelow = !this.level.getFluidState(blockPos.below()).isEmpty();
        int waveSprite = WaveHelpers.updateSprite(this.initialDistance, distance, 3.0);
        double vecSpeed = new Vec3(this.xd, 0.0, this.zd).length();
        if (!this.hasReachedShore && !hasFluidBelow) {
            this.xd *= 0.95;
            this.zd *= 0.95;
            if (vecSpeed <= 0.01) {
                Vec3 vecInverse = WaveHelpers.inverse(this.direction);
                this.zd = vecInverse.z() * 0.015;
                this.xd = vecInverse.x() * 0.015;
                this.hasReachedShore = true;
            }
            this.hasTouchedLand = true;
        }
        if (this.hasReachedShore && currentPos.distanceTo(this.shorePos) <= 2.0) {
            double speedFactor = 1.0 + (0.05 - WaveHelpers.applyEaseOutQuart(this.direction, distance, 5.0, 0.5, 1.0).length() * 0.02);
            this.xd *= speedFactor;
            this.zd *= speedFactor;
        }
        this.move(MoverType.SELF, new Vec3(this.xd, 0.0, this.zd));
        this.depositBlock(currentPos, this.waveSpriteOld);
        if (this.hasPlacedBlock || this.age > 600 || hasFluidBelow && this.hasTouchedLand) {
            this.discard();
            this.kill();
        }
        if (this.waveSpriteOld <= waveSprite) {
            this.waveSpriteOld = waveSprite;
        }
        ++this.age;
        if (((Boolean)Config.COMMON.waveEntityInteraction.get()).booleanValue() && this.level.getGameTime() % (long)((Integer)Config.COMMON.waveInteractionUpdateFrequency.get()).intValue() == 0L) {
            AABB box = this.aabb.move(currentPos).inflate(2.0);
            List entityList = this.level.getEntitiesOfClass(Entity.class, box);
            block0: for (Entity entity : entityList) {
                if (entity instanceof Wave) continue;
                boolean isWhitelisted = WaveHelpers.isEntity(entity, WavesTags.Entities.WAVE_INTERACTION_WHITELIST);
                boolean isBlacklisted = WaveHelpers.isEntity(entity, WavesTags.Entities.WAVE_INTERACTION_BLACKLIST);
                if ((!isWhitelisted || isBlacklisted) && (isWhitelisted || isBlacklisted)) continue;
                double sizeNorm = ((double)this.size - 3.0) / 11.0;
                double sizeForceFactor = sizeNorm + 0.5;
                Vec3 sizeFactor = new Vec3(0.125, 0.125, 0.125).scale(sizeNorm * 3.0 + 1.0);
                for (double i = 0.0; i < 7.0; i += 1.0) {
                    ServerLevel server;
                    Level level2;
                    double spacing = (i / 3.0 - 1.0) * (double)this.quadSize * 0.5;
                    Vec3 offsetVec = new Vec3(spacing, 0.0, 0.0).yRot((float)(-this.angleToShore + 1.5707963267948966));
                    Vec3 aabbCenter = offsetVec.add(currentPos);
                    AABB aabb = new AABB(Vec3.ZERO, sizeFactor).move(aabbCenter);
                    if (entity.getBoundingBox().intersects(aabb)) {
                        if (this.level.getGameTime() % 1L + (long)this.random.nextInt(8) == 0L && (level2 = this.level) instanceof ServerLevel) {
                            server = (ServerLevel)level2;
                            double entityWidth = (double)entity.getBbWidth() * 0.5;
                            server.sendParticles((ParticleOptions)ParticleTypes.SPLASH, entity.getX() + this.random.nextGaussian() * entityWidth * 0.8, currentPos.y() - 0.1 + this.random.nextDouble() * 0.2, entity.getZ() + this.random.nextGaussian() * entityWidth * 0.8, 1, 0.0, 0.0, 0.0, 0.0);
                            server.sendParticles((ParticleOptions)ParticleTypes.BUBBLE, entity.getX() + this.random.nextGaussian() * entityWidth * 0.8, currentPos.y() - 0.1 + this.random.nextDouble() * 0.2, entity.getZ() + this.random.nextGaussian() * entityWidth * 0.8, 1, 0.0, 0.0, 0.0, 0.0);
                        }
                        entity.setDeltaMovement(entity.getDeltaMovement().add(new Vec3(this.xd * 0.025, (double)this.quadSize * 0.0015, this.zd * 0.025).scale(sizeForceFactor).scale(((Double)Config.COMMON.waveInteractionForceFactor.get()).doubleValue())));
                        continue block0;
                    }
                    if (!((Boolean)Config.COMMON.debug.get()).booleanValue() || !((level2 = this.level) instanceof ServerLevel)) continue;
                    server = (ServerLevel)level2;
                    server.sendParticles((ParticleOptions)ParticleTypes.FLAME, aabbCenter.x(), aabbCenter.y(), aabbCenter.z(), 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public void depositBlock(Vec3 currentPos, int waveSprite) {
        if (!this.hasPlacedBlock && this.hasReachedShore && waveSprite >= (Integer)Config.COMMON.waveSpriteCount.get() - 1) {
            this.hasPlacedBlock = true;
            RandomSource random = this.level.getRandom();
            if (random.nextInt(((Integer)Config.COMMON.waveBlockDepositChance.get()).intValue()) == 0) {
                BlockPos posDeposit = WaveHelpers.getRandomBlockPosAlongWave(this.level, random, currentPos, this.direction, this.size, this.seaLevel);
                BlockState stateDeposit = WaveHelpers.getFastBlockState(this.level, posDeposit);
                BlockState stateDepositBelow = WaveHelpers.getFastBlockState(this.level, posDeposit.below());
                Optional<Block> depositBlock = WaveHelpers.randomBlock(WavesTags.Blocks.TIDE_POOL_BLOCKS, random);
                if (!depositBlock.isEmpty()) {
                    BlockState depositState = depositBlock.get().defaultBlockState();
                    if ((stateDeposit.isAir() || stateDeposit.canBeReplaced()) && stateDepositBelow.getFluidState().isEmpty() && depositState.canSurvive((LevelReader)this.level, posDeposit)) {
                        this.level.setBlockAndUpdate(posDeposit, depositState);
                    }
                }
            }
        }
    }

    public void setSize(double length, double height, double width) {
        this.bbWidth = (float)width;
        this.bbHeight = (float)height;
        this.setBoundingBox(new AABB(-length, -width, -height, length, width, height));
    }

    public Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
    }
}

