/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.wires;

import commoble.morered.wires.WireUpdatePacket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.neoforge.network.PacketDistributor;

public class WireUpdateBuffer
extends SavedData {
    public static final String ID = "morered:wireupdatebuffer";
    public static final SavedData.Factory<WireUpdateBuffer> FACTORY = new SavedData.Factory(WireUpdateBuffer::new, (tag, registries) -> new WireUpdateBuffer());
    private Map<ChunkPos, Set<BlockPos>> buffer = new HashMap<ChunkPos, Set<BlockPos>>();

    public static WireUpdateBuffer get(ServerLevel world) {
        return (WireUpdateBuffer)world.getDataStorage().computeIfAbsent(FACTORY, ID);
    }

    public void enqueue(BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        this.buffer.computeIfAbsent(chunkPos, $ -> new HashSet()).add(pos.immutable());
    }

    public void sendPackets(ServerLevel world) {
        if (this.buffer.size() > 0) {
            this.buffer.forEach((chunkPos, positions) -> {
                if (world.hasChunk(chunkPos.x, chunkPos.z)) {
                    PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)world, (ChunkPos)chunkPos, (CustomPacketPayload)new WireUpdatePacket((Set<BlockPos>)positions), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            });
            this.buffer = new HashMap<ChunkPos, Set<BlockPos>>();
        }
    }

    public CompoundTag save(CompoundTag compound, HolderLookup.Provider registries) {
        return compound;
    }
}

