/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.wires;

import com.google.common.cache.LoadingCache;
import commoble.morered.MoreRed;
import commoble.morered.api.ChanneledPowerSupplier;
import commoble.morered.api.ExpandedPowerSupplier;
import commoble.morered.api.MoreRedAPI;
import commoble.morered.api.WireConnector;
import commoble.morered.api.internal.DefaultWireProperties;
import commoble.morered.api.internal.WireVoxelHelpers;
import commoble.morered.util.BlockStateUtil;
import commoble.morered.util.DirectionHelper;
import commoble.morered.wires.AbstractWireBlock;
import commoble.morered.wires.PoweredWireBlock;
import commoble.morered.wires.WireBlockEntity;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ColoredCableBlock
extends PoweredWireBlock {
    public static final VoxelShape[] NODE_SHAPES_DUNSWE = WireVoxelHelpers.makeNodeShapes(2, 3);
    public static final VoxelShape[] RAYTRACE_BACKBOARDS = WireVoxelHelpers.makeRaytraceBackboards(3);
    public static final VoxelShape[] LINE_SHAPES = WireVoxelHelpers.makeLineShapes(2, 3);
    public static final VoxelShape[] SHAPES_BY_STATE_INDEX = AbstractWireBlock.makeVoxelShapes(NODE_SHAPES_DUNSWE, LINE_SHAPES);
    public static final LoadingCache<Long, VoxelShape> VOXEL_CACHE = AbstractWireBlock.makeVoxelCache(SHAPES_BY_STATE_INDEX, LINE_SHAPES);
    private final DyeColor color;

    public DyeColor getDyeColor() {
        return this.color;
    }

    public ColoredCableBlock(BlockBehaviour.Properties properties, DyeColor color) {
        super(properties, SHAPES_BY_STATE_INDEX, RAYTRACE_BACKBOARDS, VOXEL_CACHE, false);
        this.color = color;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)MoreRed.get().coloredNetworkCableBeType.get()).create(pos, state);
    }

    public boolean canConnectToAdjacentWireOrCable(BlockGetter world, BlockPos thisPos, BlockState thisState, BlockPos wirePos, BlockState wireState, Direction wireFace, Direction directionToWire) {
        Block wireBlock = wireState.getBlock();
        return wireBlock instanceof ColoredCableBlock && ((ColoredCableBlock)wireBlock).getDyeColor() != this.getDyeColor() ? false : AbstractWireBlock.canWireConnectToAdjacentWireOrCable(world, thisPos, thisState, wirePos, wireState, wireFace, directionToWire);
    }

    @Override
    protected boolean canAdjacentBlockConnectToFace(BlockGetter world, BlockPos thisPos, BlockState thisState, Block neighborBlock, Direction attachmentDirection, Direction directionToWire, BlockPos neighborPos, BlockState neighborState) {
        return neighborBlock instanceof ColoredCableBlock ? ((ColoredCableBlock)neighborBlock).canConnectToAdjacentWireOrCable(world, neighborPos, neighborState, thisPos, thisState, attachmentDirection, directionToWire) : MoreRedAPI.getWireConnectabilityRegistry().getOrDefault(neighborBlock, MoreRedAPI.getDefaultWireConnector()).canConnectToAdjacentWire(world, neighborPos, neighborState, thisPos, thisState, attachmentDirection, directionToWire) || MoreRedAPI.getCableConnectabilityRegistry().getOrDefault(neighborBlock, MoreRedAPI.getDefaultCableConnector()).canConnectToAdjacentWire(world, neighborPos, neighborState, thisPos, thisState, attachmentDirection, directionToWire);
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        if (!(world instanceof Level)) {
            return;
        }
        Level level = (Level)world;
        Direction directionFromNeighbor = DirectionHelper.getDirectionToNeighborPos(neighbor, pos);
        if (directionFromNeighbor == null) {
            return;
        }
        if (level.getCapability(MoreRedAPI.CHANNELED_POWER_CAPABILITY, neighbor, (Object)directionFromNeighbor) != null) {
            this.updatePowerAfterBlockUpdate(level, pos, state);
        }
    }

    @Override
    protected void updatePowerAfterBlockUpdate(Level world, BlockPos wirePos, BlockState wireState) {
        BlockEntity te = world.getBlockEntity(wirePos);
        if (!(te instanceof WireBlockEntity)) {
            return;
        }
        WireBlockEntity wire = (WireBlockEntity)te;
        Map<Block, WireConnector> wireConnectors = MoreRedAPI.getWireConnectabilityRegistry();
        Map<Block, ExpandedPowerSupplier> expandedPowerSuppliers = MoreRedAPI.getExpandedPowerRegistry();
        WireConnector defaultWireConnector = MoreRedAPI.getDefaultWireConnector();
        ExpandedPowerSupplier defaultPowerSupplier = MoreRedAPI.getDefaultExpandedPowerSupplier();
        Map<Block, WireConnector> cableConnectors = MoreRedAPI.getCableConnectabilityRegistry();
        WireConnector defaultCableConnector = MoreRedAPI.getDefaultCableConnector();
        EnumMap<Direction, ChanneledPowerSupplier> neighborPowerSuppliers = new EnumMap<Direction, ChanneledPowerSupplier>(Direction.class);
        ChanneledPowerSupplier noPower = DefaultWireProperties.NO_POWER_SUPPLIER;
        Function<BlockPos, Function> neighborPowerFinder = neighborPos -> directionToNeighbor -> {
            ChanneledPowerSupplier p = (ChanneledPowerSupplier)world.getCapability(MoreRedAPI.CHANNELED_POWER_CAPABILITY, neighborPos, (Object)directionToNeighbor.getOpposite());
            return p == null ? noPower : p;
        };
        int channel = this.getDyeColor().ordinal();
        BlockPos.MutableBlockPos mutaPos = wirePos.mutable();
        BlockState[] neighborStates = new BlockState[6];
        boolean anyPowerUpdated = false;
        EnumSet<Direction> facesNeedingUpdates = EnumSet.noneOf(Direction.class);
        boolean[] attachedFaceStates = new boolean[6];
        for (int attachmentSide = 0; attachmentSide < 6; ++attachmentSide) {
            if (((Boolean)wireState.getValue((Property)INTERIOR_FACES[attachmentSide])).booleanValue()) {
                attachedFaceStates[attachmentSide] = true;
                facesNeedingUpdates.add(Direction.from3DDataValue((int)attachmentSide));
                continue;
            }
            if (!wire.setPower(attachmentSide, 0)) continue;
            anyPowerUpdated = true;
        }
        int iteration = 0;
        while (!facesNeedingUpdates.isEmpty()) {
            ChanneledPowerSupplier attachedNeighborPowerSupplier;
            int attachmentSide;
            Direction attachmentDirection;
            if (!facesNeedingUpdates.remove(attachmentDirection = Direction.from3DDataValue((int)(attachmentSide = iteration++ % 6)))) continue;
            int power = 0;
            mutaPos.setWithOffset((Vec3i)wirePos, attachmentDirection);
            BlockState attachedNeighborState = neighborStates[attachmentSide];
            if (attachedNeighborState == null) {
                neighborStates[attachmentSide] = attachedNeighborState = world.getBlockState((BlockPos)mutaPos);
            }
            if ((attachedNeighborPowerSupplier = (ChanneledPowerSupplier)neighborPowerSuppliers.get(attachmentDirection)) == null) {
                attachedNeighborPowerSupplier = (ChanneledPowerSupplier)neighborPowerFinder.apply((BlockPos)mutaPos).apply(attachmentDirection);
                neighborPowerSuppliers.put(attachmentDirection, attachedNeighborPowerSupplier);
            }
            int weakNeighborPower = attachedNeighborState.getSignal((BlockGetter)world, (BlockPos)mutaPos, attachmentDirection);
            int neighborPower = this.useIndirectPower && attachedNeighborState.shouldCheckWeakPower((SignalGetter)world, (BlockPos)mutaPos, attachmentDirection) ? Math.max(weakNeighborPower, world.getDirectSignalTo((BlockPos)mutaPos)) : weakNeighborPower;
            power = Math.max(power, neighborPower * 2 - 1);
            power = Math.max(power, attachedNeighborPowerSupplier.getPowerOnChannel(world, wirePos, wireState, attachmentDirection, channel) - 1);
            for (int orthagonal = 0; orthagonal < 4; ++orthagonal) {
                BlockEntity diagonalTe;
                WireConnector cableConnector;
                Block neighborBlock;
                WireConnector wireConnector;
                int neighborSide = DirectionHelper.uncompressSecondSide(attachmentSide, orthagonal);
                Direction directionToNeighbor = Direction.from3DDataValue((int)neighborSide);
                Direction directionToWire = directionToNeighbor.getOpposite();
                BlockState neighborState = neighborStates[neighborSide];
                mutaPos.setWithOffset((Vec3i)wirePos, directionToNeighbor);
                if (neighborState == null) {
                    neighborStates[neighborSide] = neighborState = world.getBlockState((BlockPos)mutaPos);
                }
                if ((wireConnector = wireConnectors.getOrDefault(neighborBlock = neighborState.getBlock(), defaultWireConnector)).canConnectToAdjacentWire((BlockGetter)world, (BlockPos)mutaPos, neighborState, wirePos, wireState, attachmentDirection, directionToWire)) {
                    ExpandedPowerSupplier expandedPowerSupplier = expandedPowerSuppliers.getOrDefault(neighborBlock, defaultPowerSupplier);
                    int expandedWeakNeighborPower = expandedPowerSupplier.getExpandedPower(world, (BlockPos)mutaPos, neighborState, wirePos, wireState, attachmentDirection, directionToNeighbor);
                    int expandedNeighborPower = this.useIndirectPower && neighborState.shouldCheckWeakPower((SignalGetter)world, (BlockPos)mutaPos, directionToNeighbor) ? Math.max(expandedWeakNeighborPower, world.getDirectSignalTo((BlockPos)mutaPos) * 2) : expandedWeakNeighborPower;
                    power = Math.max(power, expandedNeighborPower - 1);
                }
                if ((cableConnector = cableConnectors.getOrDefault(neighborBlock, defaultCableConnector)).canConnectToAdjacentWire((BlockGetter)world, (BlockPos)mutaPos, neighborState, wirePos, wireState, attachmentDirection, directionToWire)) {
                    ChanneledPowerSupplier orthagonalPowerSupplier = (ChanneledPowerSupplier)neighborPowerSuppliers.get(directionToNeighbor);
                    if (orthagonalPowerSupplier == null) {
                        orthagonalPowerSupplier = (ChanneledPowerSupplier)neighborPowerFinder.apply((BlockPos)mutaPos).apply(directionToNeighbor);
                        neighborPowerSuppliers.put(directionToNeighbor, orthagonalPowerSupplier);
                    }
                    power = Math.max(power, orthagonalPowerSupplier.getPowerOnChannel(world, wirePos, wireState, attachmentDirection, channel) - 1);
                }
                if (directionToNeighbor != attachmentDirection) {
                    power = Math.max(power, wire.getPower(neighborSide) - 1);
                }
                if (attachedFaceStates[neighborSide] || neighborBlock != this || ((Boolean)neighborState.getValue((Property)INTERIOR_FACES[attachmentSide])).booleanValue()) continue;
                BlockPos.MutableBlockPos diagonalPos = mutaPos.move(attachmentDirection);
                BlockState diagonalState = world.getBlockState((BlockPos)mutaPos);
                int directionToWireSide = directionToWire.ordinal();
                if (diagonalState.getBlock() != this || !((Boolean)diagonalState.getValue((Property)INTERIOR_FACES[directionToWireSide])).booleanValue() || !((diagonalTe = world.getBlockEntity((BlockPos)diagonalPos)) instanceof WireBlockEntity)) continue;
                power = Math.max(power, ((WireBlockEntity)diagonalTe).getPower(directionToWireSide) - 1);
            }
            if (!wire.setPower(attachmentSide, power)) continue;
            anyPowerUpdated = true;
            Direction[] nextUpdateDirs = BlockStateUtil.OUTPUT_TABLE[attachmentSide];
            for (int i = 0; i < 4; ++i) {
                Direction nextUpdateDir = nextUpdateDirs[i];
                if (!attachedFaceStates[nextUpdateDir.ordinal()]) continue;
                facesNeedingUpdates.add(nextUpdateDir);
            }
        }
        if (anyPowerUpdated && !world.isClientSide) {
            this.notifyNeighbors(world, wirePos, wireState, EnumSet.allOf(Direction.class), true);
        }
    }
}

