/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.event;

import alexthw.ars_elemental.api.IUndeadSummon;
import alexthw.ars_elemental.api.item.ISchoolFocus;
import alexthw.ars_elemental.common.entity.summon.AllyVhexEntity;
import alexthw.ars_elemental.common.entity.summon.SummonCamel;
import alexthw.ars_elemental.common.entity.summon.SummonDirewolf;
import alexthw.ars_elemental.common.entity.summon.SummonDolphin;
import alexthw.ars_elemental.common.entity.summon.SummonSkeleHorse;
import alexthw.ars_elemental.common.entity.summon.SummonStrider;
import alexthw.ars_elemental.common.entity.summon.SummonUndead;
import alexthw.ars_elemental.common.items.armor.SummonPerk;
import alexthw.ars_elemental.common.items.foci.NecroticFocus;
import alexthw.ars_elemental.registry.ModRegistry;
import com.hollingsworth.arsnouveau.api.entity.ISummon;
import com.hollingsworth.arsnouveau.api.event.SummonEvent;
import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.common.entity.EntityAllyVex;
import com.hollingsworth.arsnouveau.common.entity.IFollowingSummon;
import com.hollingsworth.arsnouveau.common.entity.SummonHorse;
import com.hollingsworth.arsnouveau.common.entity.SummonSkeleton;
import com.hollingsworth.arsnouveau.common.entity.SummonWolf;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import java.util.Set;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, modid="ars_elemental")
public class SummonEvents {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void summonedEvent(SummonEvent event) {
        Set<SpellSchool> foci = ISchoolFocus.getFociSchools(event.shooter);
        if (!event.world.isClientSide && !foci.isEmpty()) {
            Object object;
            if (foci.contains(SpellSchools.NECROMANCY) && event.summon.getLivingEntity() != null) {
                event.summon.getLivingEntity().addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 500, 1));
                event.summon.getLivingEntity().addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 500, 1));
            }
            if ((object = event.summon) instanceof SummonHorse) {
                SummonHorse oldHorse = (SummonHorse)object;
                object = event.shooter;
                if (object instanceof ServerPlayer) {
                    ServerPlayer summoner = (ServerPlayer)object;
                    block12: for (SpellSchool focus : foci) {
                        switch (focus.getId()) {
                            case "water": {
                                SummonDolphin newHorse = new SummonDolphin(oldHorse, (Player)summoner);
                                if (newHorse.getOwnerUUID() == null) break block12;
                                oldHorse.remove(Entity.RemovalReason.DISCARDED);
                                event.summon = newHorse;
                                event.world.addFreshEntity((Entity)newHorse);
                                CriteriaTriggers.SUMMONED_ENTITY.trigger(summoner, (Entity)newHorse);
                                break;
                            }
                            case "fire": {
                                SummonStrider newHorse = new SummonStrider(oldHorse, (Player)summoner);
                                if (newHorse.getOwnerUUID() == null) break block12;
                                oldHorse.remove(Entity.RemovalReason.DISCARDED);
                                event.summon = newHorse;
                                event.world.addFreshEntity((Entity)newHorse);
                                CriteriaTriggers.SUMMONED_ENTITY.trigger(summoner, (Entity)newHorse);
                                break;
                            }
                            case "earth": {
                                SummonCamel newHorse = new SummonCamel(oldHorse, (Player)summoner);
                                if (newHorse.getOwnerUUID() == null) break block12;
                                oldHorse.remove(Entity.RemovalReason.DISCARDED);
                                event.summon = newHorse;
                                event.world.addFreshEntity((Entity)newHorse);
                                CriteriaTriggers.SUMMONED_ENTITY.trigger(summoner, (Entity)newHorse);
                                break;
                            }
                            case "necromancy": {
                                SummonSkeleHorse newHorse = new SummonSkeleHorse(oldHorse, (Player)summoner);
                                if (newHorse.getOwnerUUID() == null) break block12;
                                oldHorse.remove(Entity.RemovalReason.DISCARDED);
                                event.summon = newHorse;
                                event.world.addFreshEntity((Entity)newHorse);
                                CriteriaTriggers.SUMMONED_ENTITY.trigger(summoner, (Entity)newHorse);
                                break;
                            }
                            default: {
                                continue block12;
                            }
                        }
                        break;
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void reRaiseSummon(SummonEvent.Death event) {
        if (!event.world.isClientSide) {
            LivingEntity owner;
            ServerLevel world = (ServerLevel)event.world;
            ISummon iSummon = event.summon;
            if (iSummon instanceof IFollowingSummon) {
                IFollowingSummon summon = (IFollowingSummon)iSummon;
                v0 = summon.getSummoner();
            } else {
                v0 = owner = event.summon.getOwner();
            }
            if (owner instanceof Player) {
                Player player = (Player)owner;
                if (!(event.summon instanceof IUndeadSummon) && NecroticFocus.hasFocus(event.world, (Entity)player)) {
                    IUndeadSummon toRaise = null;
                    ISummon iSummon2 = event.summon;
                    if (iSummon2 instanceof SummonWolf) {
                        SummonWolf wolf = (SummonWolf)iSummon2;
                        toRaise = new SummonDirewolf((Level)world, player, wolf);
                    } else {
                        iSummon2 = event.summon;
                        if (iSummon2 instanceof EntityAllyVex) {
                            EntityAllyVex vex = (EntityAllyVex)iSummon2;
                            toRaise = new AllyVhexEntity((Level)world, vex, player);
                        } else {
                            iSummon2 = event.summon;
                            if (iSummon2 instanceof SummonSkeleton) {
                                SummonSkeleton skelly = (SummonSkeleton)iSummon2;
                                toRaise = new SummonUndead((Level)world, skelly, player);
                            }
                        }
                    }
                    if (toRaise instanceof IUndeadSummon) {
                        IUndeadSummon undead = toRaise;
                        undead.inherit(event.summon);
                        event.world.addFreshEntity((Entity)toRaise);
                        NecroticFocus.spawnDeathPoof(world, toRaise.blockPosition());
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void summonSickReduction(MobEffectEvent.Added event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance.getEffect() == ModPotions.SUMMONING_SICKNESS_EFFECT) {
            effectInstance.duration = effectInstance.getDuration() * (1 - PerkUtil.countForPerk((IPerk)SummonPerk.INSTANCE, (LivingEntity)event.getEntity()) / 10);
        }
    }

    @SubscribeEvent
    public static void summonPowerup(LivingDamageEvent.Pre event) {
        Entity entity = event.getSource().getEntity();
        if (entity instanceof ISummon) {
            LivingEntity livingEntity;
            ISummon summon = (ISummon)entity;
            if (event.getEntity().level() instanceof ServerLevel && (livingEntity = summon.getOwner()) instanceof Player) {
                Player player = (Player)livingEntity;
                event.setNewDamage((float)((double)event.getNewDamage() + player.getAttributeValue(ModRegistry.SUMMON_POWER)));
                if (summon instanceof SummonWolf) {
                    Set<SpellSchool> schools = ISchoolFocus.getFociSchools((LivingEntity)player);
                    for (SpellSchool school : schools) {
                        switch (school.getId()) {
                            case "fire": {
                                event.getEntity().setRemainingFireTicks(100);
                                break;
                            }
                            case "water": {
                                event.getEntity().addEffect(new MobEffectInstance((Holder)ModPotions.FREEZING_EFFECT, 100, 1));
                                break;
                            }
                            case "air": {
                                event.getEntity().addEffect(new MobEffectInstance((Holder)ModPotions.SHOCKED_EFFECT, 100, 1));
                                break;
                            }
                            case "earth": {
                                event.getEntity().addEffect(new MobEffectInstance(MobEffects.POISON, 100));
                            }
                        }
                    }
                }
            }
        }
    }
}

