/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.event;

import alexthw.ars_elemental.registry.ModAdvTriggers;
import alexthw.ars_elemental.registry.ModRegistry;
import com.hollingsworth.arsnouveau.common.entity.EntityHomingProjectileSpell;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.items.EnchantersShield;
import com.hollingsworth.arsnouveau.common.items.data.ReactiveCasterData;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.EnchantmentRegistry;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingShieldBlockEvent;

@EventBusSubscriber(modid="ars_elemental")
public class ShieldEvents {
    @SubscribeEvent
    public static void onBlock(ProjectileImpactEvent event) {
        Projectile projectile = event.getProjectile();
        if (projectile instanceof EntityProjectileSpell) {
            int level;
            ItemStack stack;
            Player player;
            EntityHitResult result;
            EntityProjectileSpell projectileSpell = (EntityProjectileSpell)projectile;
            projectile = event.getRayTraceResult();
            if (projectile instanceof EntityHitResult && (projectile = (result = (EntityHitResult)projectile).getEntity()) instanceof Player && (player = (Player)projectile).isBlocking() && (stack = player.getOffhandItem()).getItem() instanceof EnchantersShield && (double)(level = stack.getEnchantmentLevel(player.level.holderOrThrow(ModRegistry.MIRROR))) * 0.25 >= Math.random()) {
                projectileSpell.setDeltaMovement(projectileSpell.getDeltaMovement().reverse().add(0.0, 0.2, 0.0));
                if (projectileSpell instanceof EntityHomingProjectileSpell) {
                    EntityHomingProjectileSpell homing = (EntityHomingProjectileSpell)projectileSpell;
                    if (level > 3) {
                        homing.getIgnored().add(e -> e == player);
                    }
                }
                if (player instanceof ServerPlayer && CapabilityRegistry.getMana((LivingEntity)player) != null) {
                    ((PlayerTrigger)ModAdvTriggers.MIRROR.get()).trigger((ServerPlayer)player);
                    float pay = (float)projectileSpell.spellResolver.getResolveCost() / ((float)level * 2.0f);
                    CapabilityRegistry.getMana((LivingEntity)player).removeMana((double)pay);
                    player.getCooldowns().addCooldown(stack.getItem(), 20 * level);
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockReactive(LivingShieldBlockEvent event) {
        Object object;
        Player player;
        block6: {
            block5: {
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof Player)) break block5;
                player = (Player)livingEntity;
                if (!player.getCommandSenderWorld().isClientSide) break block6;
            }
            return;
        }
        ItemStack s = player.getOffhandItem();
        if (s.getItem() instanceof EnchantersShield && (object = s.get((Supplier)DataComponentRegistry.REACTIVE_CASTER)) instanceof ReactiveCasterData) {
            ReactiveCasterData reactiveCaster = (ReactiveCasterData)object;
            if ((double)s.getEnchantmentLevel(player.level.holderOrThrow(EnchantmentRegistry.REACTIVE_ENCHANTMENT)) * 0.25 >= Math.random() && reactiveCaster.getSpell().isValid()) {
                reactiveCaster.castSpell(player.getCommandSenderWorld(), (LivingEntity)player, InteractionHand.OFF_HAND, null);
            }
        }
    }

    @SubscribeEvent
    public static void onSonicImpact(LivingIncomingDamageEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player) || !((livingEntity = (player = (Player)livingEntity).getCommandSenderWorld()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)livingEntity;
        ItemStack s = player.getOffhandItem();
        if (level.holder(ModRegistry.MIRROR).isEmpty()) {
            return;
        }
        if (s.getItem() instanceof EnchantersShield && player.isBlocking() && (double)s.getEnchantmentLevel(level.holderOrThrow(ModRegistry.MIRROR)) * 0.25 >= Math.random() && event.getSource().getSourcePosition() != null && event.getSource().is(DamageTypes.SONIC_BOOM) && CapabilityRegistry.getMana((LivingEntity)player) != null) {
            Vec3 vec3 = player.getViewVector(1.0f);
            Vec3 vec31 = event.getSource().getSourcePosition().vectorTo(player.position()).normalize();
            vec31 = new Vec3(vec31.x, 0.0, vec31.z);
            if (vec31.dot(vec3) < 0.0) {
                ShieldEvents.reflectSonicBoom(event, player, s, level);
            }
        }
    }

    private static void reflectSonicBoom(LivingIncomingDamageEvent event, Player player, ItemStack stack, ServerLevel level) {
        event.setCanceled(true);
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity reflectTo = (LivingEntity)entity;
        Vec3 vec3 = player.getEyePosition();
        Vec3 vec31 = reflectTo.position().add(0.0, (double)1.6f, 0.0).subtract(vec3);
        Vec3 vec32 = vec31.normalize();
        for (int i = 1; i < Mth.floor((double)vec31.length()) + 7; ++i) {
            Vec3 vec33 = vec3.add(vec32.scale((double)i));
            level.sendParticles((ParticleOptions)ParticleTypes.SONIC_BOOM, vec33.x, vec33.y, vec33.z, 1, 0.0, 0.0, 0.0, 0.0);
        }
        player.playSound(SoundEvents.WARDEN_SONIC_BOOM, 3.0f, 1.0f);
        reflectTo.hurt(player.damageSources().sonicBoom((Entity)player), 10.0f);
        double d1 = 0.5 * (1.0 - reflectTo.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
        double d0 = 2.5 * (1.0 - reflectTo.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
        reflectTo.push(vec32.x() * d0, vec32.y() * d1, vec32.z() * d0);
        CapabilityRegistry.getMana((LivingEntity)player).removeMana(150.0);
        player.getCooldowns().addCooldown(stack.getItem(), 20 * stack.getEnchantmentLevel(level.holderOrThrow(ModRegistry.MIRROR)));
        player.stopUsingItem();
    }
}

