/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.datagen;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.common.glyphs.EffectConjureTerrain;
import alexthw.ars_elemental.common.glyphs.EffectDischarge;
import alexthw.ars_elemental.common.glyphs.EffectEnvenom;
import alexthw.ars_elemental.common.glyphs.EffectSpark;
import alexthw.ars_elemental.common.glyphs.EffectSpores;
import alexthw.ars_elemental.common.glyphs.MethodArcProjectile;
import alexthw.ars_elemental.common.glyphs.MethodHomingProjectile;
import alexthw.ars_elemental.registry.ModItems;
import alexthw.ars_elemental.util.ParticleUtil;
import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.api.sound.ConfiguredSpellSound;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.crafting.recipes.CasterTomeData;
import com.hollingsworth.arsnouveau.common.datagen.CasterTomeProvider;
import com.hollingsworth.arsnouveau.common.items.CasterTome;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectColdSnap;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectCrush;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectDelay;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectFlare;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectFreeze;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectGravity;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHex;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectIgnite;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLaunch;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLinger;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSmelt;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSummonSteed;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectWindshear;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import com.hollingsworth.arsnouveau.common.spell.method.MethodSelf;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.common.spell.method.MethodUnderfoot;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.registries.DeferredHolder;

public class AECasterTomeProvider
extends CasterTomeProvider {
    public AECasterTomeProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public void collectJsons(CachedOutput cache) {
        this.tomes.add(this.buildTome(ModItems.SHAPERS_CTOME, "glassmaker", "Safety Jar", new Spell().add((AbstractSpellPart)MethodUnderfoot.INSTANCE).add((AbstractSpellPart)EffectConjureTerrain.INSTANCE).add((AbstractSpellPart)AugmentAOE.INSTANCE, 3).add((AbstractSpellPart)AugmentPierce.INSTANCE, 3).add((AbstractSpellPart)EffectCrush.INSTANCE).add((AbstractSpellPart)EffectSmelt.INSTANCE), "Encase yourself in glass.", ParticleUtil.airColor));
        this.tomes.add(this.buildTome(ModItems.WATER_CTOME, "dolphin", "Poseidon's Steed", new Spell().add((AbstractSpellPart)MethodSelf.INSTANCE).add((AbstractSpellPart)EffectSummonSteed.INSTANCE).add((AbstractSpellPart)AugmentAOE.INSTANCE).add((AbstractSpellPart)AugmentExtendTime.INSTANCE).add((AbstractSpellPart)AugmentExtendTime.INSTANCE), "Summon two rideable Dolphins for a short time.", ParticleUtil.waterColor));
        this.tomes.add(this.buildTome(ModItems.FIRE_CTOME, "strider", "It's Striding Time", new Spell().add((AbstractSpellPart)MethodSelf.INSTANCE).add((AbstractSpellPart)EffectSummonSteed.INSTANCE).add((AbstractSpellPart)AugmentExtendTime.INSTANCE).add((AbstractSpellPart)AugmentExtendTime.INSTANCE), "Summon a rideable Strider for a short time.", ParticleUtil.fireColor));
        this.tomes.add(this.buildTome(ModItems.EARTH_CTOME, "camel", "Humpday", new Spell().add((AbstractSpellPart)MethodSelf.INSTANCE).add((AbstractSpellPart)EffectSummonSteed.INSTANCE).add((AbstractSpellPart)AugmentExtendTime.INSTANCE).add((AbstractSpellPart)AugmentExtendTime.INSTANCE), "Summon a Camel for a short time.", ParticleUtil.earthColor));
        this.tomes.add(this.buildTome(ModItems.EARTH_CTOME, "magnet", "Gravity Well", new Spell().add((AbstractSpellPart)MethodArcProjectile.INSTANCE).add((AbstractSpellPart)EffectGravity.INSTANCE).add((AbstractSpellPart)AugmentSensitive.INSTANCE).add((AbstractSpellPart)AugmentAOE.INSTANCE).add((AbstractSpellPart)AugmentExtendTime.INSTANCE).add((AbstractSpellPart)EffectLinger.INSTANCE).add((AbstractSpellPart)AugmentSensitive.INSTANCE).add((AbstractSpellPart)EffectLaunch.INSTANCE).add((AbstractSpellPart)AugmentDampen.INSTANCE), "Creates a gravity center that also attract nearby blocks.", ParticleUtil.earthColor));
        this.tomes.add(this.buildTome(ModItems.FIRE_CTOME, "hellflare", "Magiflare", new Spell().add((AbstractSpellPart)MethodHomingProjectile.INSTANCE).add((AbstractSpellPart)EffectIgnite.INSTANCE).add((AbstractSpellPart)EffectHex.INSTANCE).add((AbstractSpellPart)EffectFlare.INSTANCE), "These wicked flames cook so well that even armor becomes weaker to magic.", ParticleUtil.fireColor));
        this.tomes.add(this.buildTome(ModItems.WATER_CTOME, "frostbite", "Frostbite", new Spell().add((AbstractSpellPart)MethodHomingProjectile.INSTANCE).add((AbstractSpellPart)EffectFreeze.INSTANCE).add((AbstractSpellPart)EffectColdSnap.INSTANCE), "It's not easy to heal while you're a meat popsicle.", ParticleUtil.waterColor));
        this.tomes.add(this.buildTome(ModItems.AIR_CTOME, "zap", "Static Discharge", new Spell().add((AbstractSpellPart)MethodTouch.INSTANCE).add((AbstractSpellPart)EffectSpark.INSTANCE).add((AbstractSpellPart)EffectDischarge.INSTANCE), "Starbchu, I Choose You!.", ParticleUtil.airColor));
        this.tomes.add(this.buildTome(ModItems.AIR_CTOME, "leviosa", "Shulkium Leviosa", new Spell().add((AbstractSpellPart)MethodProjectile.INSTANCE).add((AbstractSpellPart)EffectLaunch.INSTANCE).add((AbstractSpellPart)AugmentExtendTime.INSTANCE).add((AbstractSpellPart)AugmentExtendTime.INSTANCE).add((AbstractSpellPart)EffectDelay.INSTANCE).add((AbstractSpellPart)EffectWindshear.INSTANCE).add((AbstractSpellPart)EffectDelay.INSTANCE).add((AbstractSpellPart)EffectWindshear.INSTANCE), "Way worse than being shulked, wind feels sharp today.", ParticleUtil.airColor));
        this.tomes.add(this.buildTome(ModItems.EARTH_CTOME, "flower", "Poison Blossom", new Spell().add((AbstractSpellPart)MethodTouch.INSTANCE).add((AbstractSpellPart)EffectEnvenom.INSTANCE).add((AbstractSpellPart)EffectSpores.INSTANCE), "May the venom become the seed of a flower that will blossom in undeath.", ParticleUtil.earthColor));
        this.tomes.add(this.buildTome(ModItems.NECRO_CTOME, "skelehorse", "Undead Steed", new Spell().add((AbstractSpellPart)MethodSelf.INSTANCE).add((AbstractSpellPart)EffectSummonSteed.INSTANCE).add((AbstractSpellPart)AugmentExtendTime.INSTANCE).add((AbstractSpellPart)AugmentExtendTime.INSTANCE), "Summon a Skeletal Horse for a short time.", ParticleUtil.soulColor));
        Path output = this.generator.getPackOutput().getOutputFolder();
        for (CasterTomeProvider.CasterRecipeWrapper g : this.tomes) {
            Path path = this.getRecipePath(output, g.id().getPath());
            this.saveStable(cache, (JsonElement)CasterTomeData.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)g.toData()).getOrThrow(), path);
        }
    }

    public CasterTomeProvider.CasterRecipeWrapper buildTome(DeferredHolder<Item, ? extends CasterTome> item, String id, String name, Spell spell, String flavorText, ParticleColor particleColor) {
        return new CasterTomeProvider.CasterRecipeWrapper(ArsElemental.prefix(id + "_tome"), name, spell.serializeRecipe(), item.getId(), flavorText, particleColor.serialize(), ConfiguredSpellSound.DEFAULT);
    }

    protected Path getRecipePath(Path pathIn, String str) {
        return pathIn.resolve("data/ars_elemental/recipe/tomes/" + str + ".json");
    }

    public String getName() {
        return "Ars Elemental Caster Tomes Datagen";
    }
}

