/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.rituals.forest;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.registry.ModItems;
import alexthw.ars_elemental.world.ModWorldgen;
import com.hollingsworth.arsnouveau.api.ritual.ConjureBiomeRitual;
import com.hollingsworth.arsnouveau.common.block.ArchfruitPod;
import com.hollingsworth.arsnouveau.setup.registry.BiomeRegistry;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ArchwoodForestRitual
extends ConjureBiomeRitual {
    public static String ID = "ritual_archwood_forest";

    public ArchwoodForestRitual() {
        super(BiomeRegistry.ARCHWOOD_FOREST);
    }

    public void onStart(@Nullable Player player) {
        super.onStart(player);
        Optional<Block> pod = this.getConsumedItems().stream().map(ItemStack::getItem).filter(item -> {
            BlockItem bi;
            return item instanceof BlockItem && (bi = (BlockItem)item).getBlock() instanceof ArchfruitPod;
        }).map(item -> ((BlockItem)item).getBlock()).findFirst();
        if (pod.isPresent()) {
            if (pod.get() == BlockRegistry.BOMBEGRANTE_POD.get()) {
                this.biome = ModWorldgen.Biomes.BLAZING_FOREST_KEY;
            } else if (pod.get() == BlockRegistry.FROSTAYA_POD.get()) {
                this.biome = ModWorldgen.Biomes.CASCADING_FOREST_KEY;
            } else if (pod.get() == BlockRegistry.MENDOSTEEN_POD.get()) {
                this.biome = ModWorldgen.Biomes.FLOURISHING_FOREST_KEY;
            } else if (pod.get() == ModItems.FLASHING_POD.get()) {
                this.biome = ModWorldgen.Biomes.FLASHING_FOREST_KEY;
            }
        }
    }

    public BlockState stateForPos(BlockPos nextPos) {
        return nextPos.getY() == this.getPos().getY() - 1 ? Blocks.GRASS_BLOCK.defaultBlockState() : Blocks.DIRT.defaultBlockState();
    }

    public boolean canConsumeItem(ItemStack stack) {
        BlockItem bi;
        Item item;
        boolean pod = this.getConsumedItems().stream().anyMatch(i -> {
            BlockItem bi;
            Item patt0$temp = i.getItem();
            return patt0$temp instanceof BlockItem && (bi = (BlockItem)patt0$temp).getBlock() instanceof ArchfruitPod;
        });
        return super.canConsumeItem(stack) || (item = stack.getItem()) instanceof BlockItem && (bi = (BlockItem)item).getBlock() instanceof ArchfruitPod && !pod;
    }

    public ResourceLocation getRegistryName() {
        return ArsElemental.prefix(ID);
    }

    public String getLangName() {
        return "Conjure Island: Archwood Forest";
    }

    public String getLangDescription() {
        return "Creates an island of grass and dirt in a circle around the ritual, converting the area to an Archwood Forest. Augmenting with an Elemental Archfruit with convert to a thematic forest. The island will generate with a radius of 7 blocks. Augmenting the ritual with Source Gems will increase the radius by 1 for each gem. Source must be provided nearby as blocks are generated.";
    }

    public void write(HolderLookup.Provider provider, CompoundTag tag) {
        super.write(provider, tag);
        if (this.biome != BiomeRegistry.ARCHWOOD_FOREST) {
            tag.putString("biome", this.biome.location().toString());
        }
    }

    public void read(HolderLookup.Provider provider, CompoundTag tag) {
        super.read(provider, tag);
        if (tag.contains("biome")) {
            this.biome = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.parse((String)tag.getString("biome")));
        }
    }
}

