/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.mob_effects;

import alexthw.ars_elemental.registry.ModPotions;
import alexthw.ars_elemental.util.EntityCarryMEI;
import java.util.Set;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.neoforged.neoforge.common.EffectCure;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import org.jetbrains.annotations.NotNull;

public class LifeLinkEffect
extends MobEffect {
    public LifeLinkEffect() {
        super(MobEffectCategory.NEUTRAL, 1);
        NeoForge.EVENT_BUS.addListener(this::healForHeal);
        NeoForge.EVENT_BUS.addListener(this::hurtForHurt);
    }

    public void fillEffectCures(@NotNull Set<EffectCure> cures, @NotNull MobEffectInstance effectInstance) {
    }

    public void healForHeal(LivingHealEvent event) {
        EntityCarryMEI mei;
        MobEffectInstance instance;
        if (event.getEntity().hasEffect(ModPotions.LIFE_LINK) && (instance = event.getEntity().getEffect(ModPotions.LIFE_LINK)) instanceof EntityCarryMEI && (mei = (EntityCarryMEI)instance).getTarget() == event.getEntity()) {
            if (mei.getOwner().isAlive()) {
                int shared = (int)(event.getAmount() / 2.0f);
                mei.getOwner().heal((float)shared);
                event.setAmount((float)shared);
            } else {
                event.getEntity().removeEffect(ModPotions.LIFE_LINK);
            }
        }
    }

    public void hurtForHurt(LivingDamageEvent.Pre event) {
        EntityCarryMEI mei;
        MobEffectInstance instance;
        if (event.getEntity().hasEffect(ModPotions.LIFE_LINK) && (instance = event.getEntity().getEffect(ModPotions.LIFE_LINK)) instanceof EntityCarryMEI && (mei = (EntityCarryMEI)instance).getOwner() == event.getEntity()) {
            if (mei.getTarget().isAlive()) {
                int shared = (int)(event.getNewDamage() / 2.0f);
                mei.getTarget().hurt(event.getSource(), (float)shared);
                event.setNewDamage((float)shared);
            } else {
                event.getEntity().removeEffect(ModPotions.LIFE_LINK);
            }
        }
    }
}

