/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.glyphs;

import alexthw.ars_elemental.common.glyphs.ElementalAbstractForm;
import alexthw.ars_elemental.util.GlyphEffectUtil;
import com.hollingsworth.arsnouveau.api.entity.ISummon;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.CastResolveType;
import com.hollingsworth.arsnouveau.api.spell.IFilter;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.entity.EntityHomingProjectileSpell;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarEntity;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAccelerate;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDecelerate;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSplit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.ModConfigSpec;

public class MethodHomingProjectile
extends ElementalAbstractForm {
    public static MethodHomingProjectile INSTANCE = new MethodHomingProjectile();
    public ModConfigSpec.IntValue PROJECTILE_TTL;

    public MethodHomingProjectile() {
        super("homing_projectile", "Homing Projectile");
    }

    public String getBookDescription() {
        return "This projectile seek the nearest entity and follow it, will behave as a classic projectile while there are no valid targets. Players will only be targeted if augmented by Sensitive.";
    }

    public void summonProjectiles(Level world, LivingEntity shooter, SpellStats stats, SpellResolver resolver, List<Predicate<LivingEntity>> ignore) {
        int numSplits = 1 + stats.getBuffCount((AbstractAugment)AugmentSplit.INSTANCE);
        ArrayList<EntityHomingProjectileSpell> projectiles = new ArrayList<EntityHomingProjectileSpell>();
        for (int i = 0; i < numSplits; ++i) {
            EntityHomingProjectileSpell spell = new EntityHomingProjectileSpell(world, resolver);
            projectiles.add(spell);
        }
        float velocity = MethodHomingProjectile.getProjectileSpeed(stats);
        int opposite = -1;
        int counter = 0;
        for (EntityHomingProjectileSpell proj : projectiles) {
            proj.setIgnored(ignore);
            proj.shoot((Entity)shooter, shooter.getXRot(), shooter.getYRot() + (float)(Math.round((double)counter / 2.0) * 5L * (long)opposite), 0.0f, velocity, 0.8f);
            opposite *= -1;
            ++counter;
            world.addFreshEntity((Entity)proj);
        }
    }

    public static float getProjectileSpeed(SpellStats stats) {
        return Math.max(0.2f, 0.5f + stats.getAccMultiplier() / 5.0f);
    }

    public CastResolveType onCast(ItemStack stack, LivingEntity shooter, Level world, SpellStats spellStats, SpellContext context, SpellResolver resolver) {
        ISummon summon;
        List<Predicate<LivingEntity>> ignore = MethodHomingProjectile.basicIgnores(shooter, spellStats.hasBuff((AbstractAugment)AugmentSensitive.INSTANCE), resolver.spell);
        if (shooter instanceof Player) {
            ignore.add(entity -> {
                if (!(entity instanceof ISummon)) return false;
                ISummon summon = (ISummon)entity;
                if (!shooter.getUUID().equals(summon.getOwnerUUID())) return false;
                return true;
            });
            ignore.add(entity -> {
                OwnableEntity pet;
                return entity instanceof OwnableEntity && shooter.equals((Object)(pet = (OwnableEntity)entity).getOwner());
            });
        } else if (shooter instanceof ISummon && (summon = (ISummon)shooter).getOwnerUUID() != null) {
            ignore.add(entity -> {
                if (!(entity instanceof ISummon)) return false;
                ISummon summon2 = (ISummon)entity;
                if (!summon.getOwnerUUID().equals(summon2.getOwnerUUID())) return false;
                return true;
            });
            ignore.add(entity -> {
                if (!(entity instanceof OwnableEntity)) return false;
                OwnableEntity pet = (OwnableEntity)entity;
                if (!summon.getOwnerUUID().equals(pet.getOwnerUUID())) return false;
                return true;
            });
        }
        this.summonProjectiles(world, shooter, spellStats, resolver, ignore);
        return CastResolveType.SUCCESS;
    }

    public CastResolveType onCastOnBlock(UseOnContext context, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Level world = context.getLevel();
        Player shooter = context.getPlayer();
        this.onCast(null, (LivingEntity)shooter, world, spellStats, spellContext, resolver);
        return CastResolveType.SUCCESS;
    }

    public CastResolveType onCastOnBlock(BlockHitResult blockRayTraceResult, LivingEntity caster, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        return CastResolveType.FAILURE;
    }

    public CastResolveType onCastOnEntity(ItemStack stack, LivingEntity caster, Entity target, InteractionHand hand, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        this.onCast(stack, caster, caster.level(), spellStats, spellContext, resolver);
        return CastResolveType.SUCCESS;
    }

    public int getDefaultManaCost() {
        return 75;
    }

    public SpellTier defaultTier() {
        return SpellTier.THREE;
    }

    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        defaults.put(AugmentPierce.INSTANCE.getRegistryName(), 1);
    }

    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentPierce.INSTANCE, AugmentSplit.INSTANCE, AugmentAccelerate.INSTANCE, AugmentDecelerate.INSTANCE, AugmentSensitive.INSTANCE});
    }

    public static List<Predicate<LivingEntity>> basicIgnores(LivingEntity shooter, Boolean targetPlayers, Spell spell) {
        Set<IFilter> filters;
        ArrayList<Predicate<LivingEntity>> ignore = new ArrayList<Predicate<LivingEntity>>();
        ignore.add(entity -> !entity.isAlive());
        ignore.add(entity -> entity == shooter);
        ignore.add(entity -> entity instanceof FamiliarEntity);
        ignore.add(entity -> entity.hasEffect(MobEffects.INVISIBILITY));
        ignore.add(arg_0 -> ((LivingEntity)shooter).isAlliedTo(arg_0));
        if (!targetPlayers.booleanValue()) {
            ignore.add(entity -> entity instanceof Player);
        }
        if (!(filters = GlyphEffectUtil.getFilters(spell.unsafeList(), 0)).isEmpty()) {
            ignore.add(entity -> GlyphEffectUtil.checkIgnoreFilters((Entity)entity, filters));
        }
        return ignore;
    }

    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        super.addAugmentDescriptions(map);
        map.put((AbstractAugment)AugmentPierce.INSTANCE, "Projectiles will pierce through enemies and blocks an additional time.");
        map.put((AbstractAugment)AugmentSplit.INSTANCE, "Creates multiple projectiles.");
        map.put((AbstractAugment)AugmentAccelerate.INSTANCE, "Projectiles will move faster.");
        map.put((AbstractAugment)AugmentDecelerate.INSTANCE, "Projectiles will move slower.");
        map.put((AbstractAugment)AugmentSensitive.INSTANCE, "Projectiles will also target players.");
    }

    public void buildConfig(ModConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.PROJECTILE_TTL = builder.comment("Max lifespan of the projectile, in seconds.").defineInRange("max_lifespan", 30, 0, Integer.MAX_VALUE);
    }
}

