/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.glyphs;

import alexthw.ars_elemental.common.glyphs.ElementalAbstractEffect;
import alexthw.ars_elemental.registry.ModItems;
import alexthw.ars_elemental.registry.ModPotions;
import alexthw.ars_elemental.util.EntityCarryMEI;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.IPotionEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

public class EffectLifeLink
extends ElementalAbstractEffect
implements IPotionEffect {
    public static EffectLifeLink INSTANCE = new EffectLifeLink();

    public EffectLifeLink() {
        super("life_link", "Life Link");
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        LivingEntity livingEntity;
        Entity entity = rayTraceResult.getEntity();
        if (entity instanceof LivingEntity && shooter != (livingEntity = (LivingEntity)entity)) {
            LivingEntity owner;
            LivingEntity entity2 = spellStats.isSensitive() ? shooter : livingEntity;
            LivingEntity livingEntity2 = owner = spellStats.isSensitive() ? livingEntity : shooter;
            if (resolver.hasFocus((Item)ModItems.NECRO_FOCUS.get())) {
                this.forceApplyPotion(entity2, owner, (Holder<MobEffect>)ModPotions.LIFE_LINK, spellStats);
            } else {
                this.applyPotion(entity2, owner, (Holder<MobEffect>)ModPotions.LIFE_LINK, spellStats);
            }
        }
    }

    public SpellTier defaultTier() {
        return SpellTier.THREE;
    }

    public int getDefaultManaCost() {
        return 30;
    }

    public void buildConfig(ModConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addDefaultPotionConfig(builder);
    }

    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentExtendTime.INSTANCE, AugmentDurationDown.INSTANCE, AugmentSensitive.INSTANCE});
    }

    public void applyPotion(LivingEntity entity, LivingEntity owner, Holder<MobEffect> potionEffect, SpellStats stats) {
        if (entity == null || owner == null) {
            return;
        }
        int ticks = this.getBaseDuration() * 20 + this.getExtendTimeDuration() * stats.getDurationInTicks();
        entity.addEffect((MobEffectInstance)new EntityCarryMEI(potionEffect, ticks, 0, false, true, owner, entity));
        owner.addEffect((MobEffectInstance)new EntityCarryMEI(potionEffect, ticks, 0, false, true, owner, entity));
    }

    public void forceApplyPotion(LivingEntity entity, LivingEntity owner, Holder<MobEffect> potionEffect, SpellStats stats) {
        if (entity == null || owner == null) {
            return;
        }
        int ticks = this.getBaseDuration() * 20 + this.getExtendTimeDuration() * stats.getDurationInTicks();
        entity.forceAddEffect((MobEffectInstance)new EntityCarryMEI(potionEffect, ticks, 0, false, true, owner, entity), (Entity)entity);
        owner.forceAddEffect((MobEffectInstance)new EntityCarryMEI(potionEffect, ticks, 0, false, true, owner, entity), (Entity)owner);
    }

    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        super.addAugmentDescriptions(map);
        map.put((AbstractAugment)AugmentSensitive.INSTANCE, "Inverts the direction of the link, sharing your healing with the target and receiving half of their damage.");
    }

    public String getBookDescription() {
        return "You create a link between your life force and the target's. Any damage dealt to you will be shared with the target and any healing of the target will be shared with you equally. Using sensitive reverses the direction of the link. Cut can sever the life link, ending the effect on both sides.";
    }

    public int getBaseDuration() {
        return this.POTION_TIME == null ? 30 : (Integer)this.POTION_TIME.get();
    }

    public int getExtendTimeDuration() {
        return this.EXTEND_TIME == null ? 8 : (Integer)this.EXTEND_TIME.get();
    }
}

